import { defineComponent, ref, onMounted, unref, withCtx, createVNode, useSSRContext, computed, reactive, createTextVNode, toDisplayString, createBlock, openBlock, resolveDynamicComponent } from "vue";
import { ssrRenderComponent, ssrRenderAttr, ssrRenderSlot, ssrRenderList, ssrInterpolate, ssrRenderVNode } from "vue/server-renderer";
/* empty css                       */
/* empty css                              */
/* empty css                           */
/* empty css             */
import $ from "jquery";
import SimpleBar from "simplebar";
import ResizeObserver from "resize-observer-polyfill";
import { usePage, Head, Link } from "@inertiajs/vue3";
import { u as useHexToRgb } from "./useHexToRgb-G7J9N7Ap.js";
import { trans, wTrans } from "laravel-vue-i18n";
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "ErrorLayout",
  __ssrInlineRender: true,
  props: {
    data: {}
  },
  setup(__props) {
    const props = __props;
    const dark = ref(usePage().props.dark);
    if (typeof window !== "undefined") {
      $(() => {
        let config = { attributes: true, attributeFilter: ["id"] };
        let callback = function(mutationsList, observer2) {
          for (let mutation of mutationsList) {
            if (mutation.type === "attributes" && mutation.attributeName === "id") {
              if (document.body.id == "dark") dark.value = true;
              else dark.value = false;
            }
          }
        };
        let observer = new MutationObserver(callback);
        observer.observe(document.body, config);
      });
    }
    if (typeof window !== "undefined") {
      onMounted(() => {
        window.ResizeObserver = ResizeObserver;
        document.querySelectorAll(".simplebar-container").forEach((el) => {
          new SimpleBar(el, {
            autoHide: true
          });
        });
      });
    }
    onMounted(() => {
      if (props.data.template != null) {
        document.documentElement.style.setProperty("--main-background", props.data.template.get_options.style.site_background_color);
        document.documentElement.style.setProperty("--primary", props.data.template.get_options.style.site_main_color);
        document.documentElement.style.setProperty("--primary-rgb", useHexToRgb(props.data.template.get_options.style.site_main_color));
        document.documentElement.style.setProperty("--secondary", props.data.template.get_options.style.site_secondary_color);
        document.documentElement.style.setProperty("--secondary-rgb", useHexToRgb(props.data.template.get_options.style.site_secondary_color));
        document.documentElement.style.setProperty("--shadow-1", props.data.template.get_options.style.site_main_shadow);
      }
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), null, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<link rel="icon" type="image/x-icon"${ssrRenderAttr("href", _ctx.data.appFavicon)}${_scopeId}><meta name="theme-color"${ssrRenderAttr("content", dark.value ? "#262631" : props.data.template != null ? props.data.template.get_options.style.site_main_color : "#1c1c25")}${_scopeId}>`);
          } else {
            return [
              createVNode("link", {
                rel: "icon",
                type: "image/x-icon",
                href: _ctx.data.appFavicon
              }, null, 8, ["href"]),
              createVNode("meta", {
                name: "theme-color",
                content: dark.value ? "#262631" : props.data.template != null ? props.data.template.get_options.style.site_main_color : "#1c1c25"
              }, null, 8, ["content"])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`<div class="page-wrapper">`);
      ssrRenderSlot(_ctx.$slots, "default", {}, null, _push, _parent);
      _push(`</div><!--]-->`);
    };
  }
});
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Layouts/ErrorLayout.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "Error",
  __ssrInlineRender: true,
  props: {
    status: {},
    data: {}
  },
  setup(__props) {
    const props = __props;
    const title = computed(() => {
      return {
        503: trans("messages.sentence.error_503"),
        500: trans("messages.sentence.error_500"),
        404: trans("messages.sentence.error_404"),
        403: trans("messages.sentence.error_403")
      }[props.status];
    });
    const description = computed(() => {
      return {
        503: trans("messages.sentence.error_503_message"),
        500: trans("messages.sentence.error_500_message"),
        404: trans("messages.sentence.error_404_message"),
        403: trans("messages.sentence.error_403_message")
      }[props.status];
    });
    let randomProductsData = null;
    if (props.data != void 0 && props.data != null) {
      randomProductsData = reactive({
        product_list: {
          id: 458756,
          label: wTrans("messages.sentence.may_be_products"),
          archive: {},
          products: props.data.products
        }
      });
    }
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.status + " - " + title.value
      }, null, _parent));
      if (_ctx.data != void 0 && _ctx.data != null) {
        _push(`<header class="header-three mb-4"><div class="container"><div class="header-section d-flex align-items-center justify-content-between mt-3 pb-3"><div class="d-flex justify-content-end align-items-center">`);
        if (_ctx.data.header_menu != null) {
          _push(`<ul class="nav flex-grow-1 d-md-flex d-none"><!--[-->`);
          ssrRenderList(_ctx.data.header_menu.get_items, (item, index) => {
            _push(`<li class="nav-item">`);
            if (item.type == "internal") {
              _push(ssrRenderComponent(unref(Link), {
                class: "nav-link lts-05",
                href: item.link
              }, {
                default: withCtx((_, _push2, _parent2, _scopeId) => {
                  if (_push2) {
                    _push2(`${ssrInterpolate(item.name)}`);
                  } else {
                    return [
                      createTextVNode(toDisplayString(item.name), 1)
                    ];
                  }
                }),
                _: 2
              }, _parent));
            } else {
              _push(`<!---->`);
            }
            if (item.type == "external") {
              _push(`<a class="nav-link lts-05"${ssrRenderAttr("href", item.link)} target="_blank">${ssrInterpolate(item.name)}</a>`);
            } else {
              _push(`<!---->`);
            }
            _push(`</li>`);
          });
          _push(`<!--]--></ul>`);
        } else {
          _push(`<!---->`);
        }
        if (_ctx.data.header_menu != null) {
          _push(`<div class="navigation-container dropdown d-md-none d-block"><a class="navigation-container--icon el-center shadow-1" href="javascript:void(0)" role="button" data-bs-toggle="dropdown" aria-expanded="false"><i class="ri-menu-3-line"></i></a><ul class="dropdown-menu shadow-1"><!--[-->`);
          ssrRenderList(_ctx.data.header_menu.get_items, (item, index) => {
            _push(`<li class="nav-item">`);
            if (item.type == "internal") {
              _push(ssrRenderComponent(unref(Link), {
                class: "dropdown-item lts-05",
                href: item.link
              }, {
                default: withCtx((_, _push2, _parent2, _scopeId) => {
                  if (_push2) {
                    _push2(`${ssrInterpolate(item.name)}`);
                  } else {
                    return [
                      createTextVNode(toDisplayString(item.name), 1)
                    ];
                  }
                }),
                _: 2
              }, _parent));
            } else {
              _push(`<!---->`);
            }
            if (item.type == "external") {
              _push(`<a class="dropdown-item lts-05"${ssrRenderAttr("href", item.link)} target="_blank">${ssrInterpolate(item.name)}</a>`);
            } else {
              _push(`<!---->`);
            }
            _push(`</li>`);
          });
          _push(`<!--]--></ul></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div><div class="d-flex align-items-center"><div class="logo-container">`);
        _push(ssrRenderComponent(unref(Link), {
          class: "logo",
          href: _ctx.data.appUrl
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              if (_ctx.data.appLogo != null) {
                _push2(`<img${ssrRenderAttr("src", _ctx.data.appLogo)}${ssrRenderAttr("alt", _ctx.data.appFullName)}${_scopeId}>`);
              } else {
                _push2(`<span${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.logo"))}</span>`);
              }
            } else {
              return [
                _ctx.data.appLogo != null ? (openBlock(), createBlock("img", {
                  key: 0,
                  src: _ctx.data.appLogo,
                  alt: _ctx.data.appFullName
                }, null, 8, ["src", "alt"])) : (openBlock(), createBlock("span", { key: 1 }, toDisplayString(_ctx.$t("messages.word.logo")), 1))
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</div></div></div></div></header>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="page-content"><div class="container pb-4"><div class="row mb-5 mt-4"><div class="col-12 error-content d-flex flex-column align-items-center justify-content-center"><div class="error-content--icon d-flex align-items-center justify-content-center">`);
      if (_ctx.status == 404) {
        _push(`<!--[--><div class="el-center"><span>4</span></div><div class="zero shadow-1 el-center"><span>0</span></div><div class="el-center"><span>4</span></div><!--]-->`);
      } else {
        _push(`<div class="el-center"><span>${ssrInterpolate(_ctx.status)}</span></div>`);
      }
      _push(`</div><div class="error-content--info d-flex flex-column align-items-center justify-content-center"><h1 class="lts-05 mb-3">${ssrInterpolate(title.value)}</h1><p class="lts-05">${ssrInterpolate(description.value)}</p>`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("index"),
        class: "link lts-05"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("messages.sentence.return_to_shop"))} <i class="ri-arrow-left-fill"${_scopeId}></i>`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("messages.sentence.return_to_shop")) + " ", 1),
              createVNode("i", { class: "ri-arrow-left-fill" })
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div></div></div></div>`);
      if (_ctx.data != void 0 && _ctx.data != null && unref(randomProductsData) != null) {
        _push(`<!--[-->`);
        if (_ctx.data != null && unref(randomProductsData).product_list.products.length > 0) {
          ssrRenderVNode(_push, createVNode(resolveDynamicComponent("ProductList3"), {
            component_id: unref(randomProductsData).product_list.id,
            data: unref(randomProductsData),
            status: "prod"
          }, null), _parent);
        } else {
          _push(`<!---->`);
        }
        _push(`<!--]-->`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Errors/Error.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
