import { defineComponent, computed, unref, withCtx, createTextVNode, toDisplayString, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate } from "vue/server-renderer";
/* empty css               */
import { Head, Link } from "@inertiajs/vue3";
import { trans } from "laravel-vue-i18n";
import { _ as _export_sfc } from "../ssr.js";
import "@vue/server-renderer";
import "@inertiajs/vue3/server";
import "ziggy-js";
import "axios";
import "lodash/debounce.js";
import "swiper/bundle";
import "jquery";
import "swiper";
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "Error",
  __ssrInlineRender: true,
  props: {
    status: {}
  },
  setup(__props) {
    const props = __props;
    const title = computed(() => {
      return {
        503: trans("messages.sentence.error_503"),
        500: trans("messages.sentence.error_500"),
        404: trans("messages.sentence.error_404"),
        403: trans("messages.sentence.error_403")
      }[props.status];
    });
    const description = computed(() => {
      return {
        503: trans("messages.sentence.error_503_message"),
        500: trans("messages.sentence.error_500_message"),
        404: trans("messages.sentence.error_404_message"),
        403: trans("messages.sentence.error_403_message")
      }[props.status];
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.status + " - " + title.value
      }, null, _parent));
      _push(`<div class="errors" data-v-fc706f49><h1 class="title" data-v-fc706f49>${ssrInterpolate(title.value)}</h1><p class="description" data-v-fc706f49>${ssrInterpolate(description.value)}</p>`);
      _push(ssrRenderComponent(unref(Link), {
        class: "link",
        href: _ctx.route("seller.dashboard")
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("messages.sentence.return_to_dashboard"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("messages.sentence.return_to_dashboard")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Store/Errors/Error.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const Error = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-fc706f49"]]);
export {
  Error as default
};
