import { defineComponent, ref, mergeProps, useSSRContext, computed, watch, reactive, provide, onMounted, unref, withCtx, createVNode, onBeforeUnmount, inject, resolveDirective, resolveDynamicComponent, createBlock, createCommentVNode, createTextVNode, openBlock, toDisplayString } from "vue";
import { ssrRenderAttrs, ssrRenderAttr, ssrRenderClass, ssrInterpolate, ssrRenderComponent, ssrRenderSlot, ssrGetDirectiveProps, ssrRenderStyle, ssrRenderVNode, ssrRenderList, ssrIncludeBooleanAttr, ssrLooseEqual, ssrLooseContain } from "vue/server-renderer";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css                           */
/* empty css             */
/* empty css              */
import $$1 from "jquery";
import SimpleBar from "simplebar";
import ResizeObserver from "resize-observer-polyfill";
import { usePage, router, Head, useForm } from "@inertiajs/vue3";
import { u as useToast } from "./useToastify-D_n0s7Uc.js";
import { a as _sfc_main$4, _ as _sfc_main$7 } from "./Files-B6eiTnN6.js";
import { u as useHexToRgb } from "./useHexToRgb-G7J9N7Ap.js";
import Sortable from "sortablejs/modular/sortable.complete.esm.js";
import * as Coloris from "@melloware/coloris";
import * as Bootstrap from "bootstrap";
import Dropdown from "primevue/dropdown/dropdown.esm.js";
import _sfc_main$5 from "./ShopElements-B7ugJoz7.js";
import _sfc_main$6 from "./BlogElements-CQgSuLEo.js";
import _sfc_main$8 from "./ChooseTopBanner-B4MMlz_L.js";
import ChooseHeader from "./ChooseHeader-d7FVDwFp.js";
import ChooseFooter from "./ChooseFooter-C_0SCgSx.js";
import { _ as _sfc_main$9 } from "./Stories-8MVPY0LE.js";
import { u as useRandomStr } from "./useRandomStr-4MeWbtRd.js";
import { EditorState } from "@codemirror/state";
import { EditorView, lineNumbers, keymap } from "@codemirror/view";
import { javascript } from "@codemirror/lang-javascript";
import { css } from "@codemirror/lang-css";
import { basicSetup } from "codemirror";
import { defaultKeymap } from "@codemirror/commands";
import { syntaxHighlighting, HighlightStyle } from "@codemirror/language";
import { tags } from "@lezer/highlight";
import { _ as _export_sfc } from "../ssr.js";
import MultiSelect from "primevue/multiselect/multiselect.esm.js";
import { _ as _sfc_main$a } from "./Ckeditor-BEPE8WxA.js";
import "toastify-js";
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "laravel-vue-i18n";
import "./Pagination-C1AQrLe3.js";
import "./SearchList-BZnYMQPN.js";
import "lodash/debounce.js";
import "./useRandomNum-DNNSqR7b.js";
import "@vue/server-renderer";
import "@inertiajs/vue3/server";
import "ziggy-js";
import "axios";
import "swiper/bundle";
import "swiper";
const _sfc_main$3 = /* @__PURE__ */ defineComponent({
  __name: "PageBuilderHeader",
  __ssrInlineRender: true,
  setup(__props) {
    const dark = ref(usePage().props.dark);
    if (typeof window !== "undefined") {
      if (dark.value) {
        $$1("body").attr("id", "dark");
      } else {
        $$1("body").attr("id", "light");
      }
    }
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<header${ssrRenderAttrs(mergeProps({ class: "page-header-builder full" }, _attrs))}><div class="header-inner"><div class="d-flex align-items-center"><a${ssrRenderAttr("href", _ctx.route("admin.templates.index"))} class="sidebar-toggle link"><i class="ri-arrow-right-line"></i></a><a class="${ssrRenderClass({ "d-none d-sm-block btn btn-light lts-05 fs-8 px-3 br-10 ms-3": true })}"${ssrRenderAttr("href", _ctx.route("index"))} target="_blank">${ssrInterpolate(_ctx.$t("messages.sentence.show_store"))}</a><a class="${ssrRenderClass({ "d-block d-sm-none link text-dark lts-05 fs-5 ms-3": true })}"${ssrRenderAttr("href", _ctx.route("index"))} target="_blank"><i class="ri-store-2-line"></i></a></div><ul class="header-meta"><li id="darkLight"><button><i class="${ssrRenderClass(dark.value ? "ri-sun-line" : "ri-moon-line")}"></i></button></li><li><a href="javascript:void(0)"><i class="ri-fullscreen-line"></i></a></li><li class="user-avatar"><img class="shadow-1"${ssrRenderAttr("src", _ctx.$page.props.auth.user.get_avatar)} width="40" height="40"${ssrRenderAttr("alt", _ctx.$page.props.auth.user.get_name)}><div class="d-md-block d-none"><span class="user-name">${ssrInterpolate(_ctx.$page.props.auth.user.get_name)}</span><span class="user-type-simple">${ssrInterpolate(_ctx.$page.props.auth.user.role.label)}</span></div></li></ul></div></header>`);
    };
  }
});
const _sfc_setup$3 = _sfc_main$3.setup;
_sfc_main$3.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Admin/PageBuilderHeader.vue");
  return _sfc_setup$3 ? _sfc_setup$3(props, ctx) : void 0;
};
const _sfc_main$2 = /* @__PURE__ */ defineComponent({
  __name: "PageBuilderLayout",
  __ssrInlineRender: true,
  props: {
    mediaLibrary: {},
    keyword: {}
  },
  setup(__props) {
    const dark = ref(usePage().props.dark);
    if (typeof window !== "undefined") {
      $$1(() => {
        let config = { attributes: true, attributeFilter: ["id"] };
        let callback = function(mutationsList, observer2) {
          for (let mutation of mutationsList) {
            if (mutation.type === "attributes" && mutation.attributeName === "id") {
              if (document.body.id == "dark") dark.value = true;
              else dark.value = false;
            }
          }
        };
        let observer = new MutationObserver(callback);
        observer.observe(document.body, config);
      });
    }
    if (typeof window !== "undefined") {
      $$1(() => {
        window.jalaliDatepicker.startWatch({});
      });
    }
    if (typeof window !== "undefined") {
      $$1(() => {
        window.ResizeObserver = ResizeObserver;
        document.querySelectorAll(".simplebar-container").forEach((el) => {
          new SimpleBar(el, {
            autoHide: false
          });
        });
      });
    }
    const errorMessages = computed(() => {
      return usePage().props.errors;
    });
    watch(errorMessages, (errors) => {
      for (let i in errors) {
        useToast(errors[i], "fail", 4e3);
      }
      if (errorMessages.value != null && Object.keys(errorMessages.value).length > 0) {
        router.reload({ only: ["errors"] });
      }
    });
    const flashMessage = computed(() => {
      if (typeof usePage().props.flash !== "undefined") {
        return usePage().props.flash.message;
      }
      return [];
    });
    watch(flashMessage, (messages) => {
      for (let i in messages) {
        useToast(messages[i], "success", 4e3);
      }
      if (flashMessage.value != null && Object.keys(flashMessage.value).length > 0) {
        router.reload({ only: ["flash"] });
      }
    });
    const mediaReactive = reactive({
      type: "",
      file: null
    });
    const mediaData = (value) => {
      mediaReactive.type = value.type;
      mediaReactive.file = value.file;
    };
    provide("mediaData", mediaReactive);
    onMounted(() => {
      if (usePage().props.template != null) {
        document.documentElement.style.setProperty("--main-background", usePage().props.template.get_options.style.site_background_color);
        document.documentElement.style.setProperty("--primary", usePage().props.template.get_options.style.site_main_color);
        document.documentElement.style.setProperty("--primary-rgb", useHexToRgb(usePage().props.template.get_options.style.site_main_color));
        document.documentElement.style.setProperty("--secondary", usePage().props.template.get_options.style.site_secondary_color);
        document.documentElement.style.setProperty("--secondary-rgb", useHexToRgb(usePage().props.template.get_options.style.site_secondary_color));
        document.documentElement.style.setProperty("--shadow-1", usePage().props.template.get_options.style.site_main_shadow);
      }
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), null, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<link rel="icon" type="image/x-icon"${ssrRenderAttr("href", _ctx.$page.props.appFavicon)}${_scopeId}><meta name="theme-color"${ssrRenderAttr("content", dark.value ? "#262631" : unref(usePage)().props.template.get_options.style.site_main_color)}${_scopeId}><meta name="robots" content="noindex,nofollow"${_scopeId}><meta name="googlebot" content="noindex"${_scopeId}>`);
          } else {
            return [
              createVNode("link", {
                rel: "icon",
                type: "image/x-icon",
                href: _ctx.$page.props.appFavicon
              }, null, 8, ["href"]),
              createVNode("meta", {
                name: "theme-color",
                content: dark.value ? "#262631" : unref(usePage)().props.template.get_options.style.site_main_color
              }, null, 8, ["content"]),
              createVNode("meta", {
                name: "robots",
                content: "noindex,nofollow"
              }),
              createVNode("meta", {
                name: "googlebot",
                content: "noindex"
              })
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`<div class="page-wrapper">`);
      _push(ssrRenderComponent(_sfc_main$3, null, null, _parent));
      ssrRenderSlot(_ctx.$slots, "default", {}, null, _push, _parent);
      _push(`</div>`);
      _push(ssrRenderComponent(_sfc_main$4, {
        mediaLibrary: _ctx.mediaLibrary,
        keyword: _ctx.keyword,
        onMediaData: mediaData
      }, null, _parent));
      _push(`<!--]-->`);
    };
  }
});
const _sfc_setup$2 = _sfc_main$2.setup;
_sfc_main$2.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Layouts/PageBuilderLayout.vue");
  return _sfc_setup$2 ? _sfc_setup$2(props, ctx) : void 0;
};
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "CodeMirror",
  __ssrInlineRender: true,
  props: {
    modelValue: {},
    language: {}
  },
  emits: ["update:modelValue"],
  setup(__props, { emit: __emit }) {
    const props = __props;
    const emit = __emit;
    const editorRef = ref(null);
    let editorView = null;
    const fullHeightExtension = EditorView.theme({
      ".cm-scroller": {
        height: "400px",
        overflow: "auto",
        fontFamily: '"Fira Code", monospace',
        fontSize: "14px"
      },
      ".cm-content": {
        height: "400px",
        minHeight: "400px",
        fontFamily: '"Fira Code", monospace',
        fontSize: "14px"
      },
      ".cm-line": {
        minHeight: "20px"
      }
    });
    const oneDarkProFlatTheme = EditorView.baseTheme({
      "&": {
        backgroundColor: "#1e2127",
        color: "#abb2bf"
      },
      ".cm-content": {
        caretColor: "#abb2bf"
      },
      ".cm-line": {
        color: "#abb2bf"
      },
      ".cm-gutters": {
        backgroundColor: "#1e2127",
        color: "#5c6370",
        borderRight: "1px solid #2c313a",
        fontFamily: '"Fira Code", monospace',
        fontSize: "14px"
      },
      ".cm-activeLine": {
        backgroundColor: "#2c313a"
      },
      ".cm-activeLineGutter": {
        backgroundColor: "#2c313a",
        color: "#98c379"
      },
      ".cm-selectionLayer": {
        zIndex: "10"
      },
      ".cm-selectionBackground": {
        backgroundColor: "#5c6370 !important",
        zIndex: "10"
      },
      "&.cm-focused .cm-selectionBackground": {
        backgroundColor: "#5c6370 !important"
      },
      ".cm-activeLine .cm-selectionBackground": {
        backgroundColor: "#5c6370 !important",
        zIndex: "10"
      },
      ".cm-cursor": {
        borderLeftColor: "#abb2bf"
      },
      ".cm-scroller": {
        scrollbarWidth: "thin",
        scrollbarColor: "#5c6370 #2c313a"
      }
    });
    const oneDarkProFlatHighlightStyle = syntaxHighlighting(
      HighlightStyle.define([
        { tag: tags.keyword, color: "#c678dd" },
        { tag: tags.string, color: "#98c379" },
        { tag: tags.number, color: "#d19a66" },
        { tag: tags.function(tags.variableName), color: "#61afef" },
        { tag: tags.comment, color: "#5c6370", fontStyle: "italic" },
        { tag: tags.variableName, color: "#abb2bf" },
        { tag: tags.operator, color: "#56b6c2" },
        { tag: tags.propertyName, color: "#e06c75" }
      ])
    );
    const editableExtension = EditorView.editable.of(true);
    const createEditorState = (doc, language) => {
      const extensions = [
        basicSetup,
        lineNumbers(),
        keymap.of(defaultKeymap),
        language === "javascript" ? javascript() : css(),
        fullHeightExtension,
        editableExtension,
        oneDarkProFlatTheme,
        oneDarkProFlatHighlightStyle,
        EditorView.updateListener.of((update) => {
          if (update.docChanged) {
            const newValue = update.state.doc.toString();
            emit("update:modelValue", newValue);
          }
        })
      ];
      return EditorState.create({
        doc,
        extensions
      });
    };
    const initializeEditor = () => {
      if (!editorRef.value) return;
      editorView = new EditorView({
        state: createEditorState(props.modelValue != null ? props.modelValue : "", props.language),
        parent: editorRef.value
      });
    };
    watch(
      () => props.language,
      (newLanguage) => {
        if (editorView) {
          const currentValue = editorView.state.doc.toString();
          editorView.destroy();
          editorView = new EditorView({
            state: createEditorState(currentValue, newLanguage),
            parent: editorRef.value
          });
        }
      }
    );
    watch(
      () => props.modelValue,
      (newValue) => {
        if (editorView && newValue !== editorView.state.doc.toString()) {
          const state = createEditorState(newValue != null ? newValue : "", props.language);
          editorView.setState(state);
        }
      }
    );
    onMounted(() => {
      initializeEditor();
    });
    onBeforeUnmount(() => {
      editorView == null ? void 0 : editorView.destroy();
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "codemirror-editor-container" }, _attrs))} data-v-6a520870><div class="codemirror-editor" data-v-6a520870></div></div>`);
    };
  }
});
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Common/CodeMirror.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const CodeMirror = /* @__PURE__ */ _export_sfc(_sfc_main$1, [["__scopeId", "data-v-6a520870"]]);
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$2
  },
  __name: "Edit",
  __ssrInlineRender: true,
  props: {
    template: {},
    stories: {},
    main_category_list: {},
    category_list: {},
    product_list: {},
    raw_product_list: {},
    article_list: {}
  },
  setup(__props) {
    var _a, _b;
    const props = __props;
    const mainCategoryList = ref(props.main_category_list);
    const categoryList = ref(props.category_list);
    const productList = ref(props.product_list);
    const rawProductList = ref(props.raw_product_list);
    const articleList = ref(props.article_list);
    onMounted(() => {
      if ($("#MainPageSort").length) {
        Sortable.create(document.getElementById("MainPageSort"), {
          handle: ".main-sort-handle",
          animation: 150,
          scroll: true
        });
      }
      if ($("#BlogPageSort").length) {
        Sortable.create(document.getElementById("BlogPageSort"), {
          handle: ".blog-sort-handle",
          animation: 150,
          scroll: true
        });
      }
      document.documentElement.style.setProperty("--primary", props.template.get_options.style.site_main_color);
      document.documentElement.style.setProperty("--secondary", props.template.get_options.style.site_secondary_color);
    });
    const componentColoris = () => {
      Coloris.init();
      Coloris.coloris({
        el: "#componentColorPicker",
        alpha: false,
        selectInput: false,
        defaultColor: "#0060ff",
        swatches: ["#ffffff", "#f7f8fa", "#f8a203", "#e76f51", "#fc5b61", "#dc3545", "#264653", "#2a9d8f", "#21d9c0", "#0097e6", "#07b", "#0060ff"]
      });
    };
    const activeTab = ref("main");
    const components = reactive(
      props.template.get_data.index.map((comp) => {
        if (comp.type.includes("selectable_category_list") && comp.data.style && comp.data.style.with_image === void 0) {
          comp.data.style.with_image = false;
        }
        return comp;
      })
    );
    const addComponent = (compnent) => {
      compnent.id = Math.floor(Math.random() * (999999 - 1e5) + 1e5) + "";
      components.push(compnent);
      $(() => {
        componentColoris();
      });
    };
    const blogComponents = reactive(props.template.get_blog_data.index);
    const addBlogComponent = (compnent) => {
      compnent.id = Math.floor(Math.random() * (999999 - 1e5) + 1e5) + "";
      blogComponents.push(compnent);
      $(() => {
        $(() => {
          componentColoris();
        });
      });
    };
    const blogSidebarBanners = reactive(props.template.get_blog_data.article.banners);
    const mediaReactive = inject("mediaData");
    watch(mediaReactive, (media) => {
      if (media.file != null) {
        if (media.type == "top-banner-desktop") {
          templateForm.top_banner.desktop.file_id = media.file.id;
          templateForm.top_banner.desktop.image = media.file.url;
          setTimeout(() => {
            new Bootstrap.Modal(document.getElementById("topBannerModal"), {}).show();
          }, 20);
        }
        if (media.type == "top-banner-mobile") {
          templateForm.top_banner.mobile.file_id = media.file.id;
          templateForm.top_banner.mobile.image = media.file.url;
          setTimeout(() => {
            new Bootstrap.Modal(document.getElementById("topBannerModal"), {}).show();
          }, 20);
        }
      }
      for (let component in components) {
        if (components[component].type.indexOf("slider") >= 0) {
          if (media.type == components[component].id + "slider" && media.file != null) {
            components[component].data["slider"].push({
              src: media.file.url,
              alt: media.file.description,
              link: null
            });
            setTimeout(() => {
              let modal = new Bootstrap.Modal(document.getElementById("component-settings-" + components[component].id), {});
              modal.show();
            }, 20);
          }
        }
        if (components[component].type.indexOf("banner") >= 0) {
          if (media.type == components[component].id + "banner" && media.file != null) {
            if (components[component].data["banner"].length < components[component].data["count"]) {
              components[component].data["banner"].push({
                src: media.file.url,
                alt: media.file.description,
                link: null
              });
            }
            setTimeout(() => {
              let modal = new Bootstrap.Modal(document.getElementById("component-settings-" + components[component].id), {});
              modal.show();
            }, 20);
          }
          if (media.type == components[component].id + "banner-single" && media.file != null) {
            if (components[component].data["banner"].length < components[component].data["count"]) {
              components[component].data["banner"].push({
                src: media.file.url,
                alt: media.file.description,
                link: null,
                mobile: {
                  src: null,
                  alt: null
                }
              });
            }
            setTimeout(() => {
              let modal = new Bootstrap.Modal(document.getElementById("component-settings-" + components[component].id), {});
              modal.show();
            }, 20);
          }
          if (media.type == components[component].id + "banner-single-mobile" && media.file != null) {
            components[component].data["banner"][0]["mobile"]["src"] = media.file.url;
            components[component].data["banner"][0]["mobile"]["alt"] = media.file.description;
            setTimeout(() => {
              let modal = new Bootstrap.Modal(document.getElementById("component-settings-" + components[component].id), {});
              modal.show();
            }, 20);
          }
        }
        if (components[component].type.indexOf("product_box_list") >= 0) {
          if (media.type == components[component].id + "image" && media.file != null) {
            components[component].data["product_box_list"]["image"]["src"] = media.file.url;
            components[component].data["product_box_list"]["image"]["alt"] = media.file.description;
            setTimeout(() => {
              let modal = new Bootstrap.Modal(document.getElementById("component-settings-" + components[component].id), {});
              modal.show();
            }, 20);
          }
        }
        if (components[component].type.indexOf("raw_list") >= 0) {
          if (media.type == components[component].id + "raw-image" && media.file != null) {
            components[component].data["raw_list"].push({
              src: media.file.url,
              alt: media.file.description,
              title: null,
              link: null,
              link_type: false
            });
            setTimeout(() => {
              let modal = new Bootstrap.Modal(document.getElementById("component-settings-" + components[component].id), {});
              modal.show();
            }, 20);
          }
        }
        if (components[component].type.indexOf("full_header_search_image") >= 0) {
          if (media.type == components[component].id + "image" && media.file != null) {
            components[component].data["content"]["image"]["src"] = media.file.url;
            components[component].data["content"]["image"]["alt"] = media.file.description;
            setTimeout(() => {
              let modal = new Bootstrap.Modal(document.getElementById("component-settings-" + components[component].id), {});
              modal.show();
            }, 20);
          }
        }
      }
      for (let component in blogComponents) {
        if (blogComponents[component].type.indexOf("slider") >= 0) {
          if (media.type == blogComponents[component].id + "slider" && media.file != null) {
            blogComponents[component].data["slider"].push({
              src: media.file.url,
              alt: media.file.description,
              link: null
            });
            setTimeout(() => {
              let modal = new Bootstrap.Modal(document.getElementById("component-settings-" + blogComponents[component].id), {});
              modal.show();
            }, 20);
          }
        }
        if (blogComponents[component].type.indexOf("banner") >= 0) {
          if (media.type == blogComponents[component].id + "banner" && media.file != null) {
            if (blogComponents[component].data["banner"].length < blogComponents[component].data["count"]) {
              blogComponents[component].data["banner"].push({
                src: media.file.url,
                alt: media.file.description,
                link: null
              });
            }
            setTimeout(() => {
              let modal = new Bootstrap.Modal(document.getElementById("component-settings-" + blogComponents[component].id), {});
              modal.show();
            }, 20);
          }
          if (media.type == blogComponents[component].id + "banner-single" && media.file != null) {
            if (blogComponents[component].data["banner"].length < blogComponents[component].data["count"]) {
              blogComponents[component].data["banner"].push({
                src: media.file.url,
                alt: media.file.description,
                link: null,
                mobile: {
                  src: null,
                  alt: null
                }
              });
            }
            setTimeout(() => {
              let modal = new Bootstrap.Modal(document.getElementById("component-settings-" + blogComponents[component].id), {});
              modal.show();
            }, 20);
          }
          if (media.type == blogComponents[component].id + "banner-single-mobile" && media.file != null) {
            blogComponents[component].data["banner"][0]["mobile"]["src"] = media.file.url;
            blogComponents[component].data["banner"][0]["mobile"]["alt"] = media.file.description;
            setTimeout(() => {
              let modal = new Bootstrap.Modal(document.getElementById("component-settings-" + blogComponents[component].id), {});
              modal.show();
            }, 20);
          }
        }
      }
      if (media.type == "blog-banners" && media.file != null) {
        blogSidebarBanners.push({
          url: media.file.url,
          alt: media.file.description,
          link: ""
        });
      }
    });
    $(() => {
      componentColoris();
    });
    const customCss = ref(props.template.get_options.style.custom_css);
    const customJs = ref(props.template.get_options.style.custom_js);
    const templateForm = useForm({
      top_banner: props.template.get_top_banner,
      header: props.template.header,
      footer: props.template.footer,
      options: {
        style: {
          site_main_color: props.template.get_options.style.site_main_color,
          site_secondary_color: props.template.get_options.style.site_secondary_color,
          site_background_color: props.template.get_options.style.site_background_color,
          site_main_shadow: props.template.get_options.style.site_main_shadow,
          header_categories_style: props.template.get_options.style.header_categories_style ?? "dropdown",
          custom_css: customCss.value,
          custom_js: customJs.value
        }
      },
      main_data: {
        index: components,
        product: {
          settings: {
            tabs_status: ((_b = (_a = props.template.get_data.product) == null ? void 0 : _a.settings) == null ? void 0 : _b.tabs_status) ?? true
          }
        }
      },
      blog_data: {
        index: blogComponents,
        article: {
          banners: blogSidebarBanners
        }
      }
    });
    const chooseHeader = (id) => {
      templateForm.header = id;
    };
    const chooseFooter = (id) => {
      templateForm.footer = id;
    };
    const siteMainColor = ref(props.template.get_options.style.site_main_color);
    const siteSecondaryColor = ref(props.template.get_options.style.site_secondary_color);
    const siteBackgroundColor = ref(props.template.get_options.style.site_background_color);
    $(() => {
      Coloris.init();
      Coloris.coloris({
        el: "#siteMainColor",
        alpha: false,
        selectInput: false,
        defaultColor: "#0060ff",
        swatches: ["#ffffff", "#f7f8fa", "#f8a203", "#e76f51", "#fc5b61", "#dc3545", "#264653", "#2a9d8f", "#21d9c0", "#0097e6", "#07b", "#0060ff"]
      });
      Coloris.close();
      Coloris.init();
      Coloris.coloris({
        el: "#siteSecondaryColor",
        alpha: false,
        selectInput: false,
        defaultColor: "#f8a203",
        swatches: ["#ffffff", "#f7f8fa", "#f8a203", "#e76f51", "#fc5b61", "#dc3545", "#264653", "#2a9d8f", "#21d9c0", "#0097e6", "#07b", "#0060ff"]
      });
      Coloris.close();
      Coloris.init();
      Coloris.coloris({
        el: "#siteBackgroundColor",
        alpha: false,
        selectInput: false,
        defaultColor: "#f7f8fa",
        swatches: ["#ffffff", "#f7f8fa", "#f8a203", "#e76f51", "#fc5b61", "#dc3545", "#264653", "#2a9d8f", "#21d9c0", "#0097e6", "#07b", "#0060ff"]
      });
      Coloris.close();
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _directive_tooltip = resolveDirective("tooltip");
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.edit_template")
      }, null, _parent));
      if (activeTab.value == "main") {
        _push(`<div${ssrRenderAttrs(mergeProps({
          class: "show-elements btn btn-xl btn-square btn-white shadow-2",
          "data-bs-toggle": "modal",
          "data-bs-target": "#mainUiElements"
        }, ssrGetDirectiveProps(_ctx, _directive_tooltip, _ctx.$t("messages.sentence.add_element"), void 0, { top: true })))}><i class="ri-instance-line"></i></div>`);
      } else {
        _push(`<!---->`);
      }
      if (activeTab.value == "blog") {
        _push(`<div${ssrRenderAttrs(mergeProps({
          class: "show-elements btn btn-xl btn-square btn-white shadow-2",
          "data-bs-toggle": "modal",
          "data-bs-target": "#blogUiElements"
        }, ssrGetDirectiveProps(_ctx, _directive_tooltip, _ctx.$t("messages.sentence.add_element"), void 0, { top: true })))}><i class="ri-instance-line"></i></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "save-changes btn btn-xl btn-square btn-primary shadow-2" }, ssrGetDirectiveProps(_ctx, _directive_tooltip, _ctx.$t("messages.sentence.save_template"), void 0, { top: true })))}>`);
      if (!unref(templateForm).processing) {
        _push(`<i class="ri-save-line"></i>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(templateForm).processing) {
        _push(`<i class="ri-refresh-line i-spin"></i>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
      _push(ssrRenderComponent(_sfc_main$5, {
        onAddComponent: (data) => addComponent(data)
      }, null, _parent));
      _push(ssrRenderComponent(_sfc_main$6, {
        onAddBlogComponent: (data) => addBlogComponent(data)
      }, null, _parent));
      _push(`<div class="page-content full"><div class="container">`);
      _push(ssrRenderComponent(_sfc_main$7, {
        title: _ctx.$t("messages.sentence.edit_template")
      }, null, _parent));
      _push(`<div class="alert alert-warning d-inline-block lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_911254"))}</div>`);
      _push(ssrRenderComponent(_sfc_main$8, {
        modelValue: unref(templateForm).top_banner,
        "onUpdate:modelValue": ($event) => unref(templateForm).top_banner = $event
      }, null, _parent));
      _push(ssrRenderComponent(ChooseHeader, {
        onChooseHeader: (data) => chooseHeader(data)
      }, null, _parent));
      _push(ssrRenderComponent(ChooseFooter, {
        onChooseFooter: (data) => chooseFooter(data)
      }, null, _parent));
      _push(`<div class="page-builder mb-4"><div class="simplebar-container"><ul style="${ssrRenderStyle({ "min-width": "700px" })}" class="nav nav-tabs nav-pager" id="pageBuilderTab" role="tablist"><li class="nav-item" role="presentation"><button class="nav-link active" id="main-tab" data-bs-toggle="tab" data-bs-target="#main-tab-pane" type="button" role="tab" aria-controls="main-tab-pane" aria-selected="false">${ssrInterpolate(_ctx.$t("messages.sentence.shop_index_page"))}</button></li><li class="nav-item" role="presentation"><button class="nav-link" id="product-tab" data-bs-toggle="tab" data-bs-target="#product-tab-pane" type="button" role="tab" aria-controls="product-tab-pane" aria-selected="false">${ssrInterpolate(_ctx.$t("messages.sentence.product_page"))}</button></li><li class="nav-item" role="presentation"><button class="nav-link" id="blog-tab" data-bs-toggle="tab" data-bs-target="#blog-tab-pane" type="button" role="tab" aria-controls="blog-tab-pane" aria-selected="false">${ssrInterpolate(_ctx.$t("messages.sentence.blog_index_page"))}</button></li><li class="nav-item" role="presentation"><button class="nav-link" id="article-tab" data-bs-toggle="tab" data-bs-target="#article-tab-pane" type="button" role="tab" aria-controls="article-tab-pane" aria-selected="false">${ssrInterpolate(_ctx.$t("messages.sentence.article_page"))}</button></li><li class="nav-item" role="presentation"><button class="nav-link" id="style-tab" data-bs-toggle="tab" data-bs-target="#style-tab-pane" type="button" role="tab" aria-controls="style-tab-pane" aria-selected="false">${ssrInterpolate(_ctx.$t("messages.word.styling"))}</button></li></ul></div><div class="tab-content card mb-5" id="pageBuilderTabContent"><div class="tab-pane fade show active" id="main-tab-pane" role="tabpanel" aria-labelledby="main-tab" tabindex="0"><div class="card-body p-2"><div class="row"><div class="col-12"><div class="ui-box-container"><div class="ui-box" style="${ssrRenderStyle({ "min-height": "60px" })}"><ul class="ui-box-action"><li${ssrRenderAttrs(mergeProps({
        "data-bs-toggle": "modal",
        "data-bs-target": "#topBannerModal"
      }, ssrGetDirectiveProps(_ctx, _directive_tooltip, _ctx.$t("messages.sentence.element_settings"), void 0, { left: true })))}><i class="ri-settings-3-line"></i></li></ul>`);
      if (unref(templateForm).top_banner.desktop.file_id == null) {
        _push(`<div class="d-flex align-items-center justify-content-center p-2"><span class="text-light-gray lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.top_banner_section"))}</span></div>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(templateForm).top_banner.desktop.image != null) {
        _push(`<div class="top-banner-container d-md-block d-none"><img class="w-100"${ssrRenderAttr("src", unref(templateForm).top_banner.desktop.image)} alt="banner"></div>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(templateForm).top_banner.mobile.image != null) {
        _push(`<div class="top-banner-container d-md-none"><img class="w-100"${ssrRenderAttr("src", unref(templateForm).top_banner.mobile.image)} alt="banner"></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div></div></div><div class="row"><div class="col-12"><div class="ui-box-container"><div class="ui-box"><ul class="ui-box-action">`);
      if (unref(templateForm).header == "") {
        _push(`<li data-bs-toggle="modal" data-bs-target="#headerElements"><i class="ri-add-line"></i></li>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(templateForm).header != "") {
        _push(`<li class="trash"><i class="ri-delete-bin-5-line"></i></li>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</ul>`);
      if (unref(templateForm).header == "") {
        _push(`<div class="ui-box-temp-message"><span>${ssrInterpolate(_ctx.$t("messages.sentence.select_header"))}</span></div>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(templateForm).header != "") {
        ssrRenderVNode(_push, createVNode(resolveDynamicComponent(unref(templateForm).header), { status: "dev" }, null), _parent);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div></div></div>`);
      if (_ctx.stories.status) {
        _push(`<div class="row"><div class="col-12"><div class="ui-box-container"><div class="ui-box"><ul class="ui-box-action"><li${ssrRenderAttrs(mergeProps({
          "data-bs-toggle": "modal",
          "data-bs-target": "#storiesElements"
        }, ssrGetDirectiveProps(_ctx, _directive_tooltip, _ctx.$t("messages.sentence.element_settings"), void 0, { left: true })))}><i class="ri-settings-3-line"></i></li></ul>`);
        _push(ssrRenderComponent(_sfc_main$9, {
          stories: _ctx.stories.data,
          component_id: unref(useRandomStr)(10),
          status: "dev"
        }, null, _parent));
        _push(`</div></div><div class="modal fade ui-elements-modal" id="storiesElements" tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-lg modal-dialog-centered"><div class="modal-content"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.word.attention"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12 mb-3"><span class="w-100 d-flex align-items-center justify-content-center text-center lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_542252"))}</span></div></div></div></div></div></div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div id="MainPageSort" class="row"><!--[-->`);
      ssrRenderList(components, (component, index) => {
        _push(`<div${ssrRenderAttr("index", index)} class="col-12 component"><div class="ui-box-container"><div class="ui-box"><ul class="ui-box-action">`);
        if (component.settings) {
          _push(`<li${ssrRenderAttrs(mergeProps({
            "data-bs-toggle": "modal",
            "data-bs-target": "#component-settings-" + component.id
          }, ssrGetDirectiveProps(_ctx, _directive_tooltip, _ctx.$t("messages.sentence.element_settings"), void 0, { left: true })))}><i class="ri-settings-3-line"></i></li>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<li${ssrRenderAttrs(mergeProps({ class: "trash" }, ssrGetDirectiveProps(_ctx, _directive_tooltip, _ctx.$t("messages.word.delete"), void 0, { left: true })))}><i class="ri-delete-bin-5-line"></i></li><li${ssrRenderAttrs(mergeProps({ class: "main-sort-handle" }, ssrGetDirectiveProps(_ctx, _directive_tooltip, _ctx.$t("messages.word.displacement"), void 0, { left: true })))}><i class="ri-draggable"></i></li><div class="modal fade ui-elements-modal"${ssrRenderAttr("id", "component-settings-" + component.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-xl modal-dialog-centered"><div class="modal-content p-4"><div class="modal-header"><div class="modal-title lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.element_settings"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body">`);
        if (component.type.indexOf("slider") >= 0) {
          _push(`<div class="mb-4"><div class="row"><div class="col-12 mb-2 fw-bold text-dark">${ssrInterpolate(_ctx.$t("messages.sentence.component_styles"))}:</div><div class="col-12 mb-4"><div class="w-100 bg-light p-3 br-15 pb-0"><div class="row"><div class="col-lg-3 col-12"><div class="mb-4"><label for="trjerhoiiwjevg" class="form-label fs-9">${ssrInterpolate(_ctx.$t("messages.sentence.component_margin_top"))}</label><input id="trjerhoiiwjevg" type="text"${ssrRenderAttr("value", component.data["style"]["margin"]["top"])} class="form-control"></div></div><div class="col-lg-3 col-12"><div class="mb-4"><label for="jtnwjvnasdgsg" class="form-label fs-9">${ssrInterpolate(_ctx.$t("messages.sentence.component_margin_bottom"))}</label><input id="jtnwjvnasdgsg" type="text"${ssrRenderAttr("value", component.data["style"]["margin"]["bottom"])} class="form-control"></div></div></div></div></div><div class="col-12 title fs-8 mb-2">${ssrInterpolate(_ctx.$t("messages.sentence.slider_item_setting"))}</div><div class="col-12 mb-3"><ul class="add-slider-items row"><!--[-->`);
          ssrRenderList(component.data["slider"], (slider, i) => {
            _push(`<li class="col-12"><div class="inner"><button${ssrRenderAttrs(mergeProps({
              class: "remove-icon btn btn-xs btn-square btn-danger",
              type: "button"
            }, ssrGetDirectiveProps(_ctx, _directive_tooltip, _ctx.$t("messages.word.delete"), void 0, { top: true })))}><i class="ri-delete-bin-6-line"></i></button><img${ssrRenderAttr("src", slider["src"])}${ssrRenderAttr("alt", slider["alt"])}><input${ssrRenderAttr("value", slider["link"])} type="text" class="form-control" placeholder="banner link ..."></div></li>`);
          });
          _push(`<!--]--></ul><button${ssrRenderAttrs(mergeProps({
            "data-bs-toggle": "modal",
            "data-bs-target": "#mediaLibrary",
            "data-bs-input": component.id + "slider",
            class: "btn btn-sm btn-square btn-primary mt-2"
          }, ssrGetDirectiveProps(_ctx, _directive_tooltip, _ctx.$t("messages.word.add"), void 0, { top: true })))}><i class="ri-add-line"></i></button></div></div></div>`);
        } else {
          _push(`<!---->`);
        }
        if (component.type.indexOf("banner") >= 0) {
          _push(`<div class="mb-4"><div class="row"><div class="col-12 mb-2 fw-bold text-dark">${ssrInterpolate(_ctx.$t("messages.sentence.component_styles"))}:</div><div class="col-12 mb-4"><div class="w-100 bg-light p-3 br-15 pb-0"><div class="row"><div class="col-lg-3 col-12"><div class="mb-4"><label for="hgfegspkdjmbsd" class="form-label fs-9">${ssrInterpolate(_ctx.$t("messages.sentence.component_margin_top"))}</label><input id="hgfegspkdjmbsd" type="text"${ssrRenderAttr("value", component.data["style"]["margin"]["top"])} class="form-control"></div></div><div class="col-lg-3 col-12"><div class="mb-4"><label for="epombsktyasvbdn" class="form-label fs-9">${ssrInterpolate(_ctx.$t("messages.sentence.component_margin_bottom"))}</label><input id="epombsktyasvbdn" type="text"${ssrRenderAttr("value", component.data["style"]["margin"]["bottom"])} class="form-control"></div></div></div></div></div><div class="col-12 title fs-8 mb-2">${ssrInterpolate(_ctx.$t("messages.sentence.banner_item_setting"))}</div><div class="col-12 mb-3"><ul class="add-slider-items row"><!--[-->`);
          ssrRenderList(component.data["banner"], (banner, i) => {
            _push(`<li class="${ssrRenderClass({
              "col-lg-3 col-md-6 col-12 mb-3": component.data["count"] == 4,
              "col-lg-6 mb-4": component.data["count"] == 2,
              "col-12 mb-4": component.data["count"] == 1
            })}"><div class="inner mb-3">`);
            if (banner.mobile !== void 0) {
              _push(`<span class="lts-05 mb-3 text-dark">${ssrInterpolate(_ctx.$t("messages.word.desktop"))}</span>`);
            } else {
              _push(`<!---->`);
            }
            _push(`<button${ssrRenderAttrs(mergeProps({
              class: "remove-icon btn btn-xs btn-square btn-danger",
              type: "button"
            }, ssrGetDirectiveProps(_ctx, _directive_tooltip, _ctx.$t("messages.word.delete"), void 0, { top: true })))}><i class="ri-delete-bin-6-line"></i></button><img${ssrRenderAttr("src", banner["src"])}${ssrRenderAttr("alt", banner["alt"])} style="${ssrRenderStyle({ "height": "auto" })}"><input${ssrRenderAttr("value", banner["link"])} type="text" class="form-control" placeholder="banner link ..."></div>`);
            if (banner.mobile !== void 0 && banner["mobile"]["src"] != null) {
              _push(`<div class="inner"><span class="lts-05 mb-3 text-dark">${ssrInterpolate(_ctx.$t("messages.word.mobile"))}</span><button${ssrRenderAttrs(mergeProps({
                class: "remove-icon btn btn-xs btn-square btn-danger",
                type: "button"
              }, ssrGetDirectiveProps(_ctx, _directive_tooltip, _ctx.$t("messages.word.delete"), void 0, { top: true })))}><i class="ri-delete-bin-6-line"></i></button><img${ssrRenderAttr("src", banner["mobile"]["src"])}${ssrRenderAttr("alt", banner["mobile"]["alt"])} style="${ssrRenderStyle({ "height": "auto" })}"></div>`);
            } else {
              _push(`<!---->`);
            }
            if (banner.mobile !== void 0 && banner.mobile.src == null) {
              _push(`<button${ssrRenderAttrs(mergeProps({
                "data-bs-toggle": "modal",
                "data-bs-target": "#mediaLibrary",
                "data-bs-input": component.id + "banner-single-mobile",
                class: "btn btn-primary fs-9 mt-1"
              }, ssrGetDirectiveProps(_ctx, _directive_tooltip, _ctx.$t("messages.word.add"), void 0, { top: true })))}>${ssrInterpolate(_ctx.$t("messages.sentence.add_mobile_banner"))}</button>`);
            } else {
              _push(`<!---->`);
            }
            _push(`</li>`);
          });
          _push(`<!--]--></ul>`);
          if (component.data["banner"].length < component.data["count"]) {
            _push(`<button${ssrRenderAttrs(mergeProps({
              "data-bs-toggle": "modal",
              "data-bs-target": "#mediaLibrary",
              "data-bs-input": component.type.indexOf("banner-single") >= 0 ? component.id + "banner-single" : component.id + "banner",
              class: "btn btn-sm btn-square btn-primary mt-2"
            }, ssrGetDirectiveProps(_ctx, _directive_tooltip, _ctx.$t("messages.word.add"), void 0, { top: true })))}><i class="ri-add-line"></i></button>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</div></div></div>`);
        } else {
          _push(`<!---->`);
        }
        if (component.type.indexOf("category_products") >= 0) {
          _push(`<div class="mb-4"><div class="row"><div class="col-12 mb-2 fw-bold text-dark">${ssrInterpolate(_ctx.$t("messages.sentence.component_styles"))}:</div><div class="col-12 mb-4"><div class="w-100 bg-light p-3 br-15 pb-0"><div class="row"><div class="col-lg-3 col-12"><div class="mb-4"><label for="lpmebnwoienbsdb" class="form-label fs-9">${ssrInterpolate(_ctx.$t("messages.sentence.component_margin_top"))}</label><input id="lpmebnwoienbsdb" type="text"${ssrRenderAttr("value", component.data["style"]["margin"]["top"])} class="form-control"></div></div><div class="col-lg-3 col-12"><div class="mb-4"><label for="wgodjmfinsdv" class="form-label fs-9">${ssrInterpolate(_ctx.$t("messages.sentence.component_margin_bottom"))}</label><input id="wgodjmfinsdv" type="text"${ssrRenderAttr("value", component.data["style"]["margin"]["bottom"])} class="form-control"></div></div></div></div></div><div class="col-lg-6 col-12 mb-3"><label class="form-label title fs-8 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.select_category"))}</label>`);
          _push(ssrRenderComponent(unref(Dropdown), {
            class: "pvc-multiselect pvc-multiselect-filter flex-grow-1",
            modelValue: component.data["category_products"]["category"],
            "onUpdate:modelValue": ($event) => component.data["category_products"]["category"] = $event,
            options: categoryList.value,
            filter: "",
            emptyFilterMessage: _ctx.$t("messages.sentence.no_items_found"),
            display: "chip",
            optionLabel: "title",
            placeholder: _ctx.$t("messages.sentence.select_category")
          }, {
            option: withCtx((slotProps, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<div class="category-template flex align-items-center"${_scopeId}><div class="${ssrRenderClass({
                  "category-level-one": slotProps.option.level == "one",
                  "category-level-two": slotProps.option.level == "two",
                  "category-level-three": slotProps.option.level == "three"
                })}"${_scopeId}>`);
                if (slotProps.option.level == "three") {
                  _push2(`<span${_scopeId}><i class="ri-arrow-drop-left-line"${_scopeId}></i></span>`);
                } else if (slotProps.option.level == "two") {
                  _push2(`<span${_scopeId}><i class="circle-icon ri-circle-fill"${_scopeId}></i></span>`);
                } else {
                  _push2(`<!---->`);
                }
                _push2(` ${ssrInterpolate(slotProps.option.title)}</div></div>`);
              } else {
                return [
                  createVNode("div", { class: "category-template flex align-items-center" }, [
                    createVNode("div", {
                      class: {
                        "category-level-one": slotProps.option.level == "one",
                        "category-level-two": slotProps.option.level == "two",
                        "category-level-three": slotProps.option.level == "three"
                      }
                    }, [
                      slotProps.option.level == "three" ? (openBlock(), createBlock("span", { key: 0 }, [
                        createVNode("i", { class: "ri-arrow-drop-left-line" })
                      ])) : slotProps.option.level == "two" ? (openBlock(), createBlock("span", { key: 1 }, [
                        createVNode("i", { class: "circle-icon ri-circle-fill" })
                      ])) : createCommentVNode("", true),
                      createTextVNode(" " + toDisplayString(slotProps.option.title), 1)
                    ], 2)
                  ])
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(`</div>`);
          if (component.type.indexOf("category_box_products") >= 0) {
            _push(`<div class="col-lg-6 color-picker col-12 mb-3"><label class="form-label title fs-8 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.product_box_color"))}</label><input id="componentColorPicker"${ssrRenderAttr("value", component.data["category_box_products"]["color"])}></div>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</div></div>`);
        } else {
          _push(`<!---->`);
        }
        if (component.type.indexOf("selectable_category_list") >= 0) {
          _push(`<div class="mb-4"><div class="row"><div class="col-12 mb-2 fw-bold text-dark">${ssrInterpolate(_ctx.$t("messages.sentence.component_styles"))}:</div><div class="col-12 mb-4"><div class="w-100 bg-light p-3 br-15 pb-0"><div class="row"><div class="col-lg-3 col-12"><div class="mb-4"><label for="gtplkkdvmbfnbf" class="form-label fs-9">${ssrInterpolate(_ctx.$t("messages.sentence.category_component_item_count"))}</label><input id="gtplkkdvmbfnbf" type="text"${ssrRenderAttr("value", component.data["style"]["item_count"])} class="form-control"></div></div><div class="col-12"></div><div class="col-lg-3 col-12"><div class="mb-4"><label for="lknsbiausbgfb" class="form-label fs-9">${ssrInterpolate(_ctx.$t("messages.sentence.component_margin_top"))}</label><input id="lknsbiausbgfb" type="text"${ssrRenderAttr("value", component.data["style"]["margin"]["top"])} class="form-control"></div></div><div class="col-lg-3 col-12"><div class="mb-4"><label for="oiehibsndbojksd" class="form-label fs-9">${ssrInterpolate(_ctx.$t("messages.sentence.component_margin_bottom"))}</label><input id="oiehibsndbojksd" type="text"${ssrRenderAttr("value", component.data["style"]["margin"]["bottom"])} class="form-control"></div></div></div><div class="row pb-2"><div class="col-auto"><label class="form-label d-flex fs-8 lts-05 clickable"><input name="sgflpwod" type="radio"${ssrIncludeBooleanAttr(ssrLooseEqual(component.data["style"]["main_background"], "empty")) ? " checked" : ""} value="empty" class="form-check clickable me-2"> ${ssrInterpolate(_ctx.$t("messages.sentence.with_no_background"))}</label></div><div class="col-auto"><label class="form-label d-flex fs-8 lts-05 clickable"><input name="sgflpwod" type="radio"${ssrIncludeBooleanAttr(ssrLooseEqual(component.data["style"]["main_background"], "gradient")) ? " checked" : ""} value="gradient" class="form-check clickable me-2"> ${ssrInterpolate(_ctx.$t("messages.sentence.with_gradient_background"))}</label></div><div class="col-auto"><label class="form-label d-flex fs-8 lts-05 clickable"><input name="sgflpwod" type="radio"${ssrIncludeBooleanAttr(ssrLooseEqual(component.data["style"]["main_background"], "solid")) ? " checked" : ""} value="solid" class="form-check clickable me-2"> ${ssrInterpolate(_ctx.$t("messages.sentence.with_solid_background"))}</label></div><div class="col-auto"><label class="form-label d-flex align-items-center fs-8 lts-05 clickable"><input type="checkbox"${ssrIncludeBooleanAttr(Array.isArray(component.data["style"]["items_background"]) ? ssrLooseContain(component.data["style"]["items_background"], null) : component.data["style"]["items_background"]) ? " checked" : ""} class="form-check clickable me-2"> ${ssrInterpolate(_ctx.$t("messages.sentence.with_items_background"))}</label></div><div class="col-12 mt-3"><label class="form-label d-flex align-items-center fw-bold fs-8 lts-05 clickable"><input type="checkbox"${ssrIncludeBooleanAttr(Array.isArray(component.data["style"]["with_image"]) ? ssrLooseContain(component.data["style"]["with_image"], null) : component.data["style"]["with_image"]) ? " checked" : ""} class="form-check clickable me-2"> ${ssrInterpolate(_ctx.$t("messages.sentence.category_only_with_image"))}</label></div></div></div></div><div class="col-lg-6 col-12 mb-3"><label class="form-label title fs-8 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.select_category_list"))}</label>`);
          _push(ssrRenderComponent(unref(Dropdown), {
            class: "pvc-dropdown flex-grow-1",
            modelValue: component.data["category_list"]["category"],
            "onUpdate:modelValue": ($event) => component.data["category_list"]["category"] = $event,
            options: mainCategoryList.value,
            display: "chip",
            optionLabel: "dropdown_title",
            placeholder: _ctx.$t("messages.sentence.select_category_list")
          }, null, _parent));
          _push(`</div></div></div>`);
        } else {
          _push(`<!---->`);
        }
        if (component.type.indexOf("category_list") >= 0 && component.type.indexOf("selectable_category_list") < 0) {
          _push(`<div class="mb-4"><div class="row"><div class="col-12 mb-2 fw-bold text-dark">${ssrInterpolate(_ctx.$t("messages.sentence.component_styles"))}:</div><div class="col-12 mb-4"><div class="w-100 bg-light p-3 br-15 pb-0"><div class="row"><div class="col-lg-3 col-12"><div class="mb-4"><label for="podsjboisdnmob" class="form-label fs-9">${ssrInterpolate(_ctx.$t("messages.sentence.component_margin_top"))}</label><input id="podsjboisdnmob" type="text"${ssrRenderAttr("value", component.data["style"]["margin"]["top"])} class="form-control"></div></div><div class="col-lg-3 col-12"><div class="mb-4"><label for="oeqawovbmabfdb" class="form-label fs-9">${ssrInterpolate(_ctx.$t("messages.sentence.component_margin_bottom"))}</label><input id="oeqawovbmabfdb" type="text"${ssrRenderAttr("value", component.data["style"]["margin"]["bottom"])} class="form-control"></div></div></div></div></div></div></div>`);
        } else {
          _push(`<!---->`);
        }
        if (component.type.indexOf("article_list") >= 0) {
          _push(`<div class="mb-4"><div class="row"><div class="col-12 mb-2 fw-bold text-dark">${ssrInterpolate(_ctx.$t("messages.sentence.component_styles"))}:</div><div class="col-12 mb-4"><div class="w-100 bg-light p-3 br-15 pb-0"><div class="row"><div class="col-lg-3 col-12"><div class="mb-4"><label for="defnsdiuabsbnv" class="form-label fs-9">${ssrInterpolate(_ctx.$t("messages.sentence.component_margin_top"))}</label><input id="defnsdiuabsbnv" type="text"${ssrRenderAttr("value", component.data["style"]["margin"]["top"])} class="form-control"></div></div><div class="col-lg-3 col-12"><div class="mb-4"><label for="posjebvaisjnb" class="form-label fs-9">${ssrInterpolate(_ctx.$t("messages.sentence.component_margin_bottom"))}</label><input id="posjebvaisjnb" type="text"${ssrRenderAttr("value", component.data["style"]["margin"]["bottom"])} class="form-control"></div></div></div></div></div></div></div>`);
        } else {
          _push(`<!---->`);
        }
        if (component.type.indexOf("brand_list") >= 0) {
          _push(`<div class="mb-4"><div class="row"><div class="col-12 mb-2 fw-bold text-dark">${ssrInterpolate(_ctx.$t("messages.sentence.component_styles"))}:</div><div class="col-12 mb-4"><div class="w-100 bg-light p-3 br-15 pb-0"><div class="row"><div class="col-lg-3 col-12"><div class="mb-4"><label for="pdsnbsiebasb" class="form-label fs-9">${ssrInterpolate(_ctx.$t("messages.sentence.component_margin_top"))}</label><input id="pdsnbsiebasb" type="text"${ssrRenderAttr("value", component.data["style"]["margin"]["top"])} class="form-control"></div></div><div class="col-lg-3 col-12"><div class="mb-4"><label for="yaspvamsobans" class="form-label fs-9">${ssrInterpolate(_ctx.$t("messages.sentence.component_margin_bottom"))}</label><input id="yaspvamsobans" type="text"${ssrRenderAttr("value", component.data["style"]["margin"]["bottom"])} class="form-control"></div></div></div></div></div></div></div>`);
        } else {
          _push(`<!---->`);
        }
        if (component.type.indexOf("raw_list") >= 0) {
          _push(`<div class="mb-4"><div class="row"><div class="col-12 mb-2 fw-bold text-dark">${ssrInterpolate(_ctx.$t("messages.word.desktop"))}:</div><div class="col-12 mb-4"><div class="w-100 bg-light p-3 br-15 pb-0"><div class="row"><div class="col-lg-3 col-12"><div class="mb-4"><label for="dprowmsj" class="form-label fs-9">${ssrInterpolate(_ctx.$t("messages.sentence.item_width"))}</label><input id="dprowmsj" type="text"${ssrRenderAttr("value", component.data["style"]["desktop"]["width"])} class="form-control"></div></div><div class="col-lg-3 col-12"><div class="mb-4"><label for="jtrnerasmdh" class="form-label fs-9">${ssrInterpolate(_ctx.$t("messages.sentence.item_between_margin"))}</label><input id="jtrnerasmdh" type="text"${ssrRenderAttr("value", component.data["style"]["desktop"]["margin"]["between"])} class="form-control"></div></div><div class="col-lg-3 col-12"><div class="mb-4"><label for="jtrnerasmdh" class="form-label fs-9">${ssrInterpolate(_ctx.$t("messages.sentence.component_margin_top"))}</label><input id="jtrnerasmdh" type="text"${ssrRenderAttr("value", component.data["style"]["desktop"]["margin"]["top"])} class="form-control"></div></div><div class="col-lg-3 col-12"><div class="mb-4"><label for="jtrnerasmdh" class="form-label fs-9">${ssrInterpolate(_ctx.$t("messages.sentence.component_margin_bottom"))}</label><input id="jtrnerasmdh" type="text"${ssrRenderAttr("value", component.data["style"]["desktop"]["margin"]["bottom"])} class="form-control"></div></div></div></div></div><div class="col-12 mb-2 fw-bold text-dark">${ssrInterpolate(_ctx.$t("messages.word.mobile"))}:</div><div class="col-12 mb-4"><div class="w-100 bg-light p-3 br-15 pb-0"><div class="row"><div class="col-lg-3 col-12"><div class="mb-4"><label for="dprowmsj" class="form-label fs-9">${ssrInterpolate(_ctx.$t("messages.sentence.item_width"))}</label><input id="dprowmsj" type="text"${ssrRenderAttr("value", component.data["style"]["mobile"]["width"])} class="form-control"></div></div><div class="col-lg-3 col-12"><div class="mb-4"><label for="jtrnerasmdh" class="form-label fs-9">${ssrInterpolate(_ctx.$t("messages.sentence.item_between_margin"))}</label><input id="jtrnerasmdh" type="text"${ssrRenderAttr("value", component.data["style"]["mobile"]["margin"]["between"])} class="form-control"></div></div><div class="col-lg-3 col-12"><div class="mb-4"><label for="jtrnerasmdh" class="form-label fs-9">${ssrInterpolate(_ctx.$t("messages.sentence.component_margin_top"))}</label><input id="jtrnerasmdh" type="text"${ssrRenderAttr("value", component.data["style"]["mobile"]["margin"]["top"])} class="form-control"></div></div><div class="col-lg-3 col-12"><div class="mb-4"><label for="jtrnerasmdh" class="form-label fs-9">${ssrInterpolate(_ctx.$t("messages.sentence.component_margin_bottom"))}</label><input id="jtrnerasmdh" type="text"${ssrRenderAttr("value", component.data["style"]["mobile"]["margin"]["bottom"])} class="form-control"></div></div></div></div></div><div class="col-12 mb-3"><ul class="add-slider-items row"><!--[-->`);
          ssrRenderList(component.data["raw_list"], (item, i) => {
            _push(`<li class="col-md-auto"><div class="inner"><img${ssrRenderAttr("src", item["src"])}${ssrRenderAttr("alt", item["alt"])} style="${ssrRenderStyle("height: auto; width: " + component.data["style"]["desktop"]["width"] + "px;")}" class="br-0"><input${ssrRenderAttr("value", item["title"])} type="text" class="form-control mb-1"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.title"))} style="${ssrRenderStyle({ "text-align": "center" })}"><input${ssrRenderAttr("value", item["link"])} type="text" class="form-control mb-2"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.link"))} style="${ssrRenderStyle({ "text-align": "center" })}"><div class="w-100 d-flex align-items-center justify-content-between px-1"><label class="clickable d-flex align-items-center justify-content-end white-space-nowrap lts-05 fs-9"><input${ssrIncludeBooleanAttr(Array.isArray(item["link_type"]) ? ssrLooseContain(item["link_type"], null) : item["link_type"]) ? " checked" : ""} type="checkbox" class="clickable form-check me-2"> ${ssrInterpolate(_ctx.$t("messages.sentence.internal_link"))}</label><button${ssrRenderAttrs(mergeProps({
              class: "btn btn-xs btn-square btn-danger",
              type: "button"
            }, ssrGetDirectiveProps(_ctx, _directive_tooltip, _ctx.$t("messages.word.delete"), void 0, { top: true })))}><i class="ri-delete-bin-6-line text-white" style="${ssrRenderStyle({ "opacity": "1" })}"></i></button></div></div></li>`);
          });
          _push(`<!--]--></ul><button${ssrRenderAttrs(mergeProps({
            "data-bs-toggle": "modal",
            "data-bs-target": "#mediaLibrary",
            "data-bs-input": component.id + "raw-image",
            class: "btn btn-sm btn-square btn-primary mt-2"
          }, ssrGetDirectiveProps(_ctx, _directive_tooltip, _ctx.$t("messages.word.add"), void 0, { top: true })))}><i class="ri-add-line"></i></button></div></div></div>`);
        } else {
          _push(`<!---->`);
        }
        if (component.type.indexOf("full_header_search_product") >= 0) {
          _push(`<div class="mb-4"><div class="row"><div class="col-12 mb-2 fw-bold text-dark">${ssrInterpolate(_ctx.$t("messages.sentence.component_styles"))}:</div><div class="col-12 mb-4"><div class="w-100 bg-light p-3 br-15 pb-0"><div class="row"><div class="col-lg-3 col-12"><div class="mb-4"><label for="podfnbijsnvac" class="form-label fs-9">${ssrInterpolate(_ctx.$t("messages.sentence.component_margin_top"))}</label><input id="podfnbijsnvac" type="text"${ssrRenderAttr("value", component.data["style"]["margin"]["top"])} class="form-control"></div></div><div class="col-lg-3 col-12"><div class="mb-4"><label for="pusvnvhsavjdbdd" class="form-label fs-9">${ssrInterpolate(_ctx.$t("messages.sentence.component_margin_bottom"))}</label><input id="pusvnvhsavjdbdd" type="text"${ssrRenderAttr("value", component.data["style"]["margin"]["bottom"])} class="form-control"></div></div></div></div></div><div class="col-12 mb-3"><div class="border"></div></div><div class="col-12 mb-3 fw-bold text-dark">${ssrInterpolate(_ctx.$t("messages.sentence.widgets_contents"))}:</div><div class="col-12 mb-3"><div class="row"><div class="col-md-6 col-12"><div class="mb-4"><label for="dbfbshiuvnasb" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.title"))}</label><input id="dbfbshiuvnasb" type="text"${ssrRenderAttr("value", component.data["content"]["title"])} class="form-control"></div></div><div class="col-12"><div class="mb-4"><label for="dbfbshiuvnasb" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.description"))}</label><textarea id="dbfbshiuvnasb" type="text" rows="3" class="form-control lh-30">${ssrInterpolate(component.data["content"]["description"])}</textarea></div></div></div></div></div></div>`);
        } else {
          _push(`<!---->`);
        }
        if (component.type.indexOf("full_header_search_image") >= 0) {
          _push(`<div class="mb-4"><div class="row"><div class="col-12 mb-2 fw-bold text-dark">${ssrInterpolate(_ctx.$t("messages.sentence.component_styles"))}:</div><div class="col-12 mb-4"><div class="w-100 bg-light p-3 br-15 pb-0"><div class="row"><div class="col-lg-3 col-12"><div class="mb-4"><label for="podfnbijsnvac" class="form-label fs-9">${ssrInterpolate(_ctx.$t("messages.sentence.component_margin_top"))}</label><input id="podfnbijsnvac" type="text"${ssrRenderAttr("value", component.data["style"]["margin"]["top"])} class="form-control"></div></div><div class="col-lg-3 col-12"><div class="mb-4"><label for="pusvnvhsavjdbdd" class="form-label fs-9">${ssrInterpolate(_ctx.$t("messages.sentence.component_margin_bottom"))}</label><input id="pusvnvhsavjdbdd" type="text"${ssrRenderAttr("value", component.data["style"]["margin"]["bottom"])} class="form-control"></div></div></div></div></div><div class="col-12 mb-3"><div class="border"></div></div><div class="col-12 mb-3 fw-bold text-dark">${ssrInterpolate(_ctx.$t("messages.sentence.widgets_contents"))}:</div><div class="col-12 mb-3"><div class="row"><div class="col-md-6 col-12"><div class="mb-4"><label for="dbfbshiuvnasb" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.title"))}</label><input id="dbfbshiuvnasb" type="text"${ssrRenderAttr("value", component.data["content"]["title"])} class="form-control"></div></div><div class="col-12"><div class="mb-4"><label for="dbfbshiuvnasb" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.description"))}</label><textarea id="dbfbshiuvnasb" type="text" rows="3" class="form-control lh-30">${ssrInterpolate(component.data["content"]["description"])}</textarea></div></div><div class="col-12"><div class="mb-3"><label class="form-label">${ssrInterpolate(_ctx.$t("messages.word.image"))}</label><div class="full-header-search-upload-image-box" data-bs-toggle="modal" data-bs-target="#mediaLibrary"${ssrRenderAttr("data-bs-input", component.id + "image")}><img${ssrRenderAttr("src", component.data["content"]["image"]["src"])}${ssrRenderAttr("alt", component.data["content"]["image"]["alt"])}></div></div></div></div></div></div></div>`);
        } else {
          _push(`<!---->`);
        }
        if (component.type.indexOf("full_search_box") >= 0) {
          _push(`<div class="mb-4"><div class="row"><div class="col-12 mb-2 fw-bold text-dark">${ssrInterpolate(_ctx.$t("messages.sentence.component_styles"))}:</div><div class="col-12 mb-4"><div class="w-100 bg-light p-3 br-15 pb-0"><div class="row"><div class="col-lg-3 col-12"><div class="mb-4"><label for="tndbsadbmbmq" class="form-label fs-9">${ssrInterpolate(_ctx.$t("messages.sentence.component_margin_top"))}</label><input id="tndbsadbmbmq" type="text"${ssrRenderAttr("value", component.data["style"]["margin"]["top"])} class="form-control"></div></div><div class="col-lg-3 col-12"><div class="mb-4"><label for="dewyfdpgvmsjbb" class="form-label fs-9">${ssrInterpolate(_ctx.$t("messages.sentence.component_margin_bottom"))}</label><input id="dewyfdpgvmsjbb" type="text"${ssrRenderAttr("value", component.data["style"]["margin"]["bottom"])} class="form-control"></div></div></div></div></div><div class="col-12 mb-3"><div class="border"></div></div><div class="col-12 mb-3 fw-bold text-dark">${ssrInterpolate(_ctx.$t("messages.sentence.widgets_contents"))}:</div><div class="col-12 mb-3"><div class="row"><div class="col-md-6 col-12"><div class="mb-4"><label for="dbfbshiuvnasb" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.title"))}</label><input id="dbfbshiuvnasb" type="text"${ssrRenderAttr("value", component.data["content"]["title"])} class="form-control"></div></div></div></div></div></div>`);
        } else {
          _push(`<!---->`);
        }
        if (component.type.indexOf("text_ckeditor") >= 0) {
          _push(`<div class="mb-4"><div class="row"><div class="col-12 mb-2 fw-bold text-dark">${ssrInterpolate(_ctx.$t("messages.sentence.component_styles"))}:</div><div class="col-12 mb-4"><div class="w-100 bg-light p-3 br-15 pb-0 mb-4"><div class="row"><div class="col-lg-3 col-12"><div class="mb-4"><label for="tndbsadbmbmq" class="form-label fs-9">${ssrInterpolate(_ctx.$t("messages.sentence.component_margin_top"))}</label><input id="tndbsadbmbmq" type="text"${ssrRenderAttr("value", component.data["style"]["margin"]["top"])} class="form-control"></div></div><div class="col-lg-3 col-12"><div class="mb-4"><label for="dewyfdpgvmsjbb" class="form-label fs-9">${ssrInterpolate(_ctx.$t("messages.sentence.component_margin_bottom"))}</label><input id="dewyfdpgvmsjbb" type="text"${ssrRenderAttr("value", component.data["style"]["margin"]["bottom"])} class="form-control"></div></div></div></div><div class="row w-100"><div class="col-auto"><label class="form-label d-flex fw-bold lts-05 clickable"><input name="sgflpwod" type="checkbox"${ssrIncludeBooleanAttr(Array.isArray(component.data["settings"]["background"]) ? ssrLooseContain(component.data["settings"]["background"], "gradient") : component.data["settings"]["background"]) ? " checked" : ""} value="gradient" class="form-check clickable me-2"> ${ssrInterpolate(_ctx.$t("messages.sentence.with_background"))}</label></div><div class="col-auto"><label class="form-label d-flex fw-bold lts-05 clickable"><input name="sgflpwod" type="checkbox"${ssrIncludeBooleanAttr(Array.isArray(component.data["settings"]["collapsible"]) ? ssrLooseContain(component.data["settings"]["collapsible"], "gradient") : component.data["settings"]["collapsible"]) ? " checked" : ""} value="gradient" class="form-check clickable me-2"> ${ssrInterpolate(_ctx.$t("messages.sentence.collapsible"))}</label></div></div></div><div class="col-12 mb-3"><div class="border"></div></div><div class="col-12 mb-3 fw-bold text-dark">${ssrInterpolate(_ctx.$t("messages.sentence.widgets_contents"))}:</div><div class="col-12 mb-3"><div class="row"><div class="page-builder-ckeditor col-12 mb-4">`);
          _push(ssrRenderComponent(_sfc_main$a, {
            modelValue: component.data["content"],
            "onUpdate:modelValue": ($event) => component.data["content"] = $event
          }, null, _parent));
          _push(`</div></div></div></div></div>`);
        } else {
          _push(`<!---->`);
        }
        if (component.type.indexOf("categories_tabs") >= 0) {
          _push(`<div class="mb-4"><div class="row"><div class="col-12 mb-2 fw-bold text-dark">${ssrInterpolate(_ctx.$t("messages.sentence.component_styles"))}:</div><div class="col-12 mb-4"><div class="w-100 bg-light p-3 br-15 pb-0"><div class="row"><div class="col-lg-3 col-12"><div class="mb-4"><label for="pdsnbsiebasb" class="form-label fs-9">${ssrInterpolate(_ctx.$t("messages.sentence.component_margin_top"))}</label><input id="pdsnbsiebasb" type="text"${ssrRenderAttr("value", component.data["style"]["margin"]["top"])} class="form-control"></div></div><div class="col-lg-3 col-12"><div class="mb-4"><label for="yaspvamsobans" class="form-label fs-9">${ssrInterpolate(_ctx.$t("messages.sentence.component_margin_bottom"))}</label><input id="yaspvamsobans" type="text"${ssrRenderAttr("value", component.data["style"]["margin"]["bottom"])} class="form-control"></div></div></div></div></div><div class="col-12 mb-4"><div class="border"></div></div><div class="col-12 mb-3"><div class="row"><div class="col-md-6 col-12 mb-4"><label class="form-label title fs-8 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.select_product_list_for_showing"))}</label>`);
          _push(ssrRenderComponent(unref(Dropdown), {
            class: "pvc-dropdown flex-grow-1",
            modelValue: component.data["filter"],
            "onUpdate:modelValue": ($event) => component.data["filter"] = $event,
            options: rawProductList.value,
            display: "chip",
            optionLabel: "label",
            placeholder: _ctx.$t("messages.sentence.select_product_list")
          }, null, _parent));
          _push(`</div><div class="col-md-6 col-12 mb-4"><label class="form-label title fs-8 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.select_categories"))}</label>`);
          _push(ssrRenderComponent(unref(MultiSelect), {
            class: "pvc-multiselect pvc-multiselect-filter flex-grow-1",
            options: categoryList.value,
            filter: "",
            display: "chip",
            optionLabel: "title",
            optionValue: "id",
            placeholder: _ctx.$t("messages.sentence.select_category"),
            modelValue: component.data["categories_ids"],
            "onUpdate:modelValue": [
              ($event) => component.data["categories_ids"] = $event,
              (val) => component.data["categories"] = categoryList.value.filter((opt) => val.includes(opt.id)).map((opt) => ({ id: opt.id, title: opt.title }))
            ]
          }, {
            option: withCtx((slotProps, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<div class="category-template flex align-items-center"${_scopeId}><div class="${ssrRenderClass({
                  "category-level-one": slotProps.option.level == "one",
                  "category-level-two": slotProps.option.level == "two",
                  "category-level-three": slotProps.option.level == "three"
                })}"${_scopeId}>`);
                if (slotProps.option.level == "three") {
                  _push2(`<span${_scopeId}><i class="ri-arrow-drop-left-line"${_scopeId}></i></span>`);
                } else if (slotProps.option.level == "two") {
                  _push2(`<span${_scopeId}><i class="circle-icon ri-circle-fill"${_scopeId}></i></span>`);
                } else {
                  _push2(`<!---->`);
                }
                _push2(` ${ssrInterpolate(slotProps.option.title)}</div></div>`);
              } else {
                return [
                  createVNode("div", { class: "category-template flex align-items-center" }, [
                    createVNode("div", {
                      class: {
                        "category-level-one": slotProps.option.level == "one",
                        "category-level-two": slotProps.option.level == "two",
                        "category-level-three": slotProps.option.level == "three"
                      }
                    }, [
                      slotProps.option.level == "three" ? (openBlock(), createBlock("span", { key: 0 }, [
                        createVNode("i", { class: "ri-arrow-drop-left-line" })
                      ])) : slotProps.option.level == "two" ? (openBlock(), createBlock("span", { key: 1 }, [
                        createVNode("i", { class: "circle-icon ri-circle-fill" })
                      ])) : createCommentVNode("", true),
                      createTextVNode(" " + toDisplayString(slotProps.option.title), 1)
                    ], 2)
                  ])
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(`</div></div></div></div></div>`);
        } else {
          _push(`<!---->`);
        }
        if (component.type.indexOf("product_list") >= 0) {
          _push(`<div class="mb-4"><div class="row">`);
          if (component.type.indexOf("product_list") == 0) {
            _push(`<!--[--><div class="col-12 mb-2 fw-bold text-dark">${ssrInterpolate(_ctx.$t("messages.sentence.component_styles"))}:</div><div class="col-12 mb-4"><div class="w-100 bg-light p-3 br-15 pb-0"><div class="row"><div class="col-lg-3 col-12"><div class="mb-4"><label for="oihnauyvbans" class="form-label fs-9">${ssrInterpolate(_ctx.$t("messages.sentence.component_margin_top"))}</label><input id="oihnauyvbans" type="text"${ssrRenderAttr("value", component.data["style"]["margin"]["top"])} class="form-control"></div></div><div class="col-lg-3 col-12"><div class="mb-4"><label for="nqibvisajbsd" class="form-label fs-9">${ssrInterpolate(_ctx.$t("messages.sentence.component_margin_bottom"))}</label><input id="nqibvisajbsd" type="text"${ssrRenderAttr("value", component.data["style"]["margin"]["bottom"])} class="form-control"></div></div></div></div></div><!--]-->`);
          } else {
            _push(`<!---->`);
          }
          _push(`<div class="col-lg-6 col-12 mb-3"><label class="form-label title fs-8 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.select_product_list_for_showing"))}</label>`);
          _push(ssrRenderComponent(unref(Dropdown), {
            class: "pvc-dropdown flex-grow-1",
            modelValue: component.data["product_list"],
            "onUpdate:modelValue": ($event) => component.data["product_list"] = $event,
            options: productList.value,
            display: "chip",
            optionLabel: "label",
            placeholder: _ctx.$t("messages.sentence.select_product_list")
          }, null, _parent));
          _push(`</div>`);
          if (component.type.indexOf("product_box_list") >= 0) {
            _push(`<!--[--><div class="col-lg-6 color-picker col-12 mb-3"><label class="form-label title fs-8 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.product_box_color"))}</label><input id="componentColorPicker"${ssrRenderAttr("value", component.data["product_box_list"]["color"])}></div><div class="col-lg-6 col-12 mb-3"><label class="form-label title fs-8 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.product_box_image"))}</label><div class="upload-image-box" data-bs-toggle="modal" data-bs-target="#mediaLibrary"${ssrRenderAttr("data-bs-input", component.id + "image")}><img${ssrRenderAttr("src", component.data["product_box_list"]["image"]["src"])}${ssrRenderAttr("alt", component.data["product_box_list"]["image"]["alt"])}></div><span class="form-control-description">${ssrInterpolate(_ctx.$t("messages.sentence.image_size_must_be_260_160"))}</span></div><!--]-->`);
          } else {
            _push(`<!---->`);
          }
          _push(`</div></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div><div class="modal-footer"><button class="btn btn-sm btn-primary shadow-1 px-3" type="button" data-bs-dismiss="modal">${ssrInterpolate(_ctx.$t("messages.word.finish"))}</button></div></div></div></div></ul>`);
        ssrRenderVNode(_push, createVNode(resolveDynamicComponent(component.component), {
          component_id: component.id,
          data: component.data,
          status: "dev"
        }, null), _parent);
        _push(`</div></div></div>`);
      });
      _push(`<!--]--></div><div class="row"><div class="col-12 mb-2"><div class="ui-box-container"><div class="ui-box"><ul class="ui-box-action">`);
      if (unref(templateForm).footer == "") {
        _push(`<li data-bs-toggle="modal" data-bs-target="#footerElements"><i class="ri-add-line"></i></li>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(templateForm).footer != "") {
        _push(`<li class="trash"><i class="ri-delete-bin-5-line"></i></li>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</ul>`);
      if (unref(templateForm).footer == "") {
        _push(`<div class="ui-box-temp-message"><span>${ssrInterpolate(_ctx.$t("messages.sentence.select_footer"))}</span></div>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(templateForm).footer != "") {
        ssrRenderVNode(_push, createVNode(resolveDynamicComponent(unref(templateForm).footer), { status: "dev" }, null), _parent);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div></div></div></div></div><div class="tab-pane fade" id="product-tab-pane" role="tabpanel" aria-labelledby="product-tab" tabindex="0"><div class="card-body"><div class="row"><div class="col-12 mt-3"><div class="form-check form-switch"><label class="form-check-label lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.product_page_tabs_status"))} <input${ssrIncludeBooleanAttr(Array.isArray(unref(templateForm).main_data.product.settings.tabs_status) ? ssrLooseContain(unref(templateForm).main_data.product.settings.tabs_status, null) : unref(templateForm).main_data.product.settings.tabs_status) ? " checked" : ""} class="form-check-input" type="checkbox" role="switch"></label></div></div><div class="col-12 my-4"><div class="border"></div></div><div class="col-12"><span class="text-gray d-flex align-items-center justify-content-center lts-05 p-5 pt-4">طی بروزرسانی های آتی امکان تغییرات در چیدمان صفحه محصول اضافه خواهد شد.</span></div></div></div></div><div class="tab-pane fade" id="blog-tab-pane" role="tabpanel" aria-labelledby="blog-tab" tabindex="0"><div class="card-body p-2"><div class="row"><div class="col-12"><div class="ui-box-container"><div class="ui-box"><ul class="ui-box-action">`);
      if (unref(templateForm).header == "") {
        _push(`<li data-bs-toggle="modal" data-bs-target="#headerElements"><i class="ri-add-line"></i></li>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(templateForm).header != "") {
        _push(`<li class="trash"><i class="ri-delete-bin-5-line"></i></li>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</ul>`);
      if (unref(templateForm).header == "") {
        _push(`<div class="ui-box-temp-message"><span>${ssrInterpolate(_ctx.$t("messages.sentence.select_header"))}</span></div>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(templateForm).header != "") {
        ssrRenderVNode(_push, createVNode(resolveDynamicComponent(unref(templateForm).header), { status: "dev" }, null), _parent);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div></div></div><div id="BlogPageSort" class="row"><!--[-->`);
      ssrRenderList(blogComponents, (component, index) => {
        _push(`<div${ssrRenderAttr("index", index)} class="col-12 component"><div class="ui-box-container"><div class="ui-box"><ul class="ui-box-action">`);
        if (component.settings) {
          _push(`<li${ssrRenderAttrs(mergeProps({
            "data-bs-toggle": "modal",
            "data-bs-target": "#component-settings-" + component.id
          }, ssrGetDirectiveProps(_ctx, _directive_tooltip, _ctx.$t("messages.sentence.element_settings"), void 0, { left: true })))}><i class="ri-settings-3-line"></i></li>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<li${ssrRenderAttrs(mergeProps({ class: "trash" }, ssrGetDirectiveProps(_ctx, _directive_tooltip, _ctx.$t("messages.word.delete"), void 0, { left: true })))}><i class="ri-delete-bin-5-line"></i></li><li${ssrRenderAttrs(mergeProps({ class: "blog-sort-handle" }, ssrGetDirectiveProps(_ctx, _directive_tooltip, _ctx.$t("messages.word.displacement"), void 0, { left: true })))}><i class="ri-draggable"></i></li><div class="modal fade ui-elements-modal"${ssrRenderAttr("id", "component-settings-" + component.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-xl modal-dialog-centered"><div class="modal-content p-4"><div class="modal-header"><div class="modal-title lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.element_settings"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body">`);
        if (component.type.indexOf("slider") >= 0) {
          _push(`<div class="mb-4"><div class="row"><div class="col-12 mb-2 fw-bold text-dark">${ssrInterpolate(_ctx.$t("messages.sentence.component_styles"))}:</div><div class="col-12 mb-4"><div class="w-100 bg-light p-3 br-15 pb-0"><div class="row"><div class="col-lg-3 col-12"><div class="mb-4"><label for="dfosnidvasdbdf" class="form-label fs-9">${ssrInterpolate(_ctx.$t("messages.sentence.component_margin_top"))}</label><input id="dfosnidvasdbdf" type="text"${ssrRenderAttr("value", component.data["style"]["margin"]["top"])} class="form-control"></div></div><div class="col-lg-3 col-12"><div class="mb-4"><label for="ajisbvuyasbvds" class="form-label fs-9">${ssrInterpolate(_ctx.$t("messages.sentence.component_margin_bottom"))}</label><input id="ajisbvuyasbvds" type="text"${ssrRenderAttr("value", component.data["style"]["margin"]["bottom"])} class="form-control"></div></div></div></div></div><div class="col-12 title fs-8 mb-2">${ssrInterpolate(_ctx.$t("messages.sentence.slider_item_setting"))}</div><div class="col-12 mb-3"><ul class="add-slider-items row"><!--[-->`);
          ssrRenderList(component.data["slider"], (slider, i) => {
            _push(`<li class="col-6"><div class="inner"><button${ssrRenderAttrs(mergeProps({
              class: "remove-icon btn btn-xs btn-square btn-danger",
              type: "button"
            }, ssrGetDirectiveProps(_ctx, _directive_tooltip, _ctx.$t("messages.word.delete"), void 0, { top: true })))}><i class="ri-delete-bin-6-line"></i></button><img${ssrRenderAttr("src", slider["src"])}${ssrRenderAttr("alt", slider["alt"])}><input${ssrRenderAttr("value", slider["link"])} type="text" class="form-control" placeholder="banner link ..."></div></li>`);
          });
          _push(`<!--]--></ul><button${ssrRenderAttrs(mergeProps({
            "data-bs-toggle": "modal",
            "data-bs-target": "#mediaLibrary",
            "data-bs-input": component.id + "slider",
            class: "btn btn-sm btn-square btn-primary mt-2"
          }, ssrGetDirectiveProps(_ctx, _directive_tooltip, _ctx.$t("messages.word.add"), void 0, { top: true })))}><i class="ri-add-line"></i></button></div></div></div>`);
        } else {
          _push(`<!---->`);
        }
        if (component.type.indexOf("banner") >= 0) {
          _push(`<div class="mb-4"><div class="row"><div class="col-12 mb-2 fw-bold text-dark">${ssrInterpolate(_ctx.$t("messages.sentence.component_styles"))}:</div><div class="col-12 mb-4"><div class="w-100 bg-light p-3 br-15 pb-0"><div class="row"><div class="col-lg-3 col-12"><div class="mb-4"><label for="iogsmbjsodinb" class="form-label fs-9">${ssrInterpolate(_ctx.$t("messages.sentence.component_margin_top"))}</label><input id="iogsmbjsodinb" type="text"${ssrRenderAttr("value", component.data["style"]["margin"]["top"])} class="form-control"></div></div><div class="col-lg-3 col-12"><div class="mb-4"><label for="pskbijanvasdv" class="form-label fs-9">${ssrInterpolate(_ctx.$t("messages.sentence.component_margin_bottom"))}</label><input id="pskbijanvasdv" type="text"${ssrRenderAttr("value", component.data["style"]["margin"]["bottom"])} class="form-control"></div></div></div></div></div><div class="col-12 title fs-8 mb-2">${ssrInterpolate(_ctx.$t("messages.sentence.banner_item_setting"))}</div><div class="col-12 mb-3"><ul class="add-slider-items row"><!--[-->`);
          ssrRenderList(component.data["banner"], (banner, i) => {
            _push(`<li class="${ssrRenderClass({
              "col-lg-3 col-md-6 col-12 mb-3": component.data["count"] == 4,
              "col-lg-6 mb-4": component.data["count"] == 2,
              "col-12 mb-4": component.data["count"] == 1
            })}"><div class="inner mb-3">`);
            if (banner.mobile !== void 0) {
              _push(`<span class="lts-05 mb-3 text-dark">${ssrInterpolate(_ctx.$t("messages.word.desktop"))}</span>`);
            } else {
              _push(`<!---->`);
            }
            _push(`<button${ssrRenderAttrs(mergeProps({
              class: "remove-icon btn btn-xs btn-square btn-danger",
              type: "button"
            }, ssrGetDirectiveProps(_ctx, _directive_tooltip, _ctx.$t("messages.word.delete"), void 0, { top: true })))}><i class="ri-delete-bin-6-line"></i></button><img${ssrRenderAttr("src", banner["src"])}${ssrRenderAttr("alt", banner["alt"])} style="${ssrRenderStyle({ "height": "auto" })}"><input${ssrRenderAttr("value", banner["link"])} type="text" class="form-control" placeholder="banner link ..."></div>`);
            if (banner.mobile !== void 0 && banner["mobile"]["src"] != null) {
              _push(`<div class="inner"><span class="lts-05 mb-3 text-dark">${ssrInterpolate(_ctx.$t("messages.word.mobile"))}</span><button${ssrRenderAttrs(mergeProps({
                class: "remove-icon btn btn-xs btn-square btn-danger",
                type: "button"
              }, ssrGetDirectiveProps(_ctx, _directive_tooltip, _ctx.$t("messages.word.delete"), void 0, { top: true })))}><i class="ri-delete-bin-6-line"></i></button><img${ssrRenderAttr("src", banner["mobile"]["src"])}${ssrRenderAttr("alt", banner["mobile"]["alt"])} style="${ssrRenderStyle({ "height": "auto" })}"></div>`);
            } else {
              _push(`<!---->`);
            }
            if (banner.mobile !== void 0 && banner.mobile.src == null) {
              _push(`<button${ssrRenderAttrs(mergeProps({
                "data-bs-toggle": "modal",
                "data-bs-target": "#mediaLibrary",
                "data-bs-input": component.id + "banner-single-mobile",
                class: "btn btn-primary fs-9 mt-1"
              }, ssrGetDirectiveProps(_ctx, _directive_tooltip, _ctx.$t("messages.word.add"), void 0, { top: true })))}>${ssrInterpolate(_ctx.$t("messages.sentence.add_mobile_banner"))}</button>`);
            } else {
              _push(`<!---->`);
            }
            _push(`</li>`);
          });
          _push(`<!--]--></ul>`);
          if (component.data["banner"].length < component.data["count"]) {
            _push(`<button${ssrRenderAttrs(mergeProps({
              "data-bs-toggle": "modal",
              "data-bs-target": "#mediaLibrary",
              "data-bs-input": component.type.indexOf("banner-single") >= 0 ? component.id + "banner-single" : component.id + "banner",
              class: "btn btn-sm btn-square btn-primary mt-2"
            }, ssrGetDirectiveProps(_ctx, _directive_tooltip, _ctx.$t("messages.word.add"), void 0, { top: true })))}><i class="ri-add-line"></i></button>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</div></div></div>`);
        } else {
          _push(`<!---->`);
        }
        if (component.type.indexOf("category_list") >= 0) {
          _push(`<div class="mb-4"><div class="row"><div class="col-12 mb-2 fw-bold text-dark">${ssrInterpolate(_ctx.$t("messages.sentence.component_styles"))}:</div><div class="col-12 mb-4"><div class="w-100 bg-light p-3 br-15 pb-0"><div class="row"><div class="col-lg-3 col-12"><div class="mb-4"><label for="psdjbisudnbfdb" class="form-label fs-9">${ssrInterpolate(_ctx.$t("messages.sentence.component_margin_top"))}</label><input id="psdjbisudnbfdb" type="text"${ssrRenderAttr("value", component.data["style"]["margin"]["top"])} class="form-control"></div></div><div class="col-lg-3 col-12"><div class="mb-4"><label for="pdwnmbdosaiuvb" class="form-label fs-9">${ssrInterpolate(_ctx.$t("messages.sentence.component_margin_bottom"))}</label><input id="pdwnmbdosaiuvb" type="text"${ssrRenderAttr("value", component.data["style"]["margin"]["bottom"])} class="form-control"></div></div></div></div></div></div></div>`);
        } else {
          _push(`<!---->`);
        }
        if (component.type.indexOf("article_list") >= 0) {
          _push(`<div class="mb-4"><div class="row"><div class="col-12 mb-2 fw-bold text-dark">${ssrInterpolate(_ctx.$t("messages.sentence.component_styles"))}:</div><div class="col-12 mb-4"><div class="w-100 bg-light p-3 br-15 pb-0"><div class="row"><div class="col-lg-3 col-12"><div class="mb-4"><label for="spdoibjiusdbnfmg" class="form-label fs-9">${ssrInterpolate(_ctx.$t("messages.sentence.component_margin_top"))}</label><input id="spdoibjiusdbnfmg" type="text"${ssrRenderAttr("value", component.data["style"]["margin"]["top"])} class="form-control"></div></div><div class="col-lg-3 col-12"><div class="mb-4"><label for="osihnjviusdnb" class="form-label fs-9">${ssrInterpolate(_ctx.$t("messages.sentence.component_margin_bottom"))}</label><input id="osihnjviusdnb" type="text"${ssrRenderAttr("value", component.data["style"]["margin"]["bottom"])} class="form-control"></div></div></div></div></div><div class="col-lg-6 col-12 mb-3"><label class="form-label title fs-8 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.select_article_list_for_showing"))}</label>`);
          _push(ssrRenderComponent(unref(Dropdown), {
            class: "pvc-dropdown flex-grow-1",
            modelValue: component.data["article_list"],
            "onUpdate:modelValue": ($event) => component.data["article_list"] = $event,
            options: articleList.value,
            display: "chip",
            optionLabel: "label",
            placeholder: _ctx.$t("messages.sentence.select_article_list")
          }, null, _parent));
          _push(`</div></div></div>`);
        } else {
          _push(`<!---->`);
        }
        if (component.type.indexOf("hashtags") >= 0) {
          _push(`<div class="mb-4"><div class="row"><div class="col-12 mb-2 fw-bold text-dark">${ssrInterpolate(_ctx.$t("messages.sentence.component_styles"))}:</div><div class="col-12 mb-4"><div class="w-100 bg-light p-3 br-15 pb-0"><div class="row"><div class="col-lg-3 col-12"><div class="mb-4"><label for="uebaskjisbhgd" class="form-label fs-9">${ssrInterpolate(_ctx.$t("messages.sentence.component_margin_top"))}</label><input id="uebaskjisbhgd" type="text"${ssrRenderAttr("value", component.data["style"]["margin"]["top"])} class="form-control"></div></div><div class="col-lg-3 col-12"><div class="mb-4"><label for="ovasuifbvdsddbvb" class="form-label fs-9">${ssrInterpolate(_ctx.$t("messages.sentence.component_margin_bottom"))}</label><input id="ovasuifbvdsddbvb" type="text"${ssrRenderAttr("value", component.data["style"]["margin"]["bottom"])} class="form-control"></div></div></div></div></div></div></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div><div class="modal-footer"><button class="btn btn-sm btn-primary shadow-1 px-3" type="button" data-bs-dismiss="modal">${ssrInterpolate(_ctx.$t("messages.word.finish"))}</button></div></div></div></div></ul>`);
        ssrRenderVNode(_push, createVNode(resolveDynamicComponent(component.component), {
          component_id: component.id,
          data: component.data,
          status: "dev"
        }, null), _parent);
        _push(`</div></div></div>`);
      });
      _push(`<!--]--></div><div class="row"><div class="col-12 mb-2"><div class="ui-box-container"><div class="ui-box"><ul class="ui-box-action">`);
      if (unref(templateForm).footer == "") {
        _push(`<li data-bs-toggle="modal" data-bs-target="#footerElements"><i class="ri-add-line"></i></li>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(templateForm).footer != "") {
        _push(`<li class="trash"><i class="ri-delete-bin-5-line"></i></li>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</ul>`);
      if (unref(templateForm).footer == "") {
        _push(`<div class="ui-box-temp-message"><span>${ssrInterpolate(_ctx.$t("messages.sentence.select_footer"))}</span></div>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(templateForm).footer != "") {
        ssrRenderVNode(_push, createVNode(resolveDynamicComponent(unref(templateForm).footer), { status: "dev" }, null), _parent);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div></div></div></div></div><div class="tab-pane fade" id="article-tab-pane" role="tabpanel" aria-labelledby="article-tab" tabindex="0"><div class="card-body"><div class="row"><div class="tab-title lts-05 mb-3"><div>${ssrInterpolate(_ctx.$t("messages.sentence.sidebar_banners"))}</div></div><div class="col-12 mb-4"><button${ssrRenderAttrs(mergeProps({
        class: "btn btn-square btn-xs btn-primary mb-4",
        "data-bs-toggle": "modal",
        "data-bs-target": "#mediaLibrary",
        "data-bs-input": "blog-banners"
      }, ssrGetDirectiveProps(_ctx, _directive_tooltip, _ctx.$t("messages.word.add"), void 0, { top: true })))}><i class="ri-add-line"></i></button><div class="row add-banner-container"><!--[-->`);
      ssrRenderList(blogSidebarBanners, (banner, index) => {
        _push(`<div class="col-4 mb-4"><div class="card"><div class="inner"><button${ssrRenderAttrs(mergeProps({
          class: "remove-icon btn btn-xs btn-square btn-danger",
          type: "button"
        }, ssrGetDirectiveProps(_ctx, _directive_tooltip, _ctx.$t("messages.word.delete"), void 0, { top: true })))}><i class="ri-delete-bin-6-line"></i></button><img${ssrRenderAttr("src", banner.url)}${ssrRenderAttr("alt", banner.alt)} class="w-100"><input${ssrRenderAttr("value", banner.link)} type="text" class="form-control" placeholder="banner link ..."></div></div></div>`);
      });
      _push(`<!--]--></div></div></div></div></div><div class="tab-pane fade" id="style-tab-pane" role="tabpanel" aria-labelledby="style-tab" tabindex="0"><div class="card-body"><div class="row"><div class="col-md-4 col-12"><div class="tab-title lts-05 mb-3"><div>${ssrInterpolate(_ctx.$t("messages.sentence.site_main_color"))} <span>${ssrInterpolate(_ctx.$t("messages.sentence.select_site_main_color"))}</span></div></div><div class="color-picker mb-4"><input id="siteMainColor"${ssrRenderAttr("value", siteMainColor.value)}></div></div><div class="col-md-4 col-12"><div class="tab-title lts-05 mb-3"><div>${ssrInterpolate(_ctx.$t("messages.sentence.site_secondary_color"))} <span>${ssrInterpolate(_ctx.$t("messages.sentence.select_site_secondary_color"))}</span></div></div><div class="color-picker mb-4"><input id="siteSecondaryColor"${ssrRenderAttr("value", siteSecondaryColor.value)}></div></div><div class="col-md-4 col-12"><div class="tab-title lts-05 mb-3"><div>${ssrInterpolate(_ctx.$t("messages.sentence.site_background_color"))} <span>${ssrInterpolate(_ctx.$t("messages.sentence.select_site_background_color"))}</span></div></div><div class="color-picker mb-4"><input id="siteBackgroundColor"${ssrRenderAttr("value", siteBackgroundColor.value)}></div></div><div class="col-md-4 col-12"><div class="tab-title lts-05 mb-3"><div>${ssrInterpolate(_ctx.$t("messages.sentence.site_box_shadow"))} <span>${ssrInterpolate(_ctx.$t("messages.sentence.select_site_box_shadow"))}</span></div></div><div class="range-slider"><label for="customRange2" class="form-label mb-1">${ssrInterpolate(_ctx.$t("messages.word.value"))}: ${ssrInterpolate(unref(templateForm).options.style.site_main_shadow)}</label><input${ssrRenderAttr("value", unref(templateForm).options.style.site_main_shadow)} type="range" class="form-range" min="0" max="0.05" step="0.01"></div></div><div class="col-md-4 col-12"><div class="tab-title lts-05 mb-3"><div>${ssrInterpolate(_ctx.$t("messages.sentence.header_categories_style"))} <span>${ssrInterpolate(_ctx.$t("messages.sentence.header_categories_style_desc"))}</span></div></div>`);
      _push(ssrRenderComponent(unref(Dropdown), {
        class: "pvc-dropdown flex-grow-1",
        modelValue: unref(templateForm).options.style.header_categories_style,
        "onUpdate:modelValue": ($event) => unref(templateForm).options.style.header_categories_style = $event,
        options: [
          { id: "dropdown", label: "منوی کشویی" },
          { id: "megamenu", label: "مگامنو" }
        ],
        display: "chip",
        optionValue: "id",
        optionLabel: "label",
        placeholder: _ctx.$t("messages.sentence.select_category_list")
      }, null, _parent));
      _push(`</div><div class="col-12 my-4"><div class="border"></div></div><div class="col-lg-6 col-12 mb-4"><div class="text-dark fw-bold fs-6 lts-05 mb-2">${ssrInterpolate(_ctx.$t("messages.sentence.custom_css"))}</div>`);
      _push(ssrRenderComponent(CodeMirror, {
        modelValue: customCss.value,
        "onUpdate:modelValue": ($event) => customCss.value = $event,
        language: "css"
      }, null, _parent));
      _push(`<div class="mt-2"><span class="fs-8 lts-05 text-light-gray">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_596963"))}</span></div></div><div class="col-lg-6 col-12 mb-4"><div class="text-dark fw-bold fs-6 lts-05 mb-2">${ssrInterpolate(_ctx.$t("messages.sentence.custom_js"))}</div>`);
      _push(ssrRenderComponent(CodeMirror, {
        modelValue: customJs.value,
        "onUpdate:modelValue": ($event) => customJs.value = $event,
        language: "javascript"
      }, null, _parent));
      _push(`<div class="mt-2"><span class="fs-8 lts-05 text-light-gray">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_512369"))}</span></div></div></div></div></div></div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Admin/Templates/Edit.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
