import { defineComponent, ref, watch, unref, withCtx, createTextVNode, toDisplayString, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderStyle, ssrRenderAttr, ssrIncludeBooleanAttr, ssrRenderList, ssrRenderClass } from "vue/server-renderer";
import { _ as _sfc_main$1 } from "./AdminLayout-CD07IMsK.js";
import { useForm, Head, Link } from "@inertiajs/vue3";
import { _ as _sfc_main$2 } from "./Files-B6eiTnN6.js";
import "toastify-js";
import "./useToastify-D_n0s7Uc.js";
import "laravel-vue-i18n";
import { u as useNumberFormat } from "../ssr.js";
import { _ as _sfc_main$3 } from "./NumInput-Bt6uFGO4.js";
import "simplebar";
import "resize-observer-polyfill";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "./Pagination-C1AQrLe3.js";
import "./SearchList-BZnYMQPN.js";
import "lodash/debounce.js";
import "./useRandomNum-DNNSqR7b.js";
import "@vue/server-renderer";
import "@inertiajs/vue3/server";
import "ziggy-js";
import "axios";
import "swiper/bundle";
import "jquery";
import "swiper";
import "./useRandomStr-4MeWbtRd.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "Edit",
  __ssrInlineRender: true,
  props: {
    prefactor: {},
    user: {},
    order: {}
  },
  setup(__props) {
    const productUUID = ref(null);
    const productWidget = ref(null);
    const searchProductStatus = ref(false);
    const selectedInventory = ref();
    const count = ref();
    const changeCount = (inventory) => {
      if (inventory != null) {
        if (inventory.max_sale == null) {
          if (count.value > inventory.count) {
            count.value = Number(inventory.count);
          }
        } else if (count.value > inventory.max_sale) {
          count.value = Number(inventory.max_sale);
          if (count.value > inventory.count) {
            count.value = Number(inventory.count);
          }
        }
        if (count.value < inventory.min_sale) {
          count.value = Number(inventory.min_sale);
        }
      }
    };
    watch(selectedInventory, (value) => {
      if (value != null) {
        count.value = Number(value.min_sale);
      }
    });
    const addDiscountForm = useForm({
      code: null
    });
    const issuingPrefactorForm = useForm({
      expired_at: null
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.issuing_prefactor")
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.sentence.issuing_prefactor")
      }, null, _parent));
      _push(`<div class="card cart-list list"><div class="card-body p-md-4 p-3"><div class="d-flex align-items-center justify-content-between mb-3"><div class="d-flex flex-md-row flex-column align-items-start justify-content-center"><div class="mb-md-0 mb-2"><span class="text-gray lts-05 fs-8">${ssrInterpolate(_ctx.$t("messages.sentence.factor_id"))}: </span><span class="fw-bold text-dark">${ssrInterpolate(_ctx.prefactor.uuid)}</span></div><div class="ms-0 ms-md-3"><span class="text-gray lts-05 fs-8">${ssrInterpolate(_ctx.$t("messages.word.customer"))}: </span>`);
      _push(ssrRenderComponent(unref(Link), {
        class: "link lts-05 fw-bold",
        href: _ctx.route("admin.users.show", _ctx.user.id)
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.user.get_name)}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.user.get_name), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div></div>`);
      if (_ctx.prefactor.status == "awaiting_issuance") {
        _push(`<div class="d-flex flex-sm-row flex-column-reverse align-items-end justify-content-center"><button class="btn btn-light fs-8 fw-normal px-3 mb-1" data-bs-toggle="modal" data-bs-target="#addDiscount">${ssrInterpolate(_ctx.$t("messages.sentence.add_discount"))} <i class="ri-percent-fill ms-1"></i></button><button class="btn btn-primary fs-8 fw-bold px-3 ms-2 mb-1" data-bs-toggle="modal" data-bs-target="#addToCart">${ssrInterpolate(_ctx.$t("messages.sentence.add_product"))} <i class="ri-add-line"></i></button></div>`);
      } else {
        _push(`<div>`);
        if (_ctx.prefactor.status == "paid") {
          _push(`<span class="badge bg-success rounded-pill fs-7" style="${ssrRenderStyle({ "font-size": "14px !important" })}">${ssrInterpolate(_ctx.$t("messages.word.paid"))}</span>`);
        } else if (_ctx.prefactor.is_expired) {
          _push(`<span class="badge bg-danger rounded-pill fs-7" style="${ssrRenderStyle({ "font-size": "14px !important" })}">${ssrInterpolate(_ctx.$t("messages.word.expired"))}</span>`);
        } else if (_ctx.prefactor.status == "waiting_payment") {
          _push(`<span class="badge bg-warning rounded-pill fs-7" style="${ssrRenderStyle({ "font-size": "14px !important" })}">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_pay"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div>`);
      }
      _push(`<div class="modal fade users-add-to-cart-modal" id="addDiscount" tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><form class="d-block w-100"><div class="modal-header pb-2"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.add_discount_to_prefactor"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12 mb-4"><div class="lts-05 lh-25 fs-9 alert alert-info br-15 fw-normal mb-1">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_101253"))}</div></div><div class="col-12 mb-3"><label for="eaDiscountCode" class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.discount_code"))}</label><input${ssrRenderAttr("value", unref(addDiscountForm).code)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.enter_discount_code"))} class="form-control" id="eaDiscountCode" style="${ssrRenderStyle({ "direction": "ltr" })}"></div></div></div><div class="modal-footer"><button class="btn btn-sm btn-primary px-3">${ssrInterpolate(_ctx.$t("messages.word.apply"))}</button></div></form></div></div></div><div class="modal fade users-add-to-cart-modal" id="addToCart" tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-lg modal-dialog-centered"><div class="modal-content"><div class="modal-header pb-2"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.add_product_to_prefactor"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12 mb-4"><div class="lts-05 lh-25 fs-9 alert alert-light br-15 fw-bold mb-1">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_144525"))}</div><div class="lts-05 lh-25 fs-9 alert alert-light br-15">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_589593"))}</div></div><div class="col-12 mb-3"><label for="eaWidgetProduct" class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.add_product"))} <span class="fs-9 text-gray fw-light">(${ssrInterpolate(_ctx.$t("messages.sentence.product_uuid"))})</span></label><div class="search-product-input d-flex align-items-center mb-2">`);
      if (productWidget.value != null) {
        _push(`<button class="btn btn-danger btn-square btn-xs btn-delete"><i class="ri-close-line"></i></button>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<input${ssrRenderAttr("value", productUUID.value)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.example") + ": p-1234567")} class="form-control" id="eaWidgetProduct" style="${ssrRenderStyle({ "direction": "ltr" })}"><button class="btn btn-dark ms-1 btn-square" type="button"${ssrIncludeBooleanAttr(searchProductStatus.value) ? " disabled" : ""}>`);
      if (searchProductStatus.value) {
        _push(`<i class="ri-refresh-line i-spin"></i>`);
      } else {
        _push(`<i class="ri-search-2-line"></i>`);
      }
      _push(`</button></div></div>`);
      if (productWidget.value != null) {
        _push(`<!--[--><div class="col-12 mb-3"><div class="fw-light fs-8 text-gray mb-1">${ssrInterpolate(_ctx.$t("messages.sentence.product_title"))}:</div><a${ssrRenderAttr("href", _ctx.route("main.products.show", productWidget.value.slug))} target="_blank" class="link title">${ssrInterpolate(productWidget.value.title)}</a></div>`);
        if (productWidget.value.inventory_status["inquery"]) {
          _push(`<div class="col-12 mb-3"><span class="d-inline-block alert alert-info text-info fs-9 px-3 py-1 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.product_status_is_inquery_mode"))}</span></div>`);
        } else {
          _push(`<!---->`);
        }
        if (!productWidget.value.inventory_status["inventory"]) {
          _push(`<div class="col-12 mb-3"><span class="d-inline-block alert alert-danger text-danger lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.product_inventory_is_empty"))}</span></div>`);
        } else if (!productWidget.value.inventory_status["instock"]) {
          _push(`<div class="col-12 mb-3"><span class="d-inline-block alert alert-danger text-danger lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.product_outofstock"))}</span></div>`);
        } else {
          _push(`<div class="product-inventory-list col-12"><div class="text-dark lts-05 mb-2">${ssrInterpolate(_ctx.$t("messages.sentence.select_one_item"))}:</div><ul><!--[-->`);
          ssrRenderList(productWidget.value.inventories, (inventory) => {
            _push(`<li class="d-flex align-items-center"><div class="radio-select"><label class="${ssrRenderClass({ clickable: true, active: selectedInventory.value != null && selectedInventory.value.id == inventory.id })}">`);
            if (selectedInventory.value != null && selectedInventory.value.id == inventory.id) {
              _push(`<i class="ri-check-line"></i>`);
            } else {
              _push(`<!---->`);
            }
            _push(`</label></div><div class="inventory-data d-flex align-items-end justify-content-between flex-grow-1"><div>`);
            if (inventory.store_id != null) {
              _push(`<a${ssrRenderAttr("href", _ctx.route("main.stores.show", inventory.store.uuid))} target="_blank" class="link lts-05 mb-2">${ssrInterpolate(inventory.store.name)}</a>`);
            } else {
              _push(`<a href="javascript:void(0)" class="link lts-05 mb-2">${ssrInterpolate(_ctx.$t("messages.sentence.main_shop"))}</a>`);
            }
            _push(`<ul><!--[-->`);
            ssrRenderList(inventory.props, (prop, ci) => {
              _push(`<li class="d-inline-flex align-items-center"><span class="title lts-05 text-gray me-1">${ssrInterpolate(prop.name)}: </span>`);
              if (prop.type == "color") {
                _push(`<div><span class="color" style="${ssrRenderStyle("background-color:" + prop.value.color)}"></span><span class="text-dark fs-8 lts-05 ms-1">${ssrInterpolate(prop.value.label)}</span></div>`);
              } else {
                _push(`<div class="text-dark fs-8 lts-05">${ssrInterpolate(prop.value)}</div>`);
              }
              _push(`</li>`);
            });
            _push(`<!--]--></ul>`);
            if (selectedInventory.value != null && selectedInventory.value.id == inventory.id) {
              _push(`<div class="price-count-container mt-2"><div class="count-container"><span class="increase"><i class="ri-add-line"></i></span>`);
              _push(ssrRenderComponent(_sfc_main$3, {
                modelValue: count.value,
                "onUpdate:modelValue": ($event) => count.value = $event,
                onChange: ($event) => changeCount(inventory),
                type: "text",
                name: "count",
                minlength: "1",
                maxlength: "4",
                autocomplete: "off"
              }, null, _parent));
              _push(`<span class="decrease"><i class="ri-subtract-line"></i></span></div></div>`);
            } else {
              _push(`<!---->`);
            }
            _push(`</div><div><div class="cart-item--price fa-num">`);
            if (inventory.discount_price > 0) {
              _push(`<div class="cart-item--discount lts-05"><del>${ssrInterpolate(unref(useNumberFormat)(inventory.discount_price))}</del></div>`);
            } else {
              _push(`<!---->`);
            }
            _push(`<div class="cart-item--price-now text-dark lts-05"><span>${ssrInterpolate(unref(useNumberFormat)(inventory.get_final_price))}</span><span class="unit unit-sm"></span></div></div></div></div></li>`);
          });
          _push(`<!--]--></ul></div>`);
        }
        _push(`<!--]-->`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div>`);
      if (selectedInventory.value != null && selectedInventory.value != null) {
        _push(`<div class="modal-footer"><button class="btn btn-sm btn-primary px-3">${ssrInterpolate(_ctx.$t("messages.word.add"))}</button></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div></div></div><div class="d-block border mb-3"></div>`);
      if (_ctx.order.items.length > 0) {
        _push(`<div class="cart-amount d-block w-100 mb-4"><div class="row checkout"><div class="checkout-row col-md-auto col-6 white-space-nowrap mb-3"><div class="checkout-row-label lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.ware_prices"))} (${ssrInterpolate(_ctx.order.items.length)})</div><div class="checkout-row-value lts-05"><span class="fw-bold fs-6">${ssrInterpolate(unref(useNumberFormat)(_ctx.order.totalPrice))}</span><span class="unit unit-sm lts-05"></span></div></div><div class="checkout-row col-md-auto col-6 white-space-nowrap mb-3"><div class="checkout-row-label lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.ware_discounts"))}</div><div class="checkout-row-value lts-05"><span class="fs-6 fw-bold text-danger">${ssrInterpolate(unref(useNumberFormat)(_ctx.order.totalDiscount))}</span><span class="unit-red unit-sm lts-05 text-danger"></span></div></div>`);
        if (_ctx.order.discountCode != null) {
          _push(`<div class="checkout-row col-md-auto col-6 white-space-nowrap mb-3"><div class="checkout-row-label d-inline-flex align-items-center lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.discount_code"))} <i class="ri-information-line link fw-bold ms-1" data-bs-toggle="modal" data-bs-target="#discountDetails"></i></div><div class="checkout-row-value lts-05"><span class="fs-6 fw-bold text-danger">${ssrInterpolate(unref(useNumberFormat)(_ctx.order.discountCode["amount"]))}</span><span class="unit-red unit-sm lts-05"></span></div><div class="modal fade" id="discountDetails" tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.discount_code_details"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12"><div class="table-responsive"><table class="table" style="${ssrRenderStyle({ "width": "100%", "min-width": "100%" })}"><tbody><tr><td class="lts-05">${ssrInterpolate(_ctx.$t("messages.word.title"))}</td><td>${ssrInterpolate(_ctx.order.discountCode["information"]["title"])}</td></tr><tr><td class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.discount_code"))}</td><td>${ssrInterpolate(_ctx.order.discountCode["information"]["code"])}</td></tr></tbody></table></div></div></div></div><div class="modal-footer"><button class="btn btn-primary" type="button" data-bs-dismiss="modal" aria-label="Close">${ssrInterpolate(_ctx.$t("messages.word.close"))}</button>`);
          _push(ssrRenderComponent(unref(Link), {
            href: _ctx.route("admin.prefactor.delete_discount", _ctx.prefactor.id),
            as: "button",
            method: "delete",
            class: "btn btn-danger",
            type: "button",
            "data-bs-dismiss": "modal",
            "aria-label": "Close"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(_ctx.$t("messages.word.delete"))}`);
              } else {
                return [
                  createTextVNode(toDisplayString(_ctx.$t("messages.word.delete")), 1)
                ];
              }
            }),
            _: 1
          }, _parent));
          _push(`</div></div></div></div></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<div class="checkout-row col-md-auto col-6 white-space-nowrap mb-3"><div class="checkout-row-label lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.cart_total"))}</div><div class="checkout-row-value lts-05"><span class="fs-6 fw-bold">${ssrInterpolate(unref(useNumberFormat)(_ctx.order.totalFinalPrice))}</span><span class="unit unit-sm lts-05"></span></div></div><div class="checkout-row checkout-footer col-md-auto col-6 white-space-nowrap mb-3"><div class="checkout-row-label lts-05"><span class="d-flex"><i class="ri-copper-coin-fill text-warning me-1"></i><span class="fs-7 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.customer_club_points"))}</span></span></div><div class="checkout-row-value--small lts-05"><span class="fw-bold">${ssrInterpolate(unref(useNumberFormat)(_ctx.order.customerClubScore))}</span> <span class="fs-8 text-gray">${ssrInterpolate(_ctx.$t("messages.word.score"))}</span></div></div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.order.items.length > 0) {
        _push(`<div class="d-block w-100 cart-items simplebar-container"><div class="d-block">`);
        if (_ctx.order.items.length > 0) {
          _push(`<!--[-->`);
          ssrRenderList(_ctx.order.items, (item) => {
            _push(`<div class="cart-item"><div class="cart-item--thumbnail"><a${ssrRenderAttr("href", _ctx.route("main.products.show", item.product.slug))} target="_blank"><img${ssrRenderAttr("src", item.product.get_images[0]["link"])}${ssrRenderAttr("alt", item.product.title)} loading="lazy"></a></div><div class="cart-item--detail"><h2 class="cart-item--title mb-2"><a${ssrRenderAttr("href", _ctx.route("main.products.show", item.product.slug))} target="_blank">${ssrInterpolate(item.product.title)}</a></h2>`);
            if (item.get_props.length > 0) {
              _push(`<div class="cart-item--data"><ul><!--[-->`);
              ssrRenderList(item.get_props, (prop, i) => {
                _push(`<li>`);
                if (prop.type == "color") {
                  _push(`<div class="cart-item--variant mb-2">`);
                  if (prop["value"]["image"] != null) {
                    _push(`<span class="shadow-2 color-box add-image" style="${ssrRenderStyle({ "width": "16px", "height": "16px" })}"><img${ssrRenderAttr("src", prop["value"]["image"])} alt="رنگ"></span>`);
                  } else {
                    _push(`<span class="color shadow-2" style="${ssrRenderStyle("background-color: " + prop.value["color"])}"></span>`);
                  }
                  _push(`<span class="color-name lts">${ssrInterpolate(prop.value["label"])}</span></div>`);
                } else {
                  _push(`<!--[-->`);
                  if (prop.type == "warranty") {
                    _push(`<i class="ri-shield-check-fill"></i>`);
                  } else {
                    _push(`<i class="ri-focus-line"></i>`);
                  }
                  _push(`<span>${ssrInterpolate(prop.name + ": " + prop.value)}</span><!--]-->`);
                }
                _push(`</li>`);
              });
              _push(`<!--]--></ul></div>`);
            } else {
              _push(`<!---->`);
            }
            _push(`<div class="cart-item--data mb-4"><ul><li><i class="ri-store-2-line"></i>`);
            if (item.store != null) {
              _push(`<a target="_blank" class="shop-name link lts-05"${ssrRenderAttr("href", _ctx.route("main.stores.show", item.store.uuid))}>${ssrInterpolate(item.store.name)}</a>`);
            } else {
              _push(`<a class="shop-name link lts-05" href="javascript:void(0)">${ssrInterpolate(_ctx.$page.props.appName)}</a>`);
            }
            _push(`</li><li><i class="ri-checkbox-multiple-fill"></i><span>${ssrInterpolate(_ctx.$t("messages.sentence.available_in_stock"))}</span><span class="text-secondary mx-2">|</span><i class="ri-truck-fill"></i><span>${ssrInterpolate(_ctx.$t("messages.sentence.ready_to_send"))}</span></li></ul></div><div class="cart-item--price--actions"><div class="cart-item--actions"><div class="num-block fa-num me-3"><div class="num-in"><span class="plus"></span><input${ssrRenderAttr("value", item.count)} type="text" class="in-num" name="count" autocomplete="off" readonly><span class="minus dis"></span></div></div><button class="btn btn-link btn-sm text-secondary"><i class="ri-delete-bin-5-line me-1"></i><span class="lts-05">${ssrInterpolate(_ctx.$t("messages.word.delete"))}</span></button></div><div class="cart-item--price fa-num">`);
            if (item.discount > 0) {
              _push(`<div class="cart-item--discount"><del>${ssrInterpolate(unref(useNumberFormat)(item.discount * item.count + item.price * item.count))}</del></div>`);
            } else {
              _push(`<!---->`);
            }
            _push(`<div class="cart-item--price-now"><span>${ssrInterpolate(unref(useNumberFormat)(item.price * item.count))}</span><span class="unit"></span></div></div></div></div></div>`);
          });
          _push(`<!--]-->`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.order.items.length == 0) {
        _push(`<div class="cart-empty"><div class="empty-content-icon"><img${ssrRenderAttr("src", _ctx.$page.props.appUrl + "/img/template/orders.svg")} alt=""></div><div class="empty-content-message text-center"><p>${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</p></div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.order.items.length > 0 && _ctx.prefactor.status == "awaiting_issuance") {
        _push(`<div class="action-container d-flex align-items-center justify-content-end mt-4"><button class="btn btn-primary" type="button" data-bs-toggle="modal" data-bs-target="#issuingPrefactor">${ssrInterpolate(_ctx.$t("messages.sentence.issuing_prefactor"))}</button><div class="modal fade" id="issuingPrefactor" tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><form><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.are_you_sure_isuuing_prefactor"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12 mb-4"><label for="expireDatePicker" class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.expire_date"))}</label><input${ssrRenderAttr("value", unref(issuingPrefactorForm).expired_at)} id="expireDatePicker"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.choose") + " " + _ctx.$t("messages.sentence.expire_date"))} type="text" readonly class="form-control" data-jdp></div><div class="col-12 mb-1"><span class="d-block lh-30 lts-05 alert alert-warning">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_150030"))}</span></div><div class="col-12"><span class="d-block lh-30 lts-05 alert alert-success">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_189900"))}</span></div></div></div><div class="modal-footer"><button class="btn btn-primary">${ssrInterpolate(_ctx.$t("messages.word.issuance"))}</button></div></form></div></div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Admin/Financial/Prefactors/Edit.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
