import { defineComponent, ref, watch, inject, resolveDirective, unref, mergeProps, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderAttr, ssrRenderStyle, ssrIncludeBooleanAttr, ssrRenderList, ssrRenderAttrs, ssrGetDirectiveProps } from "vue/server-renderer";
import { _ as _sfc_main$1 } from "./AdminLayout-CD07IMsK.js";
import { useForm, Head } from "@inertiajs/vue3";
import { _ as _sfc_main$2 } from "./Files-B6eiTnN6.js";
import Dropdown from "primevue/dropdown/dropdown.esm.js";
import { u as useRandomNum } from "./useRandomNum-DNNSqR7b.js";
import "toastify-js";
import "./useToastify-D_n0s7Uc.js";
import "laravel-vue-i18n";
import "simplebar";
import "resize-observer-polyfill";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "./Pagination-C1AQrLe3.js";
import "./SearchList-BZnYMQPN.js";
import "lodash/debounce.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "Edit",
  __ssrInlineRender: true,
  props: {
    story: {},
    storyTypes: {}
  },
  setup(__props) {
    const props = __props;
    const cover = ref(props.story.cover);
    const file = ref(props.story.file);
    ref(null);
    const changeVid = ref(useRandomNum(1e4, 99999));
    const timePercent = ref(0);
    const isPlaying = ref(false);
    const isMuted = ref(false);
    watch(file, (value) => {
      changeVid.value = useRandomNum(1e4, 99999);
      timePercent.value = 0;
      isPlaying.value = false;
    });
    const mediaReactive = inject("mediaData");
    watch(mediaReactive, (media) => {
      if (media.type == "story" && media.file != null) {
        file.value = media.file.url;
      }
      if (media.type == "cover" && media.file != null) {
        cover.value = media.file.url;
      }
    });
    const productUUID = ref(props.story.get_widgets.product != null ? props.story.get_widgets.product.uuid : null);
    const productWidget = ref(props.story.get_widgets.product);
    const editStoryForm = useForm({
      type: props.story.type,
      title: props.story.title,
      cover: cover.value,
      file: file.value,
      expired_at: props.story.jalali_expired_at[1],
      widgets: props.story.get_widgets
    });
    const onTypeChange = () => {
      file.value = null;
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _directive_tooltip = resolveDirective("tooltip");
      let _temp0;
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.edit_story")
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.sentence.edit_story")
      }, null, _parent));
      _push(`<div class="add-story mb-4"><div class="card"><form class="card-body p-4"><div class="row pt-0 pt-sm-3"><div class="col-md-7 col-12 mb-4"><div class="row"><div class="col-sm-12 col-12 mb-3"><label for="eaTitle" class="form-label required">${ssrInterpolate(_ctx.$t("messages.word.title"))}</label><input${ssrRenderAttr("value", unref(editStoryForm).title)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.title"))} class="form-control" id="eaTitle"></div><div class="col-sm-12 col-12 mb-4"><label for="eaTitle" class="form-label required mb-3">${ssrInterpolate(_ctx.$t("messages.sentence.cover_image"))}</label><span class="fs-9 lts-05 text-light-gray ms-3">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_457852"))}</span><div class="w-100"><button class="btn btn-light fs-8 lts-05 pe-3" type="button" data-bs-toggle="modal" data-bs-target="#mediaLibrary" data-bs-input="cover">${ssrInterpolate(_ctx.$t("messages.word.select"))} <i class="ri-add-line ms-1"></i></button></div></div><div class="col-sm-12 col-12 mb-3"><label class="form-label required">${ssrInterpolate(_ctx.$t("messages.sentence.story_type"))}</label>`);
      _push(ssrRenderComponent(unref(Dropdown), {
        onChange: onTypeChange,
        class: "pvc-dropdown flex-grow-1",
        modelValue: unref(editStoryForm).type,
        "onUpdate:modelValue": ($event) => unref(editStoryForm).type = $event,
        options: _ctx.storyTypes,
        optionLabel: "label",
        optionValue: "id",
        placeholder: _ctx.$t("messages.sentence.select_story_type")
      }, null, _parent));
      _push(`</div>`);
      if (unref(editStoryForm).type == "image") {
        _push(`<div class="col-sm-12 col-12 mb-3"><button class="btn btn-light fs-8 lts-05 pe-3" type="button" data-bs-toggle="modal" data-bs-target="#mediaLibrary" data-bs-input="story">${ssrInterpolate(_ctx.$t("messages.word.select"))} <i class="ri-add-line ms-1"></i></button></div>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(editStoryForm).type == "video") {
        _push(`<div class="col-sm-12 col-12 mb-3"><label for="eaVideoUrl" class="form-label required">${ssrInterpolate(_ctx.$t("messages.sentence.video_direct_url"))}</label><input${ssrRenderAttr("value", file.value)} type="text" placeholder="https://domain.com/video.mp4" class="form-control mb-2" id="eaVideoUrl" style="${ssrRenderStyle({ "direction": "ltr" })}"><span class="text-gray lts-05 fs-8">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_548896"))}</span></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="col-sm-12 col-12 mb-3"><label for="eaExpiredAt" class="form-label required">${ssrInterpolate(_ctx.$t("messages.sentence.expire_date"))}</label><input id="eaExpiredAt"${ssrRenderAttr("value", unref(editStoryForm).expired_at)} readonly data-jdp type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.select_date"))} class="form-control mb-2"></div><div class="col-12 mb-3"><span class="fw-bold form-label fs-7">${ssrInterpolate(_ctx.$t("messages.sentence.widgets"))} <span class="fs-9 text-gray fw-light">(${ssrInterpolate(_ctx.$t("messages.word.optional"))})</span></span></div><div class="col-sm-12 col-12 mb-3"><div class="w-100 br-15 py-2 pt-3 px-3 pb-0 add-widget-container bg-light"><div class="row"><div class="col-sm-6 col-12 mb-2"><label for="eaWidgetLinkTitle" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.title"))}</label><input${ssrRenderAttr("value", unref(editStoryForm).widgets.link.title)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.example") + ": تخفیف یلدایی")} class="form-control mb-2" id="eaWidgetLinkTitle"></div><div class="col-sm-6 col-12 mb-2"><label for="eaWidgetLinkUrl" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.link"))}</label><input${ssrRenderAttr("value", unref(editStoryForm).widgets.link.url)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.example") + ": https://domain.com/example")} class="form-control mb-2" id="eaWidgetLinkUrl" style="${ssrRenderStyle({ "direction": "ltr" })}"></div></div></div></div><div class="col-sm-12 col-12"><div class="w-100 br-15 py-2 pt-3 px-3 add-widget-container bg-light"><div class="row"><div class="col-sm-12 col-12"><label for="eaWidgetProduct" class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.add_product"))} <span class="fs-9 text-gray fw-light">(${ssrInterpolate(_ctx.$t("messages.sentence.product_uuid"))})</span></label><div class="d-flex align-items-center mb-2"><input${ssrRenderAttr("value", productUUID.value)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.example") + ": p-1234567")} class="form-control" id="eaWidgetProduct" style="${ssrRenderStyle({ "direction": "ltr" })}"><button class="btn btn-dark ms-1 btn-square" type="button"><i class="ri-search-2-line"></i></button></div></div></div></div></div></div></div><div class="col-md-5 col-12 d-flex flex-column align-items-center justify-content-start"><div class="story-container mb-4">`);
      if (unref(editStoryForm).type == "image" && file.value != null) {
        _push(`<img${ssrRenderAttr("src", file.value)}>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(editStoryForm).type == "video" && file.value != null && file.value != "") {
        _push(`<video${ssrIncludeBooleanAttr(isMuted.value) ? " muted" : ""} autoplay class="video"><source${ssrRenderAttr("src", file.value)} type="video/mp4"></video>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="top-shadow-black"></div><div class="bottom-shadow-black"></div><div class="story-timeline">`);
      if (file.value != null) {
        _push(`<span class="inner" style="${ssrRenderStyle({ width: timePercent.value + "%" })}"></span>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div><div class="story-header d-flex align-items-center justify-content-between"><div class="right d-flex align-items-center"><div class="cover">`);
      if (cover.value != null) {
        _push(`<img${ssrRenderAttr("src", cover.value)}>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div><span class="title text-white ms-2 fs-9 lts-05 fw-light lh-15">${ssrInterpolate(unref(editStoryForm).title)}</span><span class="text-white ms-2 fs-11 fw-light lh-15 white-space-nowrap">10 دقیقه قبل</span></div><ul class="left">`);
      if (file.value != null && file.value != "" && unref(editStoryForm).type == "video") {
        _push(`<li>`);
        if (isPlaying.value) {
          _push(`<i class="ri-pause-mini-line"></i>`);
        } else {
          _push(`<!---->`);
        }
        if (!isPlaying.value) {
          _push(`<i class="ri-play-fill"></i>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</li>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</ul></div>`);
      if (file.value != null && file.value != "") {
        _push(`<ul class="story-meta" style="${ssrRenderStyle({ bottom: productWidget.value != null ? "15%" : "8%" })}"><li><i class="ri-heart-line"></i><span>${ssrInterpolate(_ctx.story.like)}</span></li>`);
        if (unref(editStoryForm).type == "video") {
          _push(`<li class="mute-icon">`);
          if (!isMuted.value) {
            _push(`<i class="ri-volume-up-line" style="${ssrRenderStyle({ "font-size": "20px" })}"></i>`);
          } else {
            _push(`<!---->`);
          }
          if (isMuted.value) {
            _push(`<i class="ri-volume-mute-line" style="${ssrRenderStyle({ "font-size": "20px" })}"></i>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</li>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</ul>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(editStoryForm).widgets.link.title != null && unref(editStoryForm).widgets.link.title != "" && unref(editStoryForm).widgets.link.url != null && unref(editStoryForm).widgets.link.url != "") {
        _push(`<span class="story-link lts-05 shadow-smooth-1" style="${ssrRenderStyle({ bottom: productWidget.value != null ? "15%" : "8%" })}">${ssrInterpolate(unref(editStoryForm).widgets.link.title)} <i class="ri-link-m"></i></span>`);
      } else {
        _push(`<!---->`);
      }
      if (productWidget.value != null) {
        _push(`<div class="story-product card"><div class="card-body d-flex align-items-center"><div class="image"><img${ssrRenderAttr("src", productWidget.value.get_images[0]["link"])}${ssrRenderAttr("alt", productWidget.value.title)}></div><div class="meta d-flex align-items-center flex-column"><div class="title clickable lts-05">${ssrInterpolate(productWidget.value.title)}</div>`);
        if (productWidget.value.in_stock_status && productWidget.value.inventory && productWidget.value.best_normal_price.discount_price != null) {
          _push(`<div class="discount-percent bg-secondary shadow-secondary shadow-1 me-2">${ssrInterpolate(productWidget.value.best_normal_price.percent)}<i class="ri-percent-fill"></i></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<div class="w-100 d-flex align-items-center justify-content-between"><ul class="product-colors"><!--[-->`);
        ssrRenderList(productWidget.value.unique_color, (color, index) => {
          _push(`<li${ssrRenderAttrs(_temp0 = mergeProps({
            key: index,
            style: "background-color:" + color.value.color + (color.value.color == "#ffffff" ? "; border: solid 1px #ddd" : ""),
            class: { "color-is-white": color.value.color == "#ffffff" }
          }, ssrGetDirectiveProps(_ctx, _directive_tooltip, color.value.label, void 0, { top: true })))}>${"textContent" in _temp0 ? ssrInterpolate(_temp0.textContent) : _temp0.innerHTML ?? ""}</li>`);
        });
        _push(`<!--]--></ul><div class="d-inline-flex align-items-center"><span class="product-rating-average fs-9 lh-15"><i class="ri-star-fill"></i><span class="fw-bold">${ssrInterpolate(productWidget.value.comments_info.rating == "0" ? "-" : productWidget.value.comments_info.rating)}</span></span>`);
        if (!productWidget.value.in_stock_status) {
          _push(`<div class="d-flex flex-column justify-content-end"><span class="product-price-now fw-bold lts-05 fs-8">${ssrInterpolate(_ctx.$t("messages.sentence.inventory_inquiry"))}</span></div>`);
        } else if (productWidget.value.inventory) {
          _push(`<!--[-->`);
          if (productWidget.value.best_normal_price.discount_price != null) {
            _push(`<div class="d-flex flex-column justify-content-end"><span class="product-price-now fw-bold lts-05">${ssrInterpolate(productWidget.value.best_normal_price.discount_price)} <span class="unit unit-sm"></span></span></div>`);
          } else {
            _push(`<div class="d-flex flex-column justify-content-end"><span class="product-price-now fw-bold lts-05">${ssrInterpolate(productWidget.value.best_normal_price.price)} <span class="unit unit-sm"></span></span></div>`);
          }
          _push(`<!--]-->`);
        } else {
          _push(`<div class="d-flex flex-column justify-content-end"><span class="product-price-now fw-bold lts-05 fs-8">${ssrInterpolate(_ctx.$t("messages.word.non_existent"))}</span></div>`);
        }
        _push(`</div></div></div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div><span class="fs-9 text-light-gray lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_124452"))}</span></div></div><div class="row mt-4"><div class="col-12 d-flex align-items-center justify-content-start"><button${ssrIncludeBooleanAttr(unref(editStoryForm).processing) ? " disabled" : ""} type="submit" class="btn btn-primary">${ssrInterpolate(_ctx.$t("messages.word.edit"))} `);
      if (unref(editStoryForm).processing) {
        _push(`<i class="ri-refresh-line i-spin"></i>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</button></div></div></form></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Admin/Stories/Edit.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
