import { defineComponent, ref, unref, withCtx, createTextVNode, toDisplayString, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderAttr, ssrIncludeBooleanAttr } from "vue/server-renderer";
import "toastify-js";
import "./useToastify-D_n0s7Uc.js";
import { _ as _sfc_main$1 } from "./MainLayout-CahYFWjG.js";
import { useForm, Head, Link } from "@inertiajs/vue3";
import "laravel-vue-i18n";
import Dropdown from "primevue/dropdown/dropdown.esm.js";
/* empty css                       */
/* empty css                              */
/* empty css                           */
/* empty css             */
import "simplebar";
import "resize-observer-polyfill";
import "./AdminNavigation-BYBoZNuA.js";
import "./useHexToRgb-G7J9N7Ap.js";
import "./useRandomStr-4MeWbtRd.js";
import "jquery";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "Edit",
  __ssrInlineRender: true,
  props: {
    user: {},
    genderList: {}
  },
  setup(__props) {
    const props = __props;
    ref();
    ref();
    const imageUrl = ref(props.user.get_avatar);
    ref();
    const editProfileForm = useForm({
      avatar: null,
      name: props.user.name,
      username: props.user.username,
      email: props.user.email,
      national_number: props.user.national_number,
      birthday: props.user.jalali_birthday != null ? props.user.jalali_birthday[1] : null,
      gender: props.user.gender,
      bio: props.user.bio,
      social: {
        instagram: props.user.get_social.instagram,
        telegram: props.user.get_social.telegram,
        twitter: props.user.get_social.twitter,
        facebook: props.user.get_social.facebook
      }
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.edit_profile")
      }, null, _parent));
      _push(`<div class="card shadow-1 panel-content"><div class="card-body"><div class="panel-content--title mb-4 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.edit_account_information"))}</div><form class="row edit-account-form"><div class="col-12 avatar-container d-flex align-items-center mb-5"><img${ssrRenderAttr("src", imageUrl.value)} class="shadow-1"${ssrRenderAttr("alt", _ctx.user.get_name)}><input id="eaProfileInput" type="file" name="avatar" accept=".png,.jpg"><div class="edit-link"><label for="eaProfileInput" class="change-input-label btn btn-light mb-3 fs-8 shadow-1 lts-05"><i class="ri-pencil-line"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.change_profile"))}</label><div class="image-information">(${ssrInterpolate(_ctx.$t("messages.sentence.profile_hint"))})</div></div></div><div class="col-sm-6 col-12 mb-4"><label for="eaFullname" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.full_name"))}</label><input${ssrRenderAttr("value", unref(editProfileForm).name)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.full_name"))} required class="form-control" id="eaFullname"></div><div class="col-sm-6 col-12 mb-4"><label for="eaUsername" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.username"))}</label><input${ssrRenderAttr("value", unref(editProfileForm).username)} minlength="4" maxlength="20" type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.username"))} required class="form-control mb-1" id="eaUsername"><span class="desc">${ssrInterpolate(_ctx.$t("messages.sentence.username_hint"))}</span></div><div class="col-sm-6 col-12 mb-4"><label for="eaPhone" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.phone"))}</label><input${ssrRenderAttr("value", _ctx.user.phone)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.phone"))} class="form-control" id="eaPhone" minlength="11" maxlength="11" autocomplete="phone" disabled></div><div class="col-sm-6 col-12 mb-4"><label for="eaEmail" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.email"))} <template>`);
      if (_ctx.user.email != null && _ctx.user.email_verified_at == null) {
        _push(`<span class="unverified_badge lts-05">`);
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("verification.send"),
          method: "post",
          as: "button"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("messages.sentence.send_verify_link"))}`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("messages.sentence.send_verify_link")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</span>`);
      } else if (_ctx.user.email != null && _ctx.user.email_verified_at != null) {
        _push(`<span class="verified_badge lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.verified"))}</span>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</template></label><input${ssrRenderAttr("value", unref(editProfileForm).email)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.email"))} class="form-control" id="eaEmail"${ssrIncludeBooleanAttr(_ctx.user.email != null && _ctx.user.email_verified_at != null) ? " disabled" : ""}></div><div class="col-sm-4 col-12 mb-4"><label for="eaNationalCode" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.national_number"))}</label><input${ssrRenderAttr("value", unref(editProfileForm).national_number)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.national_number"))} class="form-control" maxlength="10" id="eaNationalCode"></div><div class="col-sm-4 col-12 mb-4"><label for="birthdayPicker" class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.birthday_date"))}</label><input${ssrRenderAttr("value", unref(editProfileForm).birthday)} id="birthdayPicker"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.birthday_date"))} type="text" readonly class="form-control" data-jdp></div><div class="col-sm-4 col-12 mb-4"><label class="form-label">${ssrInterpolate(_ctx.$t("messages.word.gender"))}</label>`);
      _push(ssrRenderComponent(unref(Dropdown), {
        modelValue: unref(editProfileForm).gender,
        "onUpdate:modelValue": ($event) => unref(editProfileForm).gender = $event,
        options: _ctx.genderList,
        optionLabel: "label",
        optionValue: "id",
        placeholder: _ctx.$t("messages.sentence.choose_gender"),
        type: "text",
        readonly: "",
        class: "pvc-dropdown"
      }, null, _parent));
      _push(`</div><div class="col-12 mb-4"><label for="eaBiography" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.biography"))}</label><textarea class="form-control lh-30" rows="5" name="biography"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.biography_summary"))} id="eaBiography">${ssrInterpolate(unref(editProfileForm).bio)}</textarea></div><div class="col-12 mb-4"><div class="border"></div></div><div class="col-12 mb-4"><span class="fw-bold d-flex fs-6 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.personal_socials"))}</span></div><div class="col-sm-6 col-12 mb-4"><label for="eaInstagram" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.instagram"))}</label><input${ssrRenderAttr("value", unref(editProfileForm).social.instagram)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.instagram"))} class="form-control" id="eaInstagram"></div><div class="col-sm-6 col-12 mb-4"><label for="eaTelegram" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.telegram"))}</label><input${ssrRenderAttr("value", unref(editProfileForm).social.telegram)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.telegram"))} class="form-control" id="eaTelegram"></div><div class="col-sm-6 col-12 mb-4"><label for="eaTwitter" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.twitter"))}</label><input${ssrRenderAttr("value", unref(editProfileForm).social.twitter)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.twitter"))} class="form-control" id="eaTwitter"></div><div class="col-sm-6 col-12 mb-5"><label for="eaFacebook" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.facebook"))}</label><input${ssrRenderAttr("value", unref(editProfileForm).social.facebook)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.facebook"))} class="form-control" id="eaFacebook"></div><div class="col-12 d-flex align-items-center justify-content-end mb-2">`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("user.dashboard"),
        type: "button",
        class: "btn btn-light lts-05 shadow-1 me-3"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("messages.word.cancel"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("messages.word.cancel")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`<button type="submit"${ssrIncludeBooleanAttr(unref(editProfileForm).processing) ? " disabled" : ""} class="btn btn-primary lts-05 shadow-1">${ssrInterpolate(_ctx.$t("messages.sentence.save_changes"))}</button></div></form></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/User/Account/Edit.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
