import { defineComponent, onMounted, ref, watch, reactive, unref, withCtx, createVNode, createTextVNode, toDisplayString, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderStyle, ssrRenderAttr, ssrRenderList } from "vue/server-renderer";
import { _ as _sfc_main$1 } from "./AdminLayout-CD07IMsK.js";
import Sortable from "sortablejs";
import { router, useForm, Head, Link } from "@inertiajs/vue3";
import Dropdown from "primevue/dropdown/dropdown.esm.js";
import "toastify-js";
import "./useToastify-D_n0s7Uc.js";
import "laravel-vue-i18n";
import { _ as _sfc_main$2 } from "./Files-B6eiTnN6.js";
import "simplebar";
import "resize-observer-polyfill";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "./Pagination-C1AQrLe3.js";
import "./SearchList-BZnYMQPN.js";
import "lodash/debounce.js";
import "./useRandomNum-DNNSqR7b.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "Edit",
  __ssrInlineRender: true,
  props: {
    menus: {},
    menu: {},
    staticLinks: {},
    categories: {},
    pages: {},
    forms: {},
    menuPlaceList: {}
  },
  setup(__props) {
    const props = __props;
    onMounted(() => {
      if ($("#accordionMenu").length) {
        Sortable.create(document.getElementById("accordionMenu"), {
          animation: 150
        });
      }
    });
    const menuForEdit = ref(props.menu.id);
    watch(menuForEdit, (value) => {
      router.get(route("admin.menus.edit", value));
    });
    const menuList = ref([]);
    for (let menu in props.menus) {
      menuList.value.push({ id: props.menus[menu].id, label: props.menus[menu].name });
    }
    const createMenuForm = useForm({
      name: null,
      place: null
    });
    const staticLinkList = ref([]);
    for (let staticLink in props.staticLinks) {
      staticLinkList.value.push({
        id: { name: props.staticLinks[staticLink].name, link: props.staticLinks[staticLink].link, type: props.staticLinks[staticLink].type },
        name: props.staticLinks[staticLink].name,
        link: props.staticLinks[staticLink].link,
        type: props.staticLinks[staticLink].type
      });
    }
    const categories = ref([]);
    for (let category in props.categories) {
      categories.value.push({
        id: { name: props.categories[category].name, link: props.categories[category].link, type: props.categories[category].type },
        name: props.categories[category].name,
        link: props.categories[category].link,
        type: props.categories[category].type
      });
    }
    const pages = ref([]);
    for (let page in props.pages) {
      pages.value.push({
        id: { name: props.pages[page].name, link: props.pages[page].link, type: props.pages[page].type },
        name: props.pages[page].name,
        link: props.pages[page].link,
        type: props.pages[page].type
      });
    }
    const forms = ref([]);
    for (let form in props.forms) {
      forms.value.push({
        id: { name: props.forms[form].name, link: props.forms[form].link, type: props.forms[form].type },
        name: props.forms[form].name,
        link: props.forms[form].link,
        type: props.forms[form].type
      });
    }
    const menuItems = reactive(props.menu.content);
    const menuName = ref("");
    const menuLink = ref("");
    const dropdownItemForAdd = ref("");
    const updateMenuForm = useForm({
      name: props.menu.name,
      items: props.menu.content,
      place: props.menu.place
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.menus")
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.word.menus")
      }, null, _parent));
      _push(`<div class="menu-container row mb-4"><div class="col-12 mb-4"><div class="card"><div class="card-body menu-action-container d-flex align-items-center justify-content-between"><div class="edit-menu d-flex align-items-center">`);
      _push(ssrRenderComponent(unref(Dropdown), {
        class: "pvc-dropdown",
        modelValue: menuForEdit.value,
        "onUpdate:modelValue": ($event) => menuForEdit.value = $event,
        options: menuList.value,
        display: "chip",
        optionLabel: "label",
        optionValue: "id",
        placeholder: _ctx.$t("messages.sentence.select_menu_to_edit")
      }, null, _parent));
      _push(ssrRenderComponent(unref(Link), {
        as: "button",
        disabled: menuForEdit.value == 0 || menuForEdit.value == _ctx.menu.id,
        href: _ctx.route("admin.menus.edit", menuForEdit.value),
        class: "btn btn-dark btn-square shadow-1 ms-2 lts-05"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<i class="ri-pencil-fill"${_scopeId}></i>`);
          } else {
            return [
              createVNode("i", { class: "ri-pencil-fill" })
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div><button class="create-menu btn btn-primary shadow-1 lts-05" data-bs-toggle="modal" data-bs-target="#addMenu">${ssrInterpolate(_ctx.$t("messages.sentence.create_new_menu"))} <i class="ri-add-line"></i></button><div class="modal fade" id="addMenu" tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><form style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.create_new_menu"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12 mb-4"><label for="eaMenuTitle" class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.menu_title"))}</label><input${ssrRenderAttr("value", unref(createMenuForm).name)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.menu_title"))} class="form-control" id="eaMenuTitle"></div><div class="col-12 mb-4"><label class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.menu_place"))}</label>`);
      _push(ssrRenderComponent(unref(Dropdown), {
        class: "pvc-dropdown",
        modelValue: unref(createMenuForm).place,
        "onUpdate:modelValue": ($event) => unref(createMenuForm).place = $event,
        options: _ctx.menuPlaceList,
        display: "chip",
        optionLabel: "label",
        optionValue: "id",
        placeholder: _ctx.$t("messages.sentence.select_menu_place")
      }, null, _parent));
      _push(`</div></div></div><div class="modal-footer"><button class="btn btn-sm btn-primary px-3" data-bs-dismiss="modal">${ssrInterpolate(_ctx.$t("messages.sentence.create_menu"))}</button></div></form></div></div></div></div></div></div>`);
      if (menuForEdit.value == _ctx.menu.id) {
        _push(`<div class="col-md-4 col-12 mb-3"><div class="accordion" id="accordionAddMenu"><div class="accordion-item"><h2 class="accordion-header"><button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">منوی دلخواه</button></h2><div id="collapseOne" class="accordion-collapse collapse show" data-bs-parent="#accordionAddMenu"><div class="accordion-body"><div class="row"><div class="col-12 mb-4"><label for="eaCustomMenuTitle" class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.menu_title"))}</label><input${ssrRenderAttr("value", menuName.value)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.menu_title"))} class="form-control" id="eaCustomMenuTitle"></div><div class="col-12 mb-4"><label for="eaCustomMenuLink" class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.menu_link"))}</label><input${ssrRenderAttr("value", menuLink.value)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.menu_link"))} class="form-control" id="eaCustomMenuLink"></div><div class="col-12 mb-2"><button class="btn btn-sm btn-primary px-3">${ssrInterpolate(_ctx.$t("messages.sentence.add_menu"))}</button></div></div></div></div></div><div class="accordion-item"><h2 class="accordion-header"><button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">${ssrInterpolate(_ctx.$t("messages.sentence.static_addresses"))}</button></h2><div id="collapseTwo" class="accordion-collapse collapse" data-bs-parent="#accordionAddMenu"><div class="accordion-body"><div class="row"><div class="col-12 mb-4"><label class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.select_address"))}</label>`);
        _push(ssrRenderComponent(unref(Dropdown), {
          class: "pvc-dropdown",
          modelValue: dropdownItemForAdd.value,
          "onUpdate:modelValue": ($event) => dropdownItemForAdd.value = $event,
          options: staticLinkList.value,
          optionLabel: "name",
          optionValue: "id",
          placeholder: _ctx.$t("messages.sentence.select_address")
        }, null, _parent));
        _push(`</div><div class="col-12 mb-2"><button class="btn btn-sm btn-primary px-3">${ssrInterpolate(_ctx.$t("messages.sentence.add_menu"))}</button></div></div></div></div></div><div class="accordion-item"><h2 class="accordion-header"><button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">${ssrInterpolate(_ctx.$t("messages.sentence.product_categories"))}</button></h2><div id="collapseThree" class="accordion-collapse collapse" data-bs-parent="#accordionAddMenu"><div class="accordion-body"><div class="row"><div class="col-12 mb-4"><label class="form-label">${ssrInterpolate(_ctx.$t("messages.word.categories"))}</label>`);
        _push(ssrRenderComponent(unref(Dropdown), {
          class: "pvc-dropdown",
          modelValue: dropdownItemForAdd.value,
          "onUpdate:modelValue": ($event) => dropdownItemForAdd.value = $event,
          options: categories.value,
          optionLabel: "name",
          optionValue: "id",
          placeholder: _ctx.$t("messages.sentence.select_category")
        }, null, _parent));
        _push(`</div><div class="col-12 mb-2"><button class="btn btn-sm btn-primary px-3">${ssrInterpolate(_ctx.$t("messages.sentence.add_menu"))}</button></div></div></div></div></div><div class="accordion-item"><h2 class="accordion-header"><button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseFour" aria-expanded="false" aria-controls="collapseFour">${ssrInterpolate(_ctx.$t("messages.word.pages"))}</button></h2><div id="collapseFour" class="accordion-collapse collapse" data-bs-parent="#accordionAddMenu"><div class="accordion-body"><div class="row"><div class="col-12 mb-4"><label class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.page_list"))}</label>`);
        _push(ssrRenderComponent(unref(Dropdown), {
          class: "pvc-dropdown pages-dropdown",
          modelValue: dropdownItemForAdd.value,
          "onUpdate:modelValue": ($event) => dropdownItemForAdd.value = $event,
          options: pages.value,
          optionLabel: "name",
          optionValue: "id",
          placeholder: _ctx.$t("messages.sentence.select_page")
        }, null, _parent));
        _push(`</div><div class="col-12 mb-2"><button class="btn btn-sm btn-primary px-3">${ssrInterpolate(_ctx.$t("messages.sentence.add_menu"))}</button></div></div></div></div></div><div class="accordion-item"><h2 class="accordion-header"><button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseFive" aria-expanded="false" aria-controls="collapseFive">${ssrInterpolate(_ctx.$t("messages.word.forms"))}</button></h2><div id="collapseFive" class="accordion-collapse collapse" data-bs-parent="#accordionAddMenu"><div class="accordion-body"><div class="row"><div class="col-12 mb-4"><label class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.form_list"))}</label>`);
        _push(ssrRenderComponent(unref(Dropdown), {
          class: "pvc-dropdown pages-dropdown",
          modelValue: dropdownItemForAdd.value,
          "onUpdate:modelValue": ($event) => dropdownItemForAdd.value = $event,
          options: forms.value,
          optionLabel: "name",
          optionValue: "id",
          placeholder: _ctx.$t("messages.sentence.select_form")
        }, null, _parent));
        _push(`</div><div class="col-12 mb-2"><button class="btn btn-sm btn-primary px-3">${ssrInterpolate(_ctx.$t("messages.sentence.add_menu"))}</button></div></div></div></div></div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (menuForEdit.value == _ctx.menu.id) {
        _push(`<div class="col-md-8 col-12 mb-3"><form class="card menu-section"><div class="card-body"><div class="row"><div class="col-12 d-flex align-items-center mb-4"><label for="eaEditMenuTitle" class="form-label edit-menu-title mb-0 me-3">${ssrInterpolate(_ctx.$t("messages.sentence.menu_title"))}</label><input type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.menu_title"))} class="form-control" id="eaEditMenuTitle"${ssrRenderAttr("value", unref(updateMenuForm).name)}><button class="btn btn-square btn-danger ms-2" type="button" data-bs-toggle="modal" data-bs-target="#removeMenu"><i class="ri-delete-bin-5-line"></i></button><div class="modal fade" id="removeMenu" tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><div style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.are_you_sure_delete_menu"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-footer">`);
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("admin.menus.destroy", _ctx.menu.id),
          method: "delete",
          as: "button",
          "data-bs-dismiss": "modal",
          class: "btn btn-sm btn-danger px-3"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("messages.word.delete"))}`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("messages.word.delete")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</div></div></div></div></div></div><div class="col-12 mb-4"><div class="accordion" id="accordionMenu"><!--[-->`);
        ssrRenderList(menuItems, (menuItem, index) => {
          _push(`<div${ssrRenderAttr("index", index)} class="accordion-item"><h2 class="accordion-header"><button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"${ssrRenderAttr("data-bs-target", "#collapse-menu-" + index)} aria-expanded="false"${ssrRenderAttr("aria-controls", "collapse-menu-" + index)}><i class="ri-draggable me-2"></i> ${ssrInterpolate(menuItem.name)}</button></h2><div${ssrRenderAttr("id", "collapse-menu-" + index)} class="accordion-collapse collapse" data-bs-parent="#accordionMenu"><div class="accordion-body"><div class="row"><div class="col-12 mb-3"><label class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.menu_title"))} <input${ssrRenderAttr("value", menuItem.name)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.menu_title"))} class="form-control"></label></div><div class="col-12 mb-2"><label class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.menu_link"))} <input${ssrRenderAttr("value", menuItem.link)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.menu_link"))} class="form-control"></label></div><div class="col-12 d-flex align-items-center justify-content-end mb-2"><button class="btn btn-sm btn-danger px-3">${ssrInterpolate(_ctx.$t("messages.word.delete"))}</button></div></div></div></div></div>`);
        });
        _push(`<!--]-->`);
        if (menuItems.length == 0) {
          _push(`<div class="empty-item lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.no_items_have_been_added_yet"))}</div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div></div><div class="col-12 mb-4"><label class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.menu_place"))}</label>`);
        _push(ssrRenderComponent(unref(Dropdown), {
          class: "pvc-dropdown",
          modelValue: unref(updateMenuForm).place,
          "onUpdate:modelValue": ($event) => unref(updateMenuForm).place = $event,
          options: _ctx.menuPlaceList,
          display: "chip",
          optionLabel: "label",
          optionValue: "id",
          placeholder: _ctx.$t("messages.sentence.select_menu_place")
        }, null, _parent));
        _push(`</div><div class="col-12 mb-1"><span class="input-desc"><span class="fw-bold text-danger">${ssrInterpolate(_ctx.$t("messages.word.warning"))}:</span> ${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_748523"))}</span></div><div class="col-12 d-flex align-items-center justify-content-end mb-2"><button class="btn btn-sm btn-primary px-3">${ssrInterpolate(_ctx.$t("messages.sentence.save_changes"))}</button></div></div></div></form></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Admin/Menu/Edit.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
