import { defineComponent, reactive, unref, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderAttr, ssrIncludeBooleanAttr, ssrRenderList } from "vue/server-renderer";
import { _ as _sfc_main$1 } from "./AdminLayout-CD07IMsK.js";
import { useForm, Head } from "@inertiajs/vue3";
import Dropdown from "primevue/dropdown/dropdown.esm.js";
import { _ as _sfc_main$4 } from "./Tagify-DYepU4nx.js";
import { _ as _sfc_main$2 } from "./Files-B6eiTnN6.js";
import { _ as _sfc_main$3 } from "./Ckeditor-BEPE8WxA.js";
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
import "@yaireo/tagify";
import "./useRandomStr-4MeWbtRd.js";
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "laravel-vue-i18n";
import "./Pagination-C1AQrLe3.js";
import "./SearchList-BZnYMQPN.js";
import "lodash/debounce.js";
import "./useRandomNum-DNNSqR7b.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "Edit",
  __ssrInlineRender: true,
  props: {
    form: {},
    statusList: {},
    formTypeList: {},
    formPriorityList: {}
  },
  setup(__props) {
    const props = __props;
    const fields = reactive(props.form.get_fields);
    const editFormForm = useForm({
      title: props.form.title,
      slug: props.form.slug,
      description: props.form.description,
      fields,
      seo_title: props.form.seo_title,
      seo_description: props.form.seo_description,
      seo_keywords: props.form.seo_keywords,
      seo_canonical: props.form.seo_canonical,
      status: props.form.status
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.edit_form")
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.sentence.edit_form")
      }, null, _parent));
      _push(`<div class="add-product row mb-4"><div class="col-12"><form><div class="card mb-4"><div class="card-body"><div class="pills-tab-container d-flex align-items-start"><div class="action-sidebar"><div class="nav flex-column nav-pills mb-md-4 mb-5" id="v-pills-tab" role="tablist" aria-orientation="vertical"><button class="nav-link active" id="v-pills-main-tab" data-bs-toggle="pill" data-bs-target="#v-pills-main" type="button" role="tab" aria-controls="v-pills-main" aria-selected="true"><i class="ri-keyboard-box-line"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.main_information"))}</button><button class="nav-link" id="v-pills-seo-tab" data-bs-toggle="pill" data-bs-target="#v-pills-seo" type="button" role="tab" aria-controls="v-pills-seo" aria-selected="false"><i class="ri-seo-line"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.seo_settings"))}</button></div><div class="action-container d-md-block d-none mb-4"><label for="eaProductStatus" class="form-label lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.form_status"))}: </label>`);
      _push(ssrRenderComponent(unref(Dropdown), {
        class: "pvc-dropdown",
        modelValue: unref(editFormForm).status,
        "onUpdate:modelValue": ($event) => unref(editFormForm).status = $event,
        options: _ctx.statusList,
        display: "chip",
        optionLabel: "label",
        optionValue: "id",
        placeholder: _ctx.$t("messages.sentence.select_status")
      }, null, _parent));
      _push(`<button${ssrIncludeBooleanAttr(unref(editFormForm).processing) ? " disabled" : ""} class="btn btn-primary mt-3">${ssrInterpolate(_ctx.$t("messages.sentence.edit_form"))}</button></div></div><div class="tab-content" id="v-pills-tabContent"><div class="tab-pane fade show active" id="v-pills-main" role="tabpanel" aria-labelledby="v-pills-main-tab" tabindex="0"><div class="row"><div class="col-sm-6 col-12 mb-4"><label for="eaTitle" class="form-label required">${ssrInterpolate(_ctx.$t("messages.sentence.form_title"))}</label><input${ssrRenderAttr("value", unref(editFormForm).title)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.form_title"))} class="form-control" id="eaTitle"></div><div class="col-sm-6 col-12 mb-4"><label for="eaEnSlug" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.slug"))}</label><input${ssrIncludeBooleanAttr(_ctx.form.flag == "system") ? " disabled" : ""}${ssrRenderAttr("value", unref(editFormForm).slug)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.better_to_leave_it_blank_and_create_it_automatically"))} class="form-control" id="eaEnSlug"></div><div class="col-12 mb-4"><label id="eaFromDescription" class="form-label mb-2 lts-05">${ssrInterpolate(_ctx.$t("messages.word.description"))}</label>`);
      _push(ssrRenderComponent(_sfc_main$3, {
        modelValue: unref(editFormForm).description,
        "onUpdate:modelValue": ($event) => unref(editFormForm).description = $event
      }, null, _parent));
      _push(`</div><div class="col-12"><label class="form-label mb-3">${ssrInterpolate(_ctx.$t("messages.sentence.form_fields"))}</label><div id="form-item-container" class="item-container"><!--[-->`);
      ssrRenderList(fields, (field, index) => {
        _push(`<div class="item br-15 mb-3"><div class="row"><div class="col-12"><i class="remove-item ri-close-line"></i></div><div class="col-12 mb-2"><input${ssrRenderAttr("value", field.title)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.form_name_example_email"))} class="form-control"></div><div class="col-sm-6 col-12 mb-2">`);
        _push(ssrRenderComponent(unref(Dropdown), {
          class: "pvc-dropdown",
          modelValue: field.type,
          "onUpdate:modelValue": ($event) => field.type = $event,
          options: _ctx.formTypeList,
          display: "chip",
          optionLabel: "label",
          optionValue: "id",
          placeholder: _ctx.$t("messages.sentence.select_field_type")
        }, null, _parent));
        _push(`</div><div class="col-sm-6 col-12 mb-2">`);
        _push(ssrRenderComponent(unref(Dropdown), {
          class: "pvc-dropdown",
          modelValue: field.status,
          "onUpdate:modelValue": ($event) => field.status = $event,
          options: _ctx.formPriorityList,
          display: "chip",
          optionLabel: "label",
          optionValue: "id",
          placeholder: _ctx.$t("messages.sentence.select_field_status")
        }, null, _parent));
        _push(`</div></div></div>`);
      });
      _push(`<!--]--></div><button type="button" class="btn btn-xs btn-square btn-primary"><i class="ri-add-line"></i></button></div></div></div><div class="tab-pane fade" id="v-pills-seo" role="tabpanel" aria-labelledby="v-pills-seo-tab" tabindex="0"><div class="row"><div class="col-sm-6 col-12 mb-4"><label for="eaSeoTitle" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.title") + " " + _ctx.$t("messages.word.seo"))}</label><input${ssrRenderAttr("value", unref(editFormForm).seo_title)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.title_for_seo"))} class="form-control" id="eaSeoTitle"></div><div class="col-sm-6 col-12 mb-4"><label for="eaSeoKeywords" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.keywords"))}</label>`);
      _push(ssrRenderComponent(_sfc_main$4, {
        modelValue: unref(editFormForm).seo_keywords,
        "onUpdate:modelValue": ($event) => unref(editFormForm).seo_keywords = $event
      }, null, _parent));
      _push(`</div><div class="col-12 mb-4"><label for="eaDescription" class="form-label lts-05">${ssrInterpolate(_ctx.$t("messages.word.description") + " " + _ctx.$t("messages.word.seo"))}</label><textarea${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.briefly_describe_the_content_in_two_lines"))} class="form-control" id="eaDescription">${ssrInterpolate(unref(editFormForm).seo_description)}</textarea></div><div class="col-12 mb-5"><label for="eaCanonical" class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.canonical_tag"))}</label><input${ssrRenderAttr("value", unref(editFormForm).seo_canonical)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.enter_link_optional"))} class="form-control" id="eaCanonical"></div><div class="col-sm-6 col-12 mb-4"><div class="checkbox-container"><i class="ri-check-line"></i><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.create_snippet_for_google"))}</span><span class="flag"> (${ssrInterpolate(_ctx.$t("messages.sentence.create_automatically"))}) </span></div></div><div class="col-sm-6 col-12 mb-4"><div class="checkbox-container"><i class="ri-check-line"></i><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.create_preview_for_socials"))}</span><span class="flag"> (${ssrInterpolate(_ctx.$t("messages.sentence.create_automatically"))}) </span></div></div><div class="col-sm-6 col-12 mb-4"><div class="checkbox-container"><i class="ri-check-line"></i><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.add_to_sitemap"))}</span><span class="flag"> (${ssrInterpolate(_ctx.$t("messages.sentence.create_automatically"))}) </span></div></div><div class="col-sm-6 col-12 mb-4"><div class="checkbox-container"><i class="ri-check-line"></i><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.create_meta_tags"))}</span><span class="flag"> (${ssrInterpolate(_ctx.$t("messages.sentence.create_automatically"))}) </span></div></div></div></div></div></div><div class="action-container d-md-none d-block mt-4"><label for="eaProductStatus" class="form-label lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.form_status"))}: </label>`);
      _push(ssrRenderComponent(unref(Dropdown), {
        class: "pvc-dropdown",
        modelValue: unref(editFormForm).status,
        "onUpdate:modelValue": ($event) => unref(editFormForm).status = $event,
        options: _ctx.statusList,
        display: "chip",
        optionLabel: "label",
        optionValue: "id",
        placeholder: _ctx.$t("messages.sentence.select_status")
      }, null, _parent));
      _push(`<button${ssrIncludeBooleanAttr(unref(editFormForm).processing) ? " disabled" : ""} class="btn btn-primary mt-3">${ssrInterpolate(_ctx.$t("messages.sentence.edit_form"))}</button></div></div></div></form></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Admin/Forms/Edit.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
