import { defineComponent, inject, watch, unref, withCtx, createTextVNode, toDisplayString, useSSRContext } from "vue";
import { ssrRenderComponent, ssrRenderAttr, ssrInterpolate, ssrIncludeBooleanAttr } from "vue/server-renderer";
import { _ as _sfc_main$2 } from "./Files-B6eiTnN6.js";
import { _ as _sfc_main$1 } from "./AdminLayout-CD07IMsK.js";
import { useForm, Head, Link } from "@inertiajs/vue3";
import Dropdown from "primevue/dropdown/dropdown.esm.js";
import "toastify-js";
import "./useToastify-D_n0s7Uc.js";
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "laravel-vue-i18n";
import "./Pagination-C1AQrLe3.js";
import "./SearchList-BZnYMQPN.js";
import "lodash/debounce.js";
import "./useRandomNum-DNNSqR7b.js";
import "simplebar";
import "resize-observer-polyfill";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "Edit",
  __ssrInlineRender: true,
  props: {
    user: {},
    genderList: {}
  },
  setup(__props) {
    const props = __props;
    const profileForm = useForm({
      avatar: props.user.avatar,
      name: props.user.name,
      username: props.user.username,
      email: props.user.email,
      national_number: props.user.national_number,
      birthday: props.user.jalali_birthday != null ? props.user.jalali_birthday[1] : null,
      gender: props.user.gender,
      bio: props.user.bio,
      social: {
        instagram: props.user.get_social.instagram,
        telegram: props.user.get_social.telegram,
        twitter: props.user.get_social.twitter,
        facebook: props.user.get_social.facebook
      }
    });
    const mediaReactive = inject("mediaData");
    watch(mediaReactive, (media) => {
      if (media.type == "avatar" && media.file != null) {
        props.user.get_avatar = media.file.url;
        profileForm.avatar = media.file.id + "";
      }
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.edit_profile")
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.sentence.edit_profile"),
        item: _ctx.$t("messages.sentence.edit_profile")
      }, null, _parent));
      _push(`<div class="edit-profile mb-4"><div class="card"><div class="card-body"><form class="row edit-account-form"><div class="col-12 avatar-container d-flex align-items-center mb-5"><img width="100" height="100"${ssrRenderAttr("src", _ctx.user.get_avatar)} class="shadow-1"${ssrRenderAttr("alt", _ctx.user.name)}><div class="edit-link"><button type="button" class="btn btn-light shadow-1 lts-05" data-bs-toggle="modal" data-bs-target="#mediaLibrary" data-bs-input="avatar"><i class="ri-pencil-line"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.change_profile"))}</button><div class="image-information">(${ssrInterpolate(_ctx.$t("messages.sentence.profile_hint"))})</div></div></div><div class="col-sm-6 col-12 mb-4"><label for="eaFullname" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.full_name"))}</label><input${ssrRenderAttr("value", unref(profileForm).name)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.full_name"))} required class="form-control" id="eaFullname"></div><div class="col-sm-6 col-12 mb-4"><label for="eaUsername" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.username"))}</label><input${ssrRenderAttr("value", unref(profileForm).username)} minlength="4" maxlength="20" type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.username"))} required class="form-control" id="eaUsername"><span class="form-control-description">${ssrInterpolate(_ctx.$t("messages.sentence.username_hint"))}</span></div><div class="col-sm-6 col-12 mb-4"><label for="eaPhone" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.phone"))}</label><input${ssrRenderAttr("value", _ctx.user.phone)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.phone"))} class="form-control" id="eaPhone" minlength="11" maxlength="11" autocomplete="phone" disabled></div><div class="col-sm-6 col-12 mb-4"><label for="eaEmail" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.email"))} <template>`);
      if (_ctx.user.email != null && _ctx.user.email_verified_at == null) {
        _push(`<span class="unverified_badge lts-05">`);
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("verification.send"),
          method: "post",
          as: "button"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("messages.sentence.send_verify_link"))}`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("messages.sentence.send_verify_link")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</span>`);
      } else if (_ctx.user.email != null && _ctx.user.email_verified_at != null) {
        _push(`<span class="verified_badge lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.verified"))}</span>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</template></label><input${ssrRenderAttr("value", unref(profileForm).email)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.email"))} class="form-control" id="eaEmail"${ssrIncludeBooleanAttr(_ctx.user.email != null && _ctx.user.email_verified_at != null) ? " disabled" : ""}></div><div class="col-sm-4 col-12 mb-4"><label for="eaNationalCode" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.national_number"))}</label><input${ssrRenderAttr("value", unref(profileForm).national_number)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.national_number"))} class="form-control" maxlength="10" id="eaNationalCode"></div><div class="col-sm-4 col-12 mb-4"><label for="birthdayPicker" class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.birthday_date"))}</label><input${ssrRenderAttr("value", unref(profileForm).birthday)} id="birthdayPicker"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.choose") + " " + _ctx.$t("messages.sentence.birthday_date"))} type="text" readonly class="form-control" data-jdp data-jdp-max-date="1415/01/01"></div><div class="col-sm-4 col-12 mb-4"><label for="eaGender" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.gender"))}</label>`);
      _push(ssrRenderComponent(unref(Dropdown), {
        modelValue: unref(profileForm).gender,
        "onUpdate:modelValue": ($event) => unref(profileForm).gender = $event,
        options: _ctx.genderList,
        optionLabel: "label",
        optionValue: "id",
        id: "eaGender",
        placeholder: _ctx.$t("messages.sentence.choose_gender"),
        readonly: "",
        class: "pvc-dropdown"
      }, null, _parent));
      _push(`</div><div class="col-12 mb-4"><label for="eaBiography" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.biography"))}</label><textarea class="form-control lh-30" rows="5" name="biography"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.biography_summary"))} id="eaBiography">${ssrInterpolate(unref(profileForm).bio)}</textarea></div><div class="col-12 mb-4"><div class="border"></div></div><div class="col-12 mb-4"><span class="fw-bold d-flex fs-6 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.personal_socials"))}</span></div><div class="col-sm-6 col-12 mb-4"><label for="eaInstagram" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.instagram"))}</label><input${ssrRenderAttr("value", unref(profileForm).social.instagram)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.page_address") + " " + _ctx.$t("messages.word.instagram"))} class="form-control" id="eaInstagram"></div><div class="col-sm-6 col-12 mb-4"><label for="eaTelegram" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.telegram"))}</label><input${ssrRenderAttr("value", unref(profileForm).social.telegram)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.page_address") + " " + _ctx.$t("messages.word.telegram"))} class="form-control" id="eaTelegram"></div><div class="col-sm-6 col-12 mb-4"><label for="eaTwitter" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.twitter"))}</label><input${ssrRenderAttr("value", unref(profileForm).social.twitter)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.page_address") + " " + _ctx.$t("messages.word.twitter"))} class="form-control" id="eaTwitter"></div><div class="col-sm-6 col-12 mb-5"><label for="eaFacebook" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.facebook"))}</label><input${ssrRenderAttr("value", unref(profileForm).social.facebook)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.page_address") + " " + _ctx.$t("messages.word.facebook"))} class="form-control" id="eaFacebook"></div><div class="col-12 d-flex align-items-center justify-content-end mb-2">`);
      _push(ssrRenderComponent(unref(Link), {
        as: "button",
        href: _ctx.route("admin.dashboard"),
        class: "btn btn-light lts-05 shadow-1 me-3"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("messages.word.cancel"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("messages.word.cancel")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`<button type="submit" class="btn btn-primary lts-05 shadow-1"${ssrIncludeBooleanAttr(unref(profileForm).processing) ? " disabled" : ""}>${ssrInterpolate(_ctx.$t("messages.sentence.save_changes"))} `);
      if (unref(profileForm).processing) {
        _push(`<i class="ri-refresh-line i-spin"></i>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</button></div></form></div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Admin/Account/Edit.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
