import { defineComponent, unref, withCtx, createVNode, createTextVNode, toDisplayString, useSSRContext } from "vue";
import { ssrRenderComponent, ssrRenderAttr, ssrInterpolate, ssrRenderStyle, ssrRenderList } from "vue/server-renderer";
import { _ as _sfc_main$1, a as _sfc_main$2 } from "./StoreLayout-D2_RagXW.js";
import { _ as _sfc_main$3 } from "./BarAndLineChart-BNn4O1Ev.js";
import { _ as _sfc_main$4 } from "./LineChart-CIYq_-2s.js";
import { Head, Link } from "@inertiajs/vue3";
import { u as useNumberFormat } from "../ssr.js";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
import "jquery";
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
import "./Pagination-C1AQrLe3.js";
import "./SearchList-BZnYMQPN.js";
import "lodash/debounce.js";
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "./useRandomNum-DNNSqR7b.js";
import "bootstrap";
import "./useNl2br-BIw8h5gy.js";
import "apexcharts";
import "chart.js/auto";
import "@vue/server-renderer";
import "@inertiajs/vue3/server";
import "ziggy-js";
import "laravel-vue-i18n";
import "axios";
import "swiper/bundle";
import "swiper";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "Dashboard",
  __ssrInlineRender: true,
  props: {
    salesAmount: {},
    salesChart: {},
    statisticsChart: {},
    consignments: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.word.dashboard")
      }, null, _parent));
      _push(`<div class="container-fluid seller-panel-container">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.word.dashboard")
      }, null, _parent));
      _push(`<div class="row intro-welcome seller-intro-welcome"><div class="col-xl-8 col-lg-8 col-md-12 col-12 mb-4 user-welcome"><div class="card"><img${ssrRenderAttr("src", _ctx.$page.props.appUrl + "/img/template/basket-claymation-2.png")} class="welcome-bg seller-welcome-bg"><div class="card-body"><span class="user-name mb-3"><img${ssrRenderAttr("src", _ctx.$page.props.auth.user.get_avatar)}${ssrRenderAttr("alt", _ctx.$page.props.auth.user.get_name)} class="shadow-1"><span>${ssrInterpolate(_ctx.$page.props.auth.user.get_name)}</span> ${ssrInterpolate(_ctx.$t("messages.sentence.dear_welcome"))}</span><span class="task-desc mb-4">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_154895"))}</span><ul><li><span class="value">${ssrInterpolate(_ctx.$page.props.auth.sellerBadge["waiting-orders"])} <span>${ssrInterpolate(_ctx.$t("messages.word.order"))}</span></span><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_review"))}</span></li><li><span class="value">${ssrInterpolate(_ctx.$page.props.auth.sellerBadge["waiting-tickets"])} <span>${ssrInterpolate(_ctx.$t("messages.word.ticket"))}</span></span><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_answer"))}</span></li><li><span class="value">${ssrInterpolate(_ctx.$page.props.auth.sellerBadge["waiting-product"])} <span>${ssrInterpolate(_ctx.$t("messages.word.product"))}</span></span><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_verify"))}</span></li><li><span class="value">${ssrInterpolate(_ctx.$page.props.auth.sellerBadge["waiting-inventory"])} <span>${ssrInterpolate(_ctx.$t("messages.word.inventory"))}</span></span><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_verify"))}</span></li></ul></div></div></div><div class="col-xl-4 col-lg-4 col-md-12 col-12 mb-4"><div class="card wallet-widget shadow-1"><div class="card-body"><div class="wallet-pattern"></div><div class="top-section"><h6>${ssrInterpolate(_ctx.$t("messages.word.wallet"))} ${ssrInterpolate(_ctx.$page.props.appName)}</h6><span>**** ****</span></div><div class="bottom-section"><div><h6 class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.wallet_amount"))}</h6><h4>${ssrInterpolate(_ctx.$page.props.auth.wallet.get_formatted_amount)} <span>${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span></h4></div><div class="left"><p class="lts-05 fs-9 me-2">${ssrInterpolate(_ctx.$t("messages.sentence.increase_amount"))}</p>`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("seller.wallet.index")
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<span${_scopeId}><i class="ri-add-line"${_scopeId}></i></span>`);
          } else {
            return [
              createVNode("span", null, [
                createVNode("i", { class: "ri-add-line" })
              ])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div></div></div></div></div></div><div class="row statistics"><div class="income-payments col-lg-6 col-md-12 mb-4"><div class="card income shadow-1"><div class="card-body" style="${ssrRenderStyle({ "padding-bottom": "10px" })}"><ul class="mb-4 mt-3"><li><span class="title fw-normal">${ssrInterpolate(_ctx.$t("messages.sentence.today_sale"))}</span><span class="value">${ssrInterpolate(unref(useNumberFormat)(_ctx.salesAmount.today_sale))} <span class="unit unit-sm"></span></span></li><li><span class="title fw-normal">${ssrInterpolate(_ctx.$t("messages.sentence.month_sales"))}</span><span class="value">${ssrInterpolate(unref(useNumberFormat)(_ctx.salesAmount.month_sales))} <span class="unit unit-sm"></span></span></li><li><span class="title fw-normal">${ssrInterpolate(_ctx.$t("messages.sentence.total_sales"))}</span><span class="value">${ssrInterpolate(unref(useNumberFormat)(_ctx.salesAmount.total_sales))} <span class="unit unit-sm"></span></span></li></ul><div class="el-chart" style="${ssrRenderStyle({ "direction": "ltr", "height": "100%" })}">`);
      _push(ssrRenderComponent(_sfc_main$3, {
        id: 1,
        color: ["#ffc107", "#5d87ff"],
        labels: _ctx.salesChart.dates,
        datasets: {
          bar: { data: _ctx.salesChart.amounts, label: "مبلغ فروش" },
          line: { data: _ctx.salesChart.counts, label: "تعداد فروش" }
        }
      }, null, _parent));
      _push(`</div></div></div></div><div class="col-lg-6 col-md-12 col-12 mb-4"><div class="card shadow-1"><div class="card-body"><div class="details mb-2"><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.store_page_view"))}</span><span class="value">${ssrInterpolate(unref(useNumberFormat)(_ctx.statisticsChart.total))}</span><span class="flag">${ssrInterpolate(_ctx.$t("messages.sentence.total_page_view"))}</span></div><div class="el-chart">`);
      _push(ssrRenderComponent(_sfc_main$4, {
        id: 1,
        labels: _ctx.statisticsChart.dates,
        datasets: {
          one: { data: _ctx.statisticsChart.views, label: "بازدید", color: "#fc5b61" }
        }
      }, null, _parent));
      _push(`</div></div></div></div></div><div class="row"><div class="col-lg-12 col-md-12 mb-4"><div class="card payments shadow-1"><div class="card-body"><div class="card-title mb-4"><span>${ssrInterpolate(_ctx.$t("messages.sentence.latest_order_list"))}</span></div><div class="table-responsive"><table class="table"><thead><tr><th>${ssrInterpolate(_ctx.$t("messages.word.row"))}</th><th>${ssrInterpolate(_ctx.$t("messages.sentence.order_uuid"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.status"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.date"))}</th><th class="first-small">${ssrInterpolate(_ctx.$t("messages.word.actions"))}</th></tr></thead><tbody><!--[-->`);
      ssrRenderList(_ctx.consignments, (consignment, index) => {
        _push(`<tr><td class="first-small">${ssrInterpolate(index + 1)}</td><td>${ssrInterpolate(consignment.uuid)}</td><td>`);
        if (consignment.status == "awaiting_seller") {
          _push(`<span class="badge bg-info text-info">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_seller"))}</span>`);
        } else if (consignment.status == "sent_to_main_storage") {
          _push(`<span class="badge bg-purple text-info">${ssrInterpolate(_ctx.$t("messages.sentence.sent_to_main_storage"))}</span>`);
        } else if (consignment.status == "delivered_to_main_storage") {
          _push(`<span class="badge bg-success text-info">${ssrInterpolate(_ctx.$t("messages.sentence.delivered_to_main_storage"))}</span>`);
        } else if (consignment.status == "sent_to_customer") {
          _push(`<span class="badge bg-success text-info">${ssrInterpolate(_ctx.$t("messages.sentence.sent_to_customer"))}</span>`);
        } else if (consignment.status == "delivered") {
          _push(`<span class="badge bg-success text-info">${ssrInterpolate(_ctx.$t("messages.sentence.delivered_to_customer"))}</span>`);
        } else if (consignment.status == "cancelled") {
          _push(`<span class="badge bg-danger text-info">${ssrInterpolate(_ctx.$t("messages.word.cancelled"))}</span>`);
        } else if (consignment.status == "returned") {
          _push(`<span class="badge bg-danger text-info">${ssrInterpolate(_ctx.$t("messages.word.returned"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</td><td>${ssrInterpolate(consignment.jalali_created_at[2])}</td><td class="first-small" style="${ssrRenderStyle({ "width": "150px" })}">`);
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("seller.orders.show", consignment.id),
          as: "button",
          class: "btn btn-sm btn-outline-light pt-1 pb-1 lts-05"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("messages.word.details"))} <i class="ri-arrow-left-s-fill"${_scopeId}></i>`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("messages.word.details")) + " ", 1),
                createVNode("i", { class: "ri-arrow-left-s-fill" })
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</td></tr>`);
      });
      _push(`<!--]--></tbody></table></div>`);
      if (_ctx.consignments.length == 0) {
        _push(`<div class="cart-empty"><div class="empty-content-icon"><img${ssrRenderAttr("src", _ctx.$page.props.appUrl + "/img/template/orders.svg")} alt=""></div><div class="empty-content-message text-center"><p>${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</p></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Store/Dashboard.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
