import { defineComponent, ref, inject, watch, unref, useSSRContext } from "vue";
import { ssrRenderComponent, ssrRenderStyle, ssrInterpolate, ssrRenderAttr } from "vue/server-renderer";
import { _ as _sfc_main$1 } from "./AdminLayout-CD07IMsK.js";
import { useForm, Head } from "@inertiajs/vue3";
import * as Coloris from "@melloware/coloris";
import { _ as _sfc_main$2 } from "./Files-B6eiTnN6.js";
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "laravel-vue-i18n";
import "./Pagination-C1AQrLe3.js";
import "./SearchList-BZnYMQPN.js";
import "lodash/debounce.js";
import "./useRandomNum-DNNSqR7b.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "Create",
  __ssrInlineRender: true,
  setup(__props) {
    $(() => {
      Coloris.init();
      Coloris.coloris({
        parent: "#addColor",
        el: "#eaColorCode",
        alpha: false,
        selectInput: false,
        defaultColor: "#0060ff",
        swatches: ["#ffc107", "#f4a261", "#ff9c22", "#e76f51", "#fc5b61", "#dc3545", "#264653", "#2a9d8f", "#21d9c0", "#0097e6", "#07b", "#0060ff"]
      });
      Coloris.close();
    });
    const colorImage = ref(null);
    const createColorForm = useForm({
      color: "#000000",
      label: null,
      image: null
    });
    const mediaReactive = inject("mediaData");
    watch(mediaReactive, (media) => {
      if (media.type == "color" && media.file != null) {
        colorImage.value = media.file.url;
      }
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.add_color")
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.sentence.add_color")
      }, null, _parent));
      _push(`<div class="add-colors card"><div class="card-body"><form style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-body"><div class="row"><div class="col-md-6 col-12 mb-4"><label for="eaColorLabel" class="d-block form-label fw-bold lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.color_name"))}: </label><input${ssrRenderAttr("value", unref(createColorForm).label)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.example_light_red"))} class="form-control" id="eaColorLabel"></div><div class="col-12 color-picker mb-4"><label for="eaColorCode" class="d-block form-label fw-bold lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.choose_color"))}: </label><input id="eaColorCode"${ssrRenderAttr("value", unref(createColorForm).color)}></div><div class="col-12 mb-5"><span class="fw-bold lts-05 mb-3 d-block">${ssrInterpolate(_ctx.$t("messages.sentence.image_by_color"))}: <span class="fw-normal text-info fs-9 ms-1">(${ssrInterpolate(_ctx.$t("messages.word.optional"))})</span></span><div class="color-box add-image clickable" data-bs-toggle="modal" data-bs-target="#mediaLibrary" data-bs-input="color"><img${ssrRenderAttr("src", colorImage.value != null ? colorImage.value : "/img/temp/blank-gray.png")} alt="رنگ"></div></div><div class="col-12"><p class="fs-8 lts-05 text-gray">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_480201"))}</p></div><div class="col-12 mb-4"><div class="border"></div></div></div></div><div class="modal-footer"><button class="btn btn-sm btn-primary px-3">${ssrInterpolate(_ctx.$t("messages.word.create"))}</button></div></form></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Admin/Products/Colors/Create.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
