import { defineComponent, reactive, ref, inject, watch, resolveDirective, unref, mergeProps, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderAttr, ssrIncludeBooleanAttr, ssrRenderList, ssrRenderStyle, ssrRenderAttrs, ssrGetDirectiveProps } from "vue/server-renderer";
import { _ as _sfc_main$2 } from "./Files-B6eiTnN6.js";
import { _ as _sfc_main$3 } from "./Ckeditor-BEPE8WxA.js";
import { _ as _sfc_main$4 } from "./Tagify-DYepU4nx.js";
import { _ as _sfc_main$1 } from "./AdminLayout-CD07IMsK.js";
import { useForm, Head } from "@inertiajs/vue3";
import "toastify-js";
import "./useToastify-D_n0s7Uc.js";
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "laravel-vue-i18n";
import "./Pagination-C1AQrLe3.js";
import "./SearchList-BZnYMQPN.js";
import "lodash/debounce.js";
import "./useRandomNum-DNNSqR7b.js";
import "./useRandomStr-4MeWbtRd.js";
import "@yaireo/tagify";
import "simplebar";
import "resize-observer-polyfill";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "Create",
  __ssrInlineRender: true,
  props: {
    category_id: {}
  },
  setup(__props) {
    const props = __props;
    const groups = reactive([]);
    const categoryImage = ref("");
    const addCategoryForm = useForm({
      image: "",
      parent_id: props.category_id != null ? props.category_id : 0,
      title: null,
      slug: null,
      content: "",
      seo_title: null,
      seo_description: null,
      seo_keywords: "",
      seo_canonical: null,
      specifications: groups
    });
    const mediaReactive = inject("mediaData");
    watch(mediaReactive, (media) => {
      if (media.type == "logo" && media.file != null) {
        categoryImage.value = media.file.url;
        addCategoryForm.image = media.file.id + "";
      }
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _directive_tooltip = resolveDirective("tooltip");
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.create_category")
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.sentence.create_category")
      }, null, _parent));
      _push(`<div class="category-add add-product row mb-4"><div class="col-12"><form><div class="card"><div class="card-body p-4"><div class="pills-tab-container d-flex align-items-start"><div class="action-sidebar"><div class="nav flex-column nav-pills mb-md-4 mb-5" id="v-pills-tab" role="tablist" aria-orientation="vertical"><button class="nav-link active" id="v-pills-main-tab" data-bs-toggle="pill" data-bs-target="#v-pills-main" type="button" role="tab" aria-controls="v-pills-main" aria-selected="true"><i class="ri-keyboard-box-line"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.main_information"))}</button><button class="nav-link" id="v-pills-seo-tab" data-bs-toggle="pill" data-bs-target="#v-pills-seo" type="button" role="tab" aria-controls="v-pills-seo" aria-selected="false"><i class="ri-seo-line"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.seo_settings"))}</button><button class="nav-link" id="v-pills-specifications-tab" data-bs-toggle="pill" data-bs-target="#v-pills-specifications" type="button" role="tab" aria-controls="v-pills-specifications" aria-selected="false"><i class="ri-list-check-2"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.specifications_group"))}</button></div><div class="action-container d-md-block d-none mb-4"><button${ssrIncludeBooleanAttr(unref(addCategoryForm).processing) ? " disabled" : ""} class="btn btn-primary">${ssrInterpolate(_ctx.$t("messages.sentence.create_category"))}</button></div></div><div class="tab-content" id="v-pills-tabContent"><div class="tab-pane fade show active" id="v-pills-main" role="tabpanel" aria-labelledby="v-pills-main-tab" tabindex="0"><div class="row"><div class="col-12 icon-container d-flex align-items-center mb-5"><img width="100" height="100"${ssrRenderAttr("src", categoryImage.value != "" ? categoryImage.value : _ctx.$page.props.appUrl + "/img/temp/empty-image.png")} class="shadow-1 br-15"><div class="edit-link"><button type="button" class="btn btn-light shadow-1 lts-05" data-bs-toggle="modal" data-bs-target="#mediaLibrary" data-bs-input="logo"><i class="ri-add-line"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.select_logo"))}</button><div class="image-information">(${ssrInterpolate(_ctx.$t("messages.sentence.category_logo_is_optional"))})</div></div></div><div class="col-sm-6 col-12 mb-4"><label for="eaTitle" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.title"))}</label><input${ssrRenderAttr("value", unref(addCategoryForm).title)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.title"))} class="form-control" id="eaTitle"></div><div class="col-sm-6 col-12 mb-4"><label for="eaSlug" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.slug"))}</label><input${ssrRenderAttr("value", unref(addCategoryForm).slug)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.better_to_leave_it_blank_and_create_it_automatically"))} class="form-control" id="eaSlug"></div><div class="col-12 mb-4"><label class="form-label mb-2 lts-05">${ssrInterpolate(_ctx.$t("messages.word.content"))}</label>`);
      _push(ssrRenderComponent(_sfc_main$3, {
        modelValue: unref(addCategoryForm).content,
        "onUpdate:modelValue": ($event) => unref(addCategoryForm).content = $event
      }, null, _parent));
      _push(`</div></div></div><div class="tab-pane fade" id="v-pills-seo" role="tabpanel" aria-labelledby="v-pills-seo-tab" tabindex="0"><div class="row"><div class="col-sm-6 col-12 mb-4"><label for="eaSeoTitle" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.title") + " " + _ctx.$t("messages.word.seo"))}</label><input${ssrRenderAttr("value", unref(addCategoryForm).seo_title)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.title_for_seo"))} class="form-control" id="eaSeoTitle"></div><div class="col-sm-6 col-12 mb-4"><label for="eaSeoKeywords" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.keywords"))}</label>`);
      _push(ssrRenderComponent(_sfc_main$4, {
        modelValue: unref(addCategoryForm).seo_keywords,
        "onUpdate:modelValue": ($event) => unref(addCategoryForm).seo_keywords = $event
      }, null, _parent));
      _push(`</div><div class="col-12 mb-4"><label for="eaDescription" class="form-label lts-05">${ssrInterpolate(_ctx.$t("messages.word.description") + " " + _ctx.$t("messages.word.seo"))}</label><textarea${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.briefly_describe_the_content_in_two_lines"))} class="form-control" id="eaDescription">${ssrInterpolate(unref(addCategoryForm).seo_description)}</textarea></div><div class="col-12 mb-5"><label for="eaCanonical" class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.canonical_tag"))}</label><input${ssrRenderAttr("value", unref(addCategoryForm).seo_canonical)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.enter_link_optional"))} class="form-control" id="eaCanonical"></div><div class="col-sm-6 col-12 mb-4"><div class="checkbox-container"><i class="ri-check-line"></i><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.create_snippet_for_google"))}</span><span class="flag"> (${ssrInterpolate(_ctx.$t("messages.sentence.create_automatically"))}) </span></div></div><div class="col-sm-6 col-12 mb-4"><div class="checkbox-container"><i class="ri-check-line"></i><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.create_preview_for_socials"))}</span><span class="flag"> (${ssrInterpolate(_ctx.$t("messages.sentence.create_automatically"))}) </span></div></div><div class="col-sm-6 col-12 mb-4"><div class="checkbox-container"><i class="ri-check-line"></i><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.add_to_sitemap"))}</span><span class="flag"> (${ssrInterpolate(_ctx.$t("messages.sentence.create_automatically"))}) </span></div></div><div class="col-sm-6 col-12 mb-4"><div class="checkbox-container"><i class="ri-check-line"></i><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.create_meta_tags"))}</span><span class="flag"> (${ssrInterpolate(_ctx.$t("messages.sentence.create_automatically"))}) </span></div></div></div></div><div class="tab-pane fade" id="v-pills-specifications" role="tabpanel" aria-labelledby="v-pills-specifications-tab" tabindex="0"><div class="title lts-05 mb-3">${ssrInterpolate(_ctx.$t("messages.sentence.specifications_table"))}</div><span class="d-inline-block alert alert-info text-info lts-05 lh-25 mb-4">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_784529"))}</span><div class="row specification"><div id="specificationContainer" class="col-12 specification-items"><!--[-->`);
      ssrRenderList(groups, (group, group_index) => {
        _push(`<div class="specification-item mb-3"><div class="tab-title mb-3"><input${ssrRenderAttr("value", group.title)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.group_name_examle_technical"))} class="form-control" style="${ssrRenderStyle({ "max-width": "220px" })}" required></div><div class="sub"><!--[-->`);
        ssrRenderList(group.keys, (key, key_index) => {
          _push(`<div class="row sub-item mb-1"><div class="col-sm-6 col-12 p-0 mb-1 mb-md-0"><input${ssrRenderAttr("value", key.key)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.key_name_examle_ram"))} class="form-control" required></div><div class="col-sm-6 col-12 p-0 ps-md-2"><input${ssrRenderAttr("value", key.value)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.default_value_optional"))} class="form-control"></div><div class="col-1"><i class="remove-key-item ri-close-line"></i></div></div>`);
        });
        _push(`<!--]--></div><button${ssrRenderAttrs(mergeProps({
          type: "button",
          class: "btn d-none btn-square btn-xs btn-primary mt-2"
        }, ssrGetDirectiveProps(_ctx, _directive_tooltip, _ctx.$t("messages.sentence.add_item"), void 0, { top: true })))}><i class="ri-add-line"></i></button><i class="remove-item ri-close-line"></i></div>`);
      });
      _push(`<!--]--></div><div class="col-12"><button type="button" class="btn btn-light lts-05 shadow-1">${ssrInterpolate(_ctx.$t("messages.sentence.add_specification_group"))} <i class="ri-add-line ms-1"></i></button></div></div></div></div></div><div class="action-container d-md-none d-block mt-4"><button${ssrIncludeBooleanAttr(unref(addCategoryForm).processing) ? " disabled" : ""} class="btn btn-primary">${ssrInterpolate(_ctx.$t("messages.sentence.create_category"))}</button></div></div></div></form></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Admin/Products/Categories/Create.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
