import { defineComponent, ref, reactive, watch, inject, resolveDirective, unref, withCtx, createVNode, createBlock, createCommentVNode, createTextVNode, openBlock, toDisplayString, mergeProps, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrIncludeBooleanAttr, ssrLooseContain, ssrRenderAttr, ssrRenderClass, ssrRenderStyle, ssrRenderList, ssrRenderAttrs, ssrGetDirectiveProps } from "vue/server-renderer";
import { _ as _sfc_main$1 } from "./AdminLayout-CD07IMsK.js";
import { useForm, Head } from "@inertiajs/vue3";
import Dropdown from "primevue/dropdown/dropdown.esm.js";
import AutoComplete from "primevue/autocomplete/autocomplete.esm.js";
import axios from "axios";
import { _ as _sfc_main$2 } from "./Files-B6eiTnN6.js";
import { _ as _sfc_main$3 } from "./Tagify-DYepU4nx.js";
import { _ as _sfc_main$4 } from "./Ckeditor-BEPE8WxA.js";
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "laravel-vue-i18n";
import "./Pagination-C1AQrLe3.js";
import "./SearchList-BZnYMQPN.js";
import "lodash/debounce.js";
import "./useRandomNum-DNNSqR7b.js";
import "@yaireo/tagify";
import "./useRandomStr-4MeWbtRd.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "Create",
  __ssrInlineRender: true,
  props: {
    categories: {},
    statusList: {},
    videoTypeList: {}
  },
  setup(__props) {
    const props = __props;
    const brandItems = ref([]);
    const searchBrand = (event) => {
      axios.get(route("admin.brands.search"), {
        params: {
          search: event.query
        }
      }).then(function(response) {
        let brands = response.data;
        brandItems.value = brands;
        if (brands.length > 0) {
          $(".p-autocomplete-panel").show();
        } else {
          $(".p-autocomplete-panel").hide();
        }
      }).catch(function(error) {
        console.log(error);
      });
    };
    const categoriesList = ref([]);
    for (let category2 in props.categories) {
      categoriesList.value.push(props.categories[category2]);
    }
    const imagesID = ref([]);
    const imagesUrls = ref([]);
    const attrs = reactive([]);
    const category = ref();
    let specificationsGroups = reactive([]);
    let priceModel = reactive([]);
    priceModel.push({
      type: "color",
      name: "رنگ",
      active: false
    });
    priceModel.push({
      type: "warranty",
      name: "گارانتی",
      active: false
    });
    watch(category, (value) => {
      specificationsGroups = value.specifications;
    });
    const productTabs = reactive([]);
    const createProductForm = useForm({
      uuid: null,
      title: null,
      title_en: null,
      slug: null,
      tags: "",
      brand: null,
      category: category.value,
      content: "",
      warnings: null,
      guide: "",
      tabs: productTabs,
      seo_title: null,
      seo_description: null,
      seo_keywords: "",
      seo_canonical: null,
      images: imagesID.value,
      videos: {
        type: null,
        link: null,
        embed: null
      },
      model_3d: null,
      attrs,
      specifications: specificationsGroups,
      in_stock_status: true,
      inquiry_options: {
        landline_phone: "",
        cellular_phone: ""
      },
      commission: 0,
      price_model: priceModel,
      is_vip: false,
      question_status: true,
      comment_status: true,
      status: "publish"
    });
    const mediaReactive = inject("mediaData");
    watch(mediaReactive, (media) => {
      if (media.type == "product" && media.file != null) {
        imagesID.value.push(media.file.id);
        imagesUrls.value.push(media.file.url);
      }
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _directive_tooltip = resolveDirective("tooltip");
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.create_product")
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.sentence.create_product")
      }, null, _parent));
      _push(`<div class="add-product row mb-4"><div class="col-12"><form><div class="card mb-4"><div class="card-body"><div class="pills-tab-container d-flex align-items-start"><div class="action-sidebar"><div class="nav flex-column nav-pills mb-md-4 mb-5" id="v-pills-tab" role="tablist" aria-orientation="vertical"><button class="nav-link active" id="v-pills-main-tab" data-bs-toggle="pill" data-bs-target="#v-pills-main" type="button" role="tab" aria-controls="v-pills-main" aria-selected="true"><i class="ri-keyboard-box-line"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.main_information"))}</button><button class="nav-link" id="v-pills-seo-tab" data-bs-toggle="pill" data-bs-target="#v-pills-seo" type="button" role="tab" aria-controls="v-pills-seo" aria-selected="false"><i class="ri-seo-line"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.seo_settings"))}</button><button class="nav-link" id="v-pills-images-tab" data-bs-toggle="pill" data-bs-target="#v-pills-images" type="button" role="tab" aria-controls="v-pills-images" aria-selected="false"><i class="ri-image-edit-line"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.media_and_images"))}</button><button class="nav-link" id="v-pills-specification-tab" data-bs-toggle="pill" data-bs-target="#v-pills-specification" type="button" role="tab" aria-controls="v-pills-specification" aria-selected="false"><i class="ri-list-check-2"></i> ${ssrInterpolate(_ctx.$t("messages.word.specifications"))}</button><button class="nav-link" id="v-pills-guide-tab" data-bs-toggle="pill" data-bs-target="#v-pills-guide" type="button" role="tab" aria-controls="v-pills-guide" aria-selected="false"><i class="ri-question-line"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.product_guide"))}</button><button class="nav-link" id="v-pills-tabs-tab" data-bs-toggle="pill" data-bs-target="#v-pills-tabs" type="button" role="tab" aria-controls="v-pills-tabs" aria-selected="false"><i class="ri-table-line"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.product_tabs"))}</button><button class="nav-link" id="v-pills-price-tab" data-bs-toggle="pill" data-bs-target="#v-pills-price" type="button" role="tab" aria-controls="v-pills-price" aria-selected="false"><i class="ri-price-tag-3-line"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.price_model"))}</button></div><div class="action-container d-md-block d-none mb-4"><div class="form-check form-switch mb-3"><label class="form-check-label lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.vip_product"))}؟ <input${ssrIncludeBooleanAttr(Array.isArray(unref(createProductForm).is_vip) ? ssrLooseContain(unref(createProductForm).is_vip, null) : unref(createProductForm).is_vip) ? " checked" : ""} class="form-check-input" name="tndevasbsdb" type="checkbox" role="switch"></label></div><div class="form-check form-switch mb-3"><label class="form-check-label lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.show_questions"))} <input${ssrIncludeBooleanAttr(Array.isArray(unref(createProductForm).question_status) ? ssrLooseContain(unref(createProductForm).question_status, null) : unref(createProductForm).question_status) ? " checked" : ""} class="form-check-input" name="tjerhbsdbsd" type="checkbox" role="switch" checked></label></div><div class="form-check form-switch mb-4"><label class="form-check-label lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.show_comments"))} <input${ssrIncludeBooleanAttr(Array.isArray(unref(createProductForm).comment_status) ? ssrLooseContain(unref(createProductForm).comment_status, null) : unref(createProductForm).comment_status) ? " checked" : ""} class="form-check-input" name="jmrnhbesvsb" type="checkbox" role="switch" checked></label></div><label class="form-label lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.product_status"))}: </label>`);
      _push(ssrRenderComponent(unref(Dropdown), {
        class: "pvc-dropdown",
        modelValue: unref(createProductForm).status,
        "onUpdate:modelValue": ($event) => unref(createProductForm).status = $event,
        options: _ctx.statusList,
        display: "chip",
        optionLabel: "label",
        optionValue: "id",
        placeholder: _ctx.$t("messages.sentence.select_status")
      }, null, _parent));
      _push(`<button${ssrIncludeBooleanAttr(unref(createProductForm).processing) ? " disabled" : ""} class="btn btn-primary mt-3">${ssrInterpolate(_ctx.$t("messages.sentence.create_product"))}</button></div></div><div class="tab-content" id="v-pills-tabContent"><div class="tab-pane fade show active" id="v-pills-main" role="tabpanel" aria-labelledby="v-pills-main-tab" tabindex="0"><div class="row"><div class="col-sm-6 col-12 mb-4"><label for="eaTitle" class="form-label required">${ssrInterpolate(_ctx.$t("messages.word.title"))}</label><input${ssrRenderAttr("value", unref(createProductForm).title)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.product_main_title"))} class="form-control" id="eaTitle"></div><div class="col-sm-6 col-12 mb-4"><label for="eaEnTitle" class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.english_title"))}</label><input${ssrRenderAttr("value", unref(createProductForm).title_en)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.product_english_title"))} class="form-control" id="eaEnTitle"></div><div class="col-sm-6 col-12 mb-4"><label for="eaCategories" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.category"))}</label>`);
      _push(ssrRenderComponent(unref(Dropdown), {
        class: "pvc-multiselect pvc-multiselect-filter",
        modelValue: category.value,
        "onUpdate:modelValue": ($event) => category.value = $event,
        options: categoriesList.value,
        filter: "",
        emptyFilterMessage: _ctx.$t("messages.sentence.no_items_found"),
        display: "chip",
        optionLabel: "title",
        placeholder: _ctx.$t("messages.sentence.select_category")
      }, {
        option: withCtx((slotProps, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="category-template flex align-items-center"${_scopeId}><div class="${ssrRenderClass({
              "category-level-one": slotProps.option.level == "one",
              "category-level-two": slotProps.option.level == "two",
              "category-level-three": slotProps.option.level == "three"
            })}"${_scopeId}>`);
            if (slotProps.option.level == "three") {
              _push2(`<span${_scopeId}><i class="ri-arrow-drop-left-line"${_scopeId}></i></span>`);
            } else if (slotProps.option.level == "two") {
              _push2(`<span${_scopeId}><i class="circle-icon ri-circle-fill"${_scopeId}></i></span>`);
            } else {
              _push2(`<!---->`);
            }
            _push2(` ${ssrInterpolate(slotProps.option.title)}</div></div>`);
          } else {
            return [
              createVNode("div", { class: "category-template flex align-items-center" }, [
                createVNode("div", {
                  class: {
                    "category-level-one": slotProps.option.level == "one",
                    "category-level-two": slotProps.option.level == "two",
                    "category-level-three": slotProps.option.level == "three"
                  }
                }, [
                  slotProps.option.level == "three" ? (openBlock(), createBlock("span", { key: 0 }, [
                    createVNode("i", { class: "ri-arrow-drop-left-line" })
                  ])) : slotProps.option.level == "two" ? (openBlock(), createBlock("span", { key: 1 }, [
                    createVNode("i", { class: "circle-icon ri-circle-fill" })
                  ])) : createCommentVNode("", true),
                  createTextVNode(" " + toDisplayString(slotProps.option.title), 1)
                ], 2)
              ])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div><div class="col-sm-6 col-12 mb-4"><label for="eaEnSlug" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.slug"))}</label><input${ssrRenderAttr("value", unref(createProductForm).slug)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.better_to_leave_it_blank_and_create_it_automatically"))} class="form-control" id="eaEnSlug"></div><div class="col-sm-6 col-12 mb-4"><label for="eaTags" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.tags"))}</label>`);
      _push(ssrRenderComponent(_sfc_main$3, {
        modelValue: unref(createProductForm).tags,
        "onUpdate:modelValue": ($event) => unref(createProductForm).tags = $event
      }, null, _parent));
      _push(`<span class="form-control-description">${ssrInterpolate(_ctx.$t("messages.sentence.write_tag_name_and_press_enter"))}</span></div><div class="col-sm-6 col-12 mb-4"><label class="form-label">${ssrInterpolate(_ctx.$t("messages.word.brand"))}</label>`);
      _push(ssrRenderComponent(unref(AutoComplete), {
        onKeydown: () => {
        },
        modelValue: unref(createProductForm).brand,
        "onUpdate:modelValue": ($event) => unref(createProductForm).brand = $event,
        dropdown: "",
        suggestions: brandItems.value,
        onComplete: searchBrand,
        placeholder: _ctx.$t("messages.sentence.product_brand")
      }, null, _parent));
      _push(`<span class="form-control-description">${ssrInterpolate(_ctx.$t("messages.sentence.select_exist_brand_or_write_new_one"))}</span></div><div class="col-sm-6 col-12 mb-4"><label for="eaTitle" class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.product_uuid"))} <span class="badge bg-light text-dark">${ssrInterpolate(_ctx.$t("messages.word.optional"))}</span></label><input${ssrRenderAttr("value", unref(createProductForm).uuid)} type="text" placeholder="example: p-0000000" class="form-control" id="eaTitle" dir="ltr" style="${ssrRenderStyle({ "direction": "ltr" })}"><span class="form-control-description lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_5400123"))}</span></div><div class="col-12 mb-4"><label for="eaWarnings" class="form-label lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.warning_and_description"))}</label><textarea${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.warning_and_description_optional"))} class="form-control" id="eaWarnings">${ssrInterpolate(unref(createProductForm).warnings)}</textarea></div><div class="col-12 mb-4"><label class="form-label mb-2 lts-05">${ssrInterpolate(_ctx.$t("messages.word.review"))}</label>`);
      _push(ssrRenderComponent(_sfc_main$4, {
        modelValue: unref(createProductForm).content,
        "onUpdate:modelValue": ($event) => unref(createProductForm).content = $event
      }, null, _parent));
      _push(`</div></div></div><div class="tab-pane fade" id="v-pills-seo" role="tabpanel" aria-labelledby="v-pills-seo-tab" tabindex="0"><div class="row"><div class="col-sm-6 col-12 mb-4"><label for="eaSeoTitle" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.title") + " " + _ctx.$t("messages.word.seo"))}</label><input${ssrRenderAttr("value", unref(createProductForm).seo_title)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.title_for_seo"))} class="form-control" id="eaSeoTitle"></div><div class="col-sm-6 col-12 mb-4"><label for="eaSeoKeywords" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.keywords"))}</label>`);
      _push(ssrRenderComponent(_sfc_main$3, {
        modelValue: unref(createProductForm).seo_keywords,
        "onUpdate:modelValue": ($event) => unref(createProductForm).seo_keywords = $event
      }, null, _parent));
      _push(`</div><div class="col-12 mb-4"><label for="eaDescription" class="form-label lts-05">${ssrInterpolate(_ctx.$t("messages.word.description") + " " + _ctx.$t("messages.word.seo"))}</label><textarea${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.briefly_describe_the_content_in_two_lines"))} class="form-control" id="eaDescription">${ssrInterpolate(unref(createProductForm).seo_description)}</textarea></div><div class="col-12 mb-5"><label for="eaCanonical" class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.canonical_tag"))}</label><input${ssrRenderAttr("value", unref(createProductForm).seo_canonical)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.enter_link_optional"))} class="form-control" id="eaCanonical"></div><div class="col-sm-6 col-12 mb-4"><div class="checkbox-container"><i class="ri-check-line"></i><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.create_snippet_for_google"))}</span><span class="flag"> (${ssrInterpolate(_ctx.$t("messages.sentence.create_automatically"))}) </span></div></div><div class="col-sm-6 col-12 mb-4"><div class="checkbox-container"><i class="ri-check-line"></i><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.create_preview_for_socials"))}</span><span class="flag"> (${ssrInterpolate(_ctx.$t("messages.sentence.create_automatically"))}) </span></div></div><div class="col-sm-6 col-12 mb-4"><div class="checkbox-container"><i class="ri-check-line"></i><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.add_to_sitemap"))}</span><span class="flag"> (${ssrInterpolate(_ctx.$t("messages.sentence.create_automatically"))}) </span></div></div><div class="col-sm-6 col-12 mb-4"><div class="checkbox-container"><i class="ri-check-line"></i><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.create_meta_tags"))}</span><span class="flag"> (${ssrInterpolate(_ctx.$t("messages.sentence.create_automatically"))}) </span></div></div></div></div><div class="tab-pane fade" id="v-pills-images" role="tabpanel" aria-labelledby="v-pills-images-tab" tabindex="0"><div class="row image-container"><div class="col-12 mb-4"><div class="form-label fw-bold lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.product_image_gallery"))}</div><span class="lts-05 text-gray fs-8">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_880202"))}</span></div><!--[-->`);
      ssrRenderList(imagesUrls.value, (imagesUrl, index) => {
        _push(`<div class="col-xl-3 col-lg-3 col-md-4 col-sm-6 col-12 mb-4"><div class="image-grid"><div class="image-grid--level-one"><div class="image-grid--level-two"><div class="image" style="${ssrRenderStyle("background-image: url(" + imagesUrl + ")")}"></div></div></div><i class="remove-image ri-close-line"></i></div></div>`);
      });
      _push(`<!--]--><div class="col-xl-3 col-lg-3 col-md-4 col-sm-6 col-12 mb-4"><div data-bs-toggle="modal" data-bs-target="#mediaLibrary" data-bs-input="product" class="image-grid select-image"><div class="image-grid--level-one"><div class="image-grid--level-two"><div class="select-image-details"><i class="ri-image-add-line"></i><span class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.add_image"))}</span></div></div></div></div></div><div class="col-12 mb-4"><div class="border"></div></div><div class="col-12"><div class="form-label fw-bold mb-4 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.product_preview_video"))}</div></div><div class="col-12 mb-4"><label for="eaCategories" class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.video_type"))}</label>`);
      _push(ssrRenderComponent(unref(Dropdown), {
        class: "pvc-multiselect pvc-multiselect-filter",
        modelValue: unref(createProductForm).videos.type,
        "onUpdate:modelValue": ($event) => unref(createProductForm).videos.type = $event,
        options: _ctx.videoTypeList,
        emptyFilterMessage: _ctx.$t("messages.sentence.no_items_found"),
        display: "chip",
        optionValue: "id",
        optionLabel: "label",
        placeholder: _ctx.$t("messages.sentence.select_video_type")
      }, null, _parent));
      _push(`</div>`);
      if (unref(createProductForm).videos.type == "url") {
        _push(`<div class="col-12 mb-4"><label for="eaVideoLink" class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.video_link"))}: </label><input${ssrRenderAttr("value", unref(createProductForm).videos.link)} type="text" name="video"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.allowed_format") + ": mp4")} class="form-control" id="eaVideoLink"><span class="form-control-description">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_125485"))}</span></div>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(createProductForm).videos.type == "aparat") {
        _push(`<div class="col-12 mb-4"><label for="eaVideoEmbed" class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.aparat_iframe_code"))}: </label><textarea type="text" name="video"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.enter_aparat_iframe_code"))} class="form-control" id="eaVideoEmbed">${ssrInterpolate(unref(createProductForm).videos.embed)}</textarea><span class="form-control-description">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_635985"))}</span></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="col-12 mb-4"><div class="border"></div></div><div class="col-12 mb-4"><label for="eaVideoLink" class="form-label fw-bold lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.model_3d_link"))}</label><input${ssrRenderAttr("value", unref(createProductForm).model_3d)} type="text" name="model_3d"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.allowed_format") + ": .glb")} class="form-control" id="eaVideoLink"><span class="form-control-description">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_511114"))}</span></div></div></div><div class="tab-pane fade" id="v-pills-specification" role="tabpanel" aria-labelledby="v-pills-specification-tab" tabindex="0"><div x-data="property()" class="property mb-4"><div class="tab-title lts-05 mb-4"><div>${ssrInterpolate(_ctx.$t("messages.sentence.outstanding_properties"))} <span class="mt-1">${ssrInterpolate(_ctx.$t("messages.sentence.enter_product_some_properties"))}</span></div><button type="button" class="btn btn-square btn-primary shadow-1"><i class="ri-add-line"></i></button></div><div id="propertyContainer" class="property-items"><!--[-->`);
      ssrRenderList(attrs, (attr, index) => {
        _push(`<div class="property-item mb-3"><div class="row"><div class="col-sm-6 col-12 mb-2"><label class="form-label">${ssrInterpolate(_ctx.$t("messages.word.title"))} <input${ssrRenderAttr("value", attr.key)} type="text" name="property[123456][key]" class="form-control"></label></div><div class="col-sm-6 col-12 mb-2"><label class="form-label">${ssrInterpolate(_ctx.$t("messages.word.value"))} <input${ssrRenderAttr("value", attr.value)} type="text" name="property[123456][value]" class="form-control"></label></div></div><i class="remove-property-item ri-close-line"></i></div>`);
      });
      _push(`<!--]--></div></div><div class="border mb-4"></div><div class="tab-title lts-05 mb-4"><div>${ssrInterpolate(_ctx.$t("messages.sentence.specifications_table"))} <span class="input-desc">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_478523"))}</span></div></div><div class="row specification"><div id="specificationContainer" class="col-12 specification-items"><!--[-->`);
      ssrRenderList(unref(specificationsGroups), (group, group_index) => {
        _push(`<div class="specification-item mb-3"><div class="tab-title mb-3">${ssrInterpolate(group.title)}</div><div class="sub"><!--[-->`);
        ssrRenderList(group.keys, (key, key_index) => {
          _push(`<div class="row sub-item mb-1"><div class="col-sm-6 col-12 d-flex align-items-center p-2 ps-3 mb-1 mb-md-0">${ssrInterpolate(key.key)}</div><div class="col-sm-6 col-12 p-0 ps-md-2"><input${ssrRenderAttr("value", key.value)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.specification_value"))} class="form-control"></div></div>`);
        });
        _push(`<!--]--></div></div>`);
      });
      _push(`<!--]--></div></div></div><div class="tab-pane fade" id="v-pills-guide" role="tabpanel" aria-labelledby="v-pills-guide-tab" tabindex="0"><div class="tab-title lts-05 mb-4"><div>${ssrInterpolate(_ctx.$t("messages.sentence.product_guide"))} <span class="input-desc">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_010201"))}</span></div></div><div class="row"><div class="col-12 mb-4">`);
      _push(ssrRenderComponent(_sfc_main$4, {
        modelValue: unref(createProductForm).guide,
        "onUpdate:modelValue": ($event) => unref(createProductForm).guide = $event
      }, null, _parent));
      _push(`</div></div></div><div class="tab-pane fade" id="v-pills-tabs" role="tabpanel" aria-labelledby="v-pills-tabs-tab" tabindex="0"><div class="tab-title lts-05 mb-4"><div>${ssrInterpolate(_ctx.$t("messages.sentence.product_tabs"))} <span class="input-desc">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_011025"))}</span></div></div><div class="row"><div class="col-12 mb-4"><button type="button" class="btn btn-primary btn-square btn-sm"><i class="ri-add-line"></i></button></div></div><!--[-->`);
      ssrRenderList(productTabs, (tab, index) => {
        _push(`<div class="bg-light p-4 br-15 mb-3" style="${ssrRenderStyle({ "position": "relative" })}"><span style="${ssrRenderStyle({ "position": "absolute", "left": "25px" })}" class="clickable"><i class="ri-close-line"></i></span><div class="row"><div class="col-sm-6 col-12 mb-4"><label${ssrRenderAttr("for", "ea-" + index)} class="form-label">${ssrInterpolate(_ctx.$t("messages.word.title"))}</label><input${ssrRenderAttr("value", tab.title)} type="text" class="form-control"${ssrRenderAttr("id", "ea-" + index)}></div><div class="col-12">`);
        _push(ssrRenderComponent(_sfc_main$4, {
          modelValue: tab.content,
          "onUpdate:modelValue": ($event) => tab.content = $event
        }, null, _parent));
        _push(`</div></div></div>`);
      });
      _push(`<!--]--></div><div class="tab-pane fade" id="v-pills-price" role="tabpanel" aria-labelledby="v-pills-price-tab" tabindex="0"><div class="col-12 mb-4"><div class="product-inventory-model"><div class="title lts-05 mb-1">${ssrInterpolate(_ctx.$t("messages.sentence.determine_sale_model"))}</div><div class="text-info fs-8 lts-05 mb-3">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_256632"))}</div><div class="row"><div class="col-md-6 col-12 mb-2"><div class="${ssrRenderClass({ "product-inventory-model--options": true, active: unref(createProductForm).in_stock_status })}"><label><i class="ri-check-line"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.sale_online_in_shop"))}</label></div></div><div class="col-md-6 col-12 mb-2"><div class="${ssrRenderClass({ "product-inventory-model--options": true, active: !unref(createProductForm).in_stock_status })}"><label><i class="ri-check-line"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.inventory_inquiry_and_phone_order_registration"))}</label></div></div>`);
      if (!unref(createProductForm).in_stock_status) {
        _push(`<div class="col-12 mt-3"><div class="product-inventory-model--forms"><div class="row"><div class="col-sm-6 col-12 mb-2"><label for="eaLandlinePhone" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.static_phone"))}</label><input${ssrRenderAttr("value", unref(createProductForm).inquiry_options.landline_phone)} type="text" class="form-control" id="eaLandlinePhone"></div><div class="col-sm-6 col-12 mb-2"><label for="eaCellularPhone" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.phone"))}</label><input${ssrRenderAttr("value", unref(createProductForm).inquiry_options.cellular_phone)} type="text" class="form-control" id="eaCellularPhone"></div></div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div></div><div class="col-12 mb-4"><div class="product-price-model"><div class="title lts-05 mb-1">${ssrInterpolate(_ctx.$t("messages.sentence.determine_sale_variables"))}</div><div class="text-warning lts-05 mb-3">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_445872"))}</div><ul><!--[-->`);
      ssrRenderList(unref(priceModel), (pm, index) => {
        _push(`<li class="shadow-1">`);
        if (pm.type == "warranty") {
          _push(`<div class="form-check form-switch"><label class="form-check-label lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.has_warranty"))} <input${ssrIncludeBooleanAttr(Array.isArray(pm.active) ? ssrLooseContain(pm.active, null) : pm.active) ? " checked" : ""} class="form-check-input" name="gtjfdbasvasdb" type="checkbox" role="switch"></label></div>`);
        } else if (pm.type == "color") {
          _push(`<div class="form-check form-switch"><label class="form-check-label lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.with_coloring"))} <input${ssrIncludeBooleanAttr(Array.isArray(pm.active) ? ssrLooseContain(pm.active, null) : pm.active) ? " checked" : ""} class="form-check-input" name="fdnwegvaqwvas" type="checkbox" role="switch"></label></div>`);
        } else {
          _push(`<div class="form-control-container"><input${ssrRenderAttr("value", pm.name)} class="form-control" type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.sale_variable_name"))}><i class="ri-close-line remove"></i></div>`);
        }
        _push(`</li>`);
      });
      _push(`<!--]--><li class="add-item-container"><button${ssrRenderAttrs(mergeProps({
        class: "btn btn-square btn-xs btn-primary shadow-2",
        type: "button"
      }, ssrGetDirectiveProps(_ctx, _directive_tooltip, _ctx.$t("messages.sentence.add_sale_variable"), void 0, { top: true })))}><i class="ri-add-line"></i></button></li></ul></div></div><div class="col-12 mb-1"><div class="form-element-row"><label for="eaCommission" class="form-label fs-8">${ssrInterpolate(_ctx.$t("messages.sentence.product_comission_for_seller"))}: ${ssrInterpolate(unref(createProductForm).commission)}%</label><input${ssrRenderAttr("value", unref(createProductForm).commission)} id="eaCommission" type="range" class="form-range" min="0" max="100" step="0.1"></div></div><div class="col-12 mb-5"><span class="text-gray fs-9 fw-light lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_881125"))}</span></div><div class="price-list"><p class="description lts-05 mb-2"><span class="fw-bold">${ssrInterpolate(_ctx.$t("messages.word.attention"))}:</span></p><ul class="list-description d-block mb-3"><li class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_889635"))}</li><li class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_881452"))}</li><li class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_889856"))}</li><li class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_881986"))}</li></ul></div></div></div></div><div class="action-container d-md-none d-block mt-4"><div class="form-check form-switch mb-3"><label class="form-check-label lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.vip_product"))}؟ <input${ssrIncludeBooleanAttr(Array.isArray(unref(createProductForm).is_vip) ? ssrLooseContain(unref(createProductForm).is_vip, null) : unref(createProductForm).is_vip) ? " checked" : ""} class="form-check-input" name="fngmfdnhwdbds" type="checkbox" role="switch"></label></div><div class="form-check form-switch mb-3"><label class="form-check-label lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.show_questions"))} <input${ssrIncludeBooleanAttr(Array.isArray(unref(createProductForm).question_status) ? ssrLooseContain(unref(createProductForm).question_status, null) : unref(createProductForm).question_status) ? " checked" : ""} class="form-check-input" name="dfnsdnbasdb" type="checkbox" role="switch" checked></label></div><div class="form-check form-switch mb-4"><label class="form-check-label lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.show_comments"))} <input${ssrIncludeBooleanAttr(Array.isArray(unref(createProductForm).comment_status) ? ssrLooseContain(unref(createProductForm).comment_status, null) : unref(createProductForm).comment_status) ? " checked" : ""} class="form-check-input" name="fnebagvaqbhdfn" type="checkbox" role="switch" checked></label></div><label class="form-label lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.product_status"))}: </label>`);
      _push(ssrRenderComponent(unref(Dropdown), {
        class: "pvc-dropdown",
        modelValue: unref(createProductForm).status,
        "onUpdate:modelValue": ($event) => unref(createProductForm).status = $event,
        options: _ctx.statusList,
        display: "chip",
        optionLabel: "label",
        optionValue: "id",
        placeholder: _ctx.$t("messages.sentence.select_status")
      }, null, _parent));
      _push(`<button${ssrIncludeBooleanAttr(unref(createProductForm).processing) ? " disabled" : ""} class="btn btn-primary mt-3">${ssrInterpolate(_ctx.$t("messages.sentence.create_product"))}</button></div></div></div></form></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Admin/Products/Products/Create.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
