import { defineComponent, ref, inject, watch, unref, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderAttr, ssrIncludeBooleanAttr } from "vue/server-renderer";
import { _ as _sfc_main$1, a as _sfc_main$2 } from "./StoreLayout-D2_RagXW.js";
import { useForm, Head } from "@inertiajs/vue3";
import Dropdown from "primevue/dropdown/dropdown.esm.js";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
import "jquery";
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
import "./Pagination-C1AQrLe3.js";
import "./SearchList-BZnYMQPN.js";
import "lodash/debounce.js";
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "./useRandomNum-DNNSqR7b.js";
import "bootstrap";
import "./useNl2br-BIw8h5gy.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "Create",
  __ssrInlineRender: true,
  props: {
    priorityList: {}
  },
  setup(__props) {
    const imageUrl = ref();
    const createTicketForm = useForm({
      title: null,
      priority: "normal",
      content: null,
      attachment: ""
    });
    const mediaReactive = inject("mediaData");
    watch(mediaReactive, (media) => {
      if (media.type == "attachment" && media.file != null) {
        imageUrl.value = media.file.url;
        createTicketForm.attachment = media.file.id + "";
      }
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.create_ticket")
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.sentence.create_ticket")
      }, null, _parent));
      _push(`<div class="create-ticket mb-4"><div class="card"><div class="card-body"><form class="add-ticket-form"><div class="row"><div class="col-md-6"><div class="form-element-row mb-4"><label class="form-label">${ssrInterpolate(_ctx.$t("messages.word.title"))}</label><input${ssrRenderAttr("value", unref(createTicketForm).title)} type="text" class="form-control"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.ticket_title"))}></div></div><div class="col-md-6"><div class="form-element-row mb-4"><label class="form-label">${ssrInterpolate(_ctx.$t("messages.word.priority"))}</label>`);
      _push(ssrRenderComponent(unref(Dropdown), {
        modelValue: unref(createTicketForm).priority,
        "onUpdate:modelValue": ($event) => unref(createTicketForm).priority = $event,
        options: _ctx.priorityList,
        optionLabel: "label",
        optionValue: "id",
        type: "text",
        readonly: "",
        class: "pvc-dropdown"
      }, null, _parent));
      _push(`</div></div></div><div class="row"><div class="col-12"><div class="form-element-row mb-4"><label class="form-label">${ssrInterpolate(_ctx.$t("messages.word.message"))}</label><textarea rows="5" class="form-control" placeholder="متن پیام">${ssrInterpolate(unref(createTicketForm).content)}</textarea></div></div><div class="col-12"><div class="form-element-row form-element-row-file mb-4"><div class="text-center"><div class="fs-6 fw-bold text-dark mb-2">${ssrInterpolate(_ctx.$t("messages.sentence.upload_your_image_as_attachment_to_ticket"))}</div><div class="fs-9 text-muted mb-4">(${ssrInterpolate(_ctx.$t("messages.sentence.ticket_attachment_hint"))})</div></div>`);
      if (unref(createTicketForm).attachment != "") {
        _push(`<div class="selected-image"><img class="shadow-1"${ssrRenderAttr("src", imageUrl.value)}><i class="ri-close-line shadow-1 remove-image"></i></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="custom-input-file"><label data-bs-toggle="modal" data-bs-target="#mediaLibrary" data-bs-input="attachment" for="attachment" class="custom-input-file-label"><span class="label"><i class="ri-arrow-up-fill me-1"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.select_image"))}</span></label></div></div></div><div class="col-12 text-end"><button type="submit"${ssrIncludeBooleanAttr(unref(createTicketForm).processing) ? " disabled" : ""} class="btn btn-primary shadow-1 px-4">${ssrInterpolate(_ctx.$t("messages.word.send"))} <i class="ri-send-plane-2-line ms-2"></i></button></div></div></form></div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Store/Tickets/Create.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
