import { defineComponent, ref, reactive, inject, watch, resolveDirective, unref, withCtx, createVNode, createBlock, openBlock, toDisplayString, mergeProps, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderList, ssrRenderStyle, ssrRenderAttr, ssrRenderAttrs, ssrGetDirectiveProps } from "vue/server-renderer";
import { _ as _sfc_main$1 } from "./AdminLayout-CD07IMsK.js";
import { useForm, Head } from "@inertiajs/vue3";
import Dropdown from "primevue/dropdown/dropdown.esm.js";
import { _ as _sfc_main$3 } from "./FormatedNumInput-D4wHj270.js";
import { _ as _sfc_main$2 } from "./Files-B6eiTnN6.js";
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
import "./useRandomStr-4MeWbtRd.js";
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "laravel-vue-i18n";
import "./Pagination-C1AQrLe3.js";
import "./SearchList-BZnYMQPN.js";
import "lodash/debounce.js";
import "./useRandomNum-DNNSqR7b.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "Create",
  __ssrInlineRender: true,
  props: {
    product: {},
    storages: {},
    colors: {},
    originalList: {},
    usedList: {},
    storage: {},
    storage_uuid: {}
  },
  setup(__props) {
    const props = __props;
    const colorItems = ref([]);
    for (let color in props.colors) {
      colorItems.value.push({ id: props.colors[color].id, label: props.colors[color].label, color: props.colors[color].color, image: props.colors[color].image });
    }
    const discountTree = reactive([]);
    const productProps = reactive(props.product.price_model);
    const inventoryImageUrl = ref(null);
    const inventoryImageId = ref(null);
    const mediaReactive = inject("mediaData");
    watch(mediaReactive, (media) => {
      if (media.type == "inventory" && media.file != null) {
        inventoryImageId.value = media.file.id;
        inventoryImageUrl.value = media.file.url;
      }
    });
    const addPriceForm = useForm({
      stg: props.storage_uuid,
      storage: props.storage != void 0 ? props.storage : null,
      props: productProps,
      price: null,
      discount_price: null,
      discount_expire: null,
      count: null,
      min_sale: null,
      max_sale: null,
      original: true,
      used: false,
      weight: null,
      purchase_price: null,
      image: null,
      description: null,
      send_time: null,
      discount_tree: discountTree
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _directive_tooltip = resolveDirective("tooltip");
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.add_inventory")
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.sentence.add_inventory"),
        item: _ctx.$t("messages.word.storages")
      }, null, _parent));
      _push(`<div class="product-list prices-section manage-inventory list mb-4"><div class="card"><div class="card-body"><div class="col-12 mb-3"><span class="badge bg-danger fs-10 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_599652"))}</span><span class="badge bg-info fs-10 lts-05 ms-1">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_322558"))}</span></div><div class="col-12 dynamic-container mt-2"><div class="price-items"><form><div class="price-item"><div class="row"><div class="col-lg-4 col-md-6 col-12 mb-3"><label class="form-label lts-05 required">${ssrInterpolate(_ctx.$t("messages.sentence.select_storage"))}</label>`);
      _push(ssrRenderComponent(unref(Dropdown), {
        modelValue: unref(addPriceForm).storage,
        "onUpdate:modelValue": ($event) => unref(addPriceForm).storage = $event,
        options: _ctx.storages,
        disabled: _ctx.storage != void 0 && _ctx.storage != null,
        optionLabel: "name",
        optionValue: "id",
        placeholder: _ctx.$t("messages.sentence.select_the_storage"),
        type: "text",
        readonly: "",
        class: "pvc-dropdown"
      }, null, _parent));
      _push(`</div><!--[-->`);
      ssrRenderList(productProps, (pm, index) => {
        _push(`<!--[-->`);
        if (pm.type == "color") {
          _push(`<div class="col-lg-4 col-md-6 col-12 mb-3"><label class="form-label lts-05 required">${ssrInterpolate(_ctx.$t("messages.sentence.choose_color"))}</label>`);
          _push(ssrRenderComponent(unref(Dropdown), {
            class: "pvc-dropdown",
            modelValue: pm.value,
            "onUpdate:modelValue": ($event) => pm.value = $event,
            options: colorItems.value,
            optionLabel: "label",
            placeholder: _ctx.$t("messages.sentence.choose_color")
          }, {
            value: withCtx((slotProps, _push2, _parent2, _scopeId) => {
              if (_push2) {
                if (slotProps.value) {
                  _push2(`<div class="d-flex align-items-center"${_scopeId}>`);
                  if (slotProps.value["image"] != null) {
                    _push2(`<span class="dropdown-color-item shadow-2 color-box add-image" style="${ssrRenderStyle({ "width": "16px", "height": "16px", "border-radius": "6px" })}"${_scopeId}><img${ssrRenderAttr("src", slotProps.value["image"])} alt="رنگ"${_scopeId}></span>`);
                  } else {
                    _push2(`<span class="dropdown-color-item shadow-1" style="${ssrRenderStyle({
                      "background-color": slotProps.value.color,
                      border: slotProps.value.color.includes("#ffffff") ? "solid 1px #dddddd" : ""
                    })}"${_scopeId}></span>`);
                  }
                  _push2(`<div class="dropdown-cutom-item-text"${_scopeId}>${ssrInterpolate(slotProps.value.label)}</div></div>`);
                } else {
                  _push2(`<span${_scopeId}>${ssrInterpolate(slotProps.placeholder)}</span>`);
                }
              } else {
                return [
                  slotProps.value ? (openBlock(), createBlock("div", {
                    key: 0,
                    class: "d-flex align-items-center"
                  }, [
                    slotProps.value["image"] != null ? (openBlock(), createBlock("span", {
                      key: 0,
                      class: "dropdown-color-item shadow-2 color-box add-image",
                      style: { "width": "16px", "height": "16px", "border-radius": "6px" }
                    }, [
                      createVNode("img", {
                        src: slotProps.value["image"],
                        alt: "رنگ"
                      }, null, 8, ["src"])
                    ])) : (openBlock(), createBlock("span", {
                      key: 1,
                      class: "dropdown-color-item shadow-1",
                      style: {
                        "background-color": slotProps.value.color,
                        border: slotProps.value.color.includes("#ffffff") ? "solid 1px #dddddd" : ""
                      }
                    }, null, 4)),
                    createVNode("div", { class: "dropdown-cutom-item-text" }, toDisplayString(slotProps.value.label), 1)
                  ])) : (openBlock(), createBlock("span", { key: 1 }, toDisplayString(slotProps.placeholder), 1))
                ];
              }
            }),
            option: withCtx((slotProps, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<div class="d-flex align-items-center"${_scopeId}>`);
                if (slotProps.option["image"] != null) {
                  _push2(`<span class="dropdown-color-item shadow-2 color-box add-image" style="${ssrRenderStyle({ "width": "16px", "height": "16px", "border-radius": "6px" })}"${_scopeId}><img${ssrRenderAttr("src", slotProps.option["image"])} alt="رنگ"${_scopeId}></span>`);
                } else {
                  _push2(`<span class="dropdown-color-item shadow-1" style="${ssrRenderStyle({
                    "background-color": slotProps.option.color,
                    border: slotProps.option.color.includes("#ffffff") ? "solid 1px #dddddd" : ""
                  })}"${_scopeId}></span>`);
                }
                _push2(`<div class="dropdown-cutom-item-text"${_scopeId}>${ssrInterpolate(slotProps.option.label)}</div></div>`);
              } else {
                return [
                  createVNode("div", { class: "d-flex align-items-center" }, [
                    slotProps.option["image"] != null ? (openBlock(), createBlock("span", {
                      key: 0,
                      class: "dropdown-color-item shadow-2 color-box add-image",
                      style: { "width": "16px", "height": "16px", "border-radius": "6px" }
                    }, [
                      createVNode("img", {
                        src: slotProps.option["image"],
                        alt: "رنگ"
                      }, null, 8, ["src"])
                    ])) : (openBlock(), createBlock("span", {
                      key: 1,
                      class: "dropdown-color-item shadow-1",
                      style: {
                        "background-color": slotProps.option.color,
                        border: slotProps.option.color.includes("#ffffff") ? "solid 1px #dddddd" : ""
                      }
                    }, null, 4)),
                    createVNode("div", { class: "dropdown-cutom-item-text" }, toDisplayString(slotProps.option.label), 1)
                  ])
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(`</div>`);
        } else {
          _push(`<!---->`);
        }
        if (pm.type == "warranty") {
          _push(`<div class="col-lg-4 col-md-6 col-12 mb-3"><label${ssrRenderAttr("for", "fm" + index)} class="form-label">${ssrInterpolate(pm.name)}</label><input${ssrRenderAttr("value", pm.value)}${ssrRenderAttr("id", "fm" + index)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.default_warranty_content"))} class="form-control"></div>`);
        } else {
          _push(`<!---->`);
        }
        if (pm.type == "text") {
          _push(`<div class="col-lg-4 col-md-6 col-12 mb-3"><label${ssrRenderAttr("for", "fm" + index)} class="form-label required">${ssrInterpolate(pm.name)}</label><input${ssrRenderAttr("value", pm.value)}${ssrRenderAttr("id", "fm" + index)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.sale_variable_value"))} class="form-control"></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<!--]-->`);
      });
      _push(`<!--]--><div class="col-lg-4 col-md-6 col-12 mb-3"><label for="fmPrice" class="form-label required">${ssrInterpolate(_ctx.$t("messages.sentence.product_price"))} <span class="currency mb-0">${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span></label>`);
      _push(ssrRenderComponent(_sfc_main$3, {
        modelValue: unref(addPriceForm).price,
        "onUpdate:modelValue": ($event) => unref(addPriceForm).price = $event,
        id: "fmPrice",
        type: "text",
        placeholder: _ctx.$t("messages.sentence.unit_price_of_each_piece"),
        class: "form-control"
      }, null, _parent));
      _push(`</div><div class="col-lg-4 col-md-6 col-12 mb-3"><label class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.discount_price"))} <span class="currency mb-0">${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span>`);
      _push(ssrRenderComponent(_sfc_main$3, {
        modelValue: unref(addPriceForm).discount_price,
        "onUpdate:modelValue": ($event) => unref(addPriceForm).discount_price = $event,
        type: "text",
        placeholder: _ctx.$t("messages.sentence.unit_discount_price_of_each_piece"),
        class: "form-control"
      }, null, _parent));
      _push(`</label></div><div class="col-lg-4 col-md-6 col-12 mb-3"><label class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.discount_expire"))} <input${ssrRenderAttr("value", unref(addPriceForm).discount_expire)}${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.click_for_choose"))} type="text" readonly class="form-control" data-jdp></label></div><div class="col-lg-4 col-md-6 col-12 mb-3"><label for="fmCount" class="form-label required">${ssrInterpolate(_ctx.$t("messages.sentence.inventory_count"))}</label>`);
      _push(ssrRenderComponent(_sfc_main$3, {
        modelValue: unref(addPriceForm).count,
        "onUpdate:modelValue": ($event) => unref(addPriceForm).count = $event,
        id: "fmCount",
        type: "text",
        placeholder: _ctx.$t("messages.sentence.inventory_count"),
        class: "form-control"
      }, null, _parent));
      _push(`</div><div class="col-lg-4 col-md-6 col-12 mb-3"><label class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.min_sale"))} `);
      _push(ssrRenderComponent(_sfc_main$3, {
        modelValue: unref(addPriceForm).min_sale,
        "onUpdate:modelValue": ($event) => unref(addPriceForm).min_sale = $event,
        type: "text",
        placeholder: _ctx.$t("messages.sentence.min_sale_allowed"),
        class: "form-control"
      }, null, _parent));
      _push(`</label></div><div class="col-lg-4 col-md-6 col-12 mb-3"><label class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.max_sale"))} `);
      _push(ssrRenderComponent(_sfc_main$3, {
        modelValue: unref(addPriceForm).max_sale,
        "onUpdate:modelValue": ($event) => unref(addPriceForm).max_sale = $event,
        type: "text",
        placeholder: _ctx.$t("messages.sentence.max_sale_allowed"),
        class: "form-control",
        id: "eaMainMaximumOrder"
      }, null, _parent));
      _push(`</label></div><div class="col-lg-4 col-md-6 col-12 mb-3"><label class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.product_weight"))} <span class="currency">${ssrInterpolate(_ctx.$t("messages.word.gram"))}</span>`);
      _push(ssrRenderComponent(_sfc_main$3, {
        modelValue: unref(addPriceForm).weight,
        "onUpdate:modelValue": ($event) => unref(addPriceForm).weight = $event,
        type: "text",
        placeholder: _ctx.$t("messages.sentence.product_weight_in_gram"),
        class: "form-control",
        id: "eaMainMaximumOrder"
      }, null, _parent));
      _push(`</label></div><div class="col-lg-4 col-md-6 col-12 mb-3"><label class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.send_time"))} <input${ssrRenderAttr("value", unref(addPriceForm).send_time)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.send_time_placeholder"))} class="form-control" id="eaSendTime"></label></div><div class="col-lg-4 col-md-6 col-12 mb-3"><label for="fmPrice" class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.purchase_price"))} <span class="fs-10 text-gray">${ssrInterpolate(_ctx.$t("messages.word.optional"))}</span><span class="currency mb-0">${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span></label>`);
      _push(ssrRenderComponent(_sfc_main$3, {
        modelValue: unref(addPriceForm).purchase_price,
        "onUpdate:modelValue": ($event) => unref(addPriceForm).purchase_price = $event,
        id: "fmPrice",
        type: "text",
        placeholder: _ctx.$t("messages.sentence.unit_price_of_each_piece"),
        class: "form-control"
      }, null, _parent));
      _push(`<span class="input-desc lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_54002102"))}</span></div><div class="col-lg-4 col-md-6 col-12 mb-3"><label class="form-label lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.product_original_type"))}: </label>`);
      _push(ssrRenderComponent(unref(Dropdown), {
        class: "pvc-dropdown",
        modelValue: unref(addPriceForm).original,
        "onUpdate:modelValue": ($event) => unref(addPriceForm).original = $event,
        options: _ctx.originalList,
        display: "chip",
        optionLabel: "label",
        optionValue: "id"
      }, null, _parent));
      _push(`</div><div class="col-lg-4 col-md-6 col-12 mb-3"><label class="form-label lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.product_used_type"))}: </label>`);
      _push(ssrRenderComponent(unref(Dropdown), {
        class: "pvc-dropdown",
        modelValue: unref(addPriceForm).used,
        "onUpdate:modelValue": ($event) => unref(addPriceForm).used = $event,
        options: _ctx.usedList,
        display: "chip",
        optionLabel: "label",
        optionValue: "id"
      }, null, _parent));
      _push(`</div><div class="col-12 mb-4"><label class="form-label lts-05" for="eaDescrition">${ssrInterpolate(_ctx.$t("messages.word.description"))}: </label><textarea id="eaDescrition" class="form-control lh-25" rows="3"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.msg_id_540101203"))}>${ssrInterpolate(unref(addPriceForm).description)}</textarea><span class="form-control-description lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_54002102"))}</span></div><div class="col-12 mb-4"><label class="form-label lts-05 mb-3">${ssrInterpolate(_ctx.$t("messages.sentence.inventory_image"))}</label>`);
      if (inventoryImageUrl.value != null && inventoryImageId.value != null) {
        _push(`<div class="image-grid"><div class="image-grid--level-one"><div class="image-grid--level-two"><div class="image" style="${ssrRenderStyle("background-image: url(" + inventoryImageUrl.value + ")")}"></div></div></div><i class="remove-image ri-close-line"></i></div>`);
      } else {
        _push(`<button${ssrRenderAttrs(mergeProps({
          "data-bs-toggle": "modal",
          "data-bs-target": "#mediaLibrary",
          "data-bs-input": "inventory",
          type: "button",
          class: "btn btn-square btn-primary btn-sm"
        }, ssrGetDirectiveProps(_ctx, _directive_tooltip, _ctx.$t("messages.word.add"), void 0, { left: true })))}><i class="ri-add-line"></i></button>`);
      }
      _push(`</div><div class="col-12 mb-4 count-discount-container mb-3"><div class="count-discount"><div class="tab-title mb-3"><div><div class="d-flex align-items-center mb-1">${ssrInterpolate(_ctx.$t("messages.sentence.tiered_discount_according_to_quantity"))} <span class="ms-1 text-info">(${ssrInterpolate(_ctx.$t("messages.word.optional"))})</span></div><span class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_399852"))}</span></div></div><div class="sub"><!--[-->`);
      ssrRenderList(discountTree, (dt, dti) => {
        _push(`<div class="row mb-1"><div class="col-md-6 col-12 p-0 mb-1 mb-md-0">`);
        _push(ssrRenderComponent(_sfc_main$3, {
          modelValue: dt.count,
          "onUpdate:modelValue": ($event) => dt.count = $event,
          type: "text",
          placeholder: _ctx.$t("messages.word.count"),
          class: "form-control"
        }, null, _parent));
        _push(`</div><div class="col-md-6 col-12 p-0 ps-md-2">`);
        _push(ssrRenderComponent(_sfc_main$3, {
          modelValue: dt.price,
          "onUpdate:modelValue": ($event) => dt.price = $event,
          type: "text",
          placeholder: _ctx.$t("messages.sentence.unit_discount_price_of_each_piece") + " - " + _ctx.$t("messages.word.toman"),
          class: "form-control"
        }, null, _parent));
        _push(`</div><div class="col-12"><i class="remove-item ri-close-line"></i></div></div>`);
      });
      _push(`<!--]--></div><button type="button" class="btn d-none btn-xs btn-square btn-primary mt-2"><i class="ri-add-line"></i></button></div></div></div></div><div class="d-flex align-items-center justify-content-end mt-4"><button class="btn btn-sm btn-primary px-3 ms-2">${ssrInterpolate(_ctx.$t("messages.sentence.add_inventory"))}</button></div></form></div></div></div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Admin/Storage/Inventory/Create.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
