import { defineComponent, unref, withCtx, createVNode, createTextVNode, toDisplayString, useSSRContext } from "vue";
import { ssrRenderComponent, ssrRenderClass, ssrInterpolate, ssrRenderList, ssrRenderAttr, ssrRenderStyle } from "vue/server-renderer";
import { _ as _sfc_main$1 } from "./MainLayout-CahYFWjG.js";
import { Head, Link } from "@inertiajs/vue3";
import { u as useNumberFormat } from "../ssr.js";
/* empty css                       */
/* empty css                              */
/* empty css                           */
/* empty css             */
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
import "./AdminNavigation-BYBoZNuA.js";
import "./useHexToRgb-G7J9N7Ap.js";
import "./useRandomStr-4MeWbtRd.js";
import "jquery";
import "@vue/server-renderer";
import "@inertiajs/vue3/server";
import "ziggy-js";
import "laravel-vue-i18n";
import "axios";
import "lodash/debounce.js";
import "swiper/bundle";
import "swiper";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "Cart",
  __ssrInlineRender: true,
  props: {
    items: {},
    totalPrice: {},
    totalDiscount: {},
    totalFinalPrice: {},
    customerClubScore: {}
  },
  setup(__props) {
    const urlParams = new URLSearchParams(window.location.search);
    const statusType = urlParams.get("status");
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), null, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<meta name="robots" content="noindex, follow"${_scopeId}>`);
          } else {
            return [
              createVNode("meta", {
                name: "robots",
                content: "noindex, follow"
              })
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`<div class="container"><div class="row"><div class="${ssrRenderClass({ "col-xl-9 col-lg-8": _ctx.items.length > 0, "col-12": _ctx.items.length == 0, "mb-3": true })}">`);
      if (unref(statusType) == "error") {
        _push(`<div class="card shadow-1 d-flex flex-row align-items-center justify-content-between payment-status payment-unsuccessful clickable"><div class="card-body"><i class="ri-error-warning-fill"></i><span class="lts-05">${ssrInterpolate(_ctx.$t("messages.order_registeration_error_with_transaction"))}</span></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="card shadow-1 cart"><div class="card-body"><ul class="nav nav-tabs" role="tablist"><li class="nav-item" role="presentation"><button class="nav-link lts-05 active" id="cart-tab" data-bs-toggle="tab" data-bs-target="#cart-tab-pane" type="button" role="tab" aria-controls="cart-tab-pane" aria-selected="true">${ssrInterpolate(_ctx.$t("messages.word.cart"))} <span class="counter">${ssrInterpolate(_ctx.items.length)}</span></button></li></ul><div class="tab-content"><div class="tab-pane fade show active" id="cart-tab-pane" role="tabpanel" aria-labelledby="cart-tab" tabindex="0">`);
      if (_ctx.items.length > 0) {
        _push(`<!--[-->`);
        ssrRenderList(_ctx.items, (item) => {
          _push(`<div class="cart-item"><div class="cart-item--thumbnail">`);
          _push(ssrRenderComponent(unref(Link), {
            href: _ctx.route("main.products.show", item.product.slug)
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<img${ssrRenderAttr("src", item.product.get_images[0]["link"])}${ssrRenderAttr("alt", item.product.title)} loading="lazy"${_scopeId}>`);
              } else {
                return [
                  createVNode("img", {
                    src: item.product.get_images[0]["link"],
                    alt: item.product.title,
                    loading: "lazy"
                  }, null, 8, ["src", "alt"])
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(`</div><div class="cart-item--detail"><h2 class="cart-item--title mb-2">`);
          _push(ssrRenderComponent(unref(Link), {
            href: _ctx.route("main.products.show", item.product.slug)
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(item.product.title)}`);
              } else {
                return [
                  createTextVNode(toDisplayString(item.product.title), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(`</h2>`);
          if (item.get_props.length > 0) {
            _push(`<div class="cart-item--data"><ul><!--[-->`);
            ssrRenderList(item.get_props, (prop, i) => {
              _push(`<li>`);
              if (prop.type == "color") {
                _push(`<div class="cart-item--variant mb-2">`);
                if (prop.value["image"] != null) {
                  _push(`<span class="shadow-2 color-box add-image" style="${ssrRenderStyle({ "width": "20px", "height": "20px" })}"><img${ssrRenderAttr("src", prop.value["image"])} alt="رنگ"></span>`);
                } else {
                  _push(`<span class="color shadow-2" style="${ssrRenderStyle("background-color: " + prop.value["color"])}"></span>`);
                }
                _push(`<span class="color-name lts">${ssrInterpolate(prop.value["label"])}</span></div>`);
              } else {
                _push(`<!--[-->`);
                if (prop.type == "warranty") {
                  _push(`<i class="ri-shield-check-fill"></i>`);
                } else {
                  _push(`<i class="ri-focus-line"></i>`);
                }
                _push(`<span>${ssrInterpolate(prop.name + ": " + prop.value)}</span><!--]-->`);
              }
              _push(`</li>`);
            });
            _push(`<!--]--></ul></div>`);
          } else {
            _push(`<!---->`);
          }
          _push(`<div class="cart-item--data mb-4"><ul><li><i class="ri-store-2-line"></i>`);
          if (item.store != null) {
            _push(ssrRenderComponent(unref(Link), {
              class: "shop-name link lts-05",
              href: _ctx.route("main.stores.show", item.store.uuid)
            }, {
              default: withCtx((_, _push2, _parent2, _scopeId) => {
                if (_push2) {
                  _push2(`${ssrInterpolate(item.store.name)}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(item.store.name), 1)
                  ];
                }
              }),
              _: 2
            }, _parent));
          } else {
            _push(ssrRenderComponent(unref(Link), {
              class: "shop-name link lts-05",
              href: _ctx.route("index")
            }, {
              default: withCtx((_, _push2, _parent2, _scopeId) => {
                if (_push2) {
                  _push2(`${ssrInterpolate(_ctx.$page.props.appName)}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$page.props.appName), 1)
                  ];
                }
              }),
              _: 2
            }, _parent));
          }
          _push(`</li><li><i class="ri-checkbox-multiple-fill"></i><span>${ssrInterpolate(_ctx.$t("messages.sentence.available_in_stock"))}</span><span class="text-secondary mx-2">|</span>`);
          if (item.inventory.send_time != null && item.inventory.send_time != "") {
            _push(`<span class="table-flag lts-05 fs-9">${ssrInterpolate(item.inventory.send_time)}</span>`);
          } else {
            _push(`<span class="table-flag lts-05 fs-9">${ssrInterpolate(_ctx.$t("messages.sentence.ready_to_send"))}</span>`);
          }
          _push(`</li></ul></div><div class="cart-item--price--actions"><div class="cart-item--actions"><div class="num-block fa-num me-3"><div class="num-in"><span class="plus"></span><input${ssrRenderAttr("value", item.count)} type="text" class="in-num" name="count" autocomplete="off" readonly><span class="minus dis"></span></div></div><button class="btn btn-link btn-sm text-secondary"><i class="ri-delete-bin-5-line me-1"></i><span class="lts-05">${ssrInterpolate(_ctx.$t("messages.word.delete"))}</span></button></div><div class="cart-item--price fa-num">`);
          if (item.discount > 0) {
            _push(`<div class="cart-item--discount"><del>${ssrInterpolate(unref(useNumberFormat)(item.discount * item.count + item.price * item.count))}</del></div>`);
          } else {
            _push(`<!---->`);
          }
          _push(`<div class="cart-item--price-now"><span>${ssrInterpolate(unref(useNumberFormat)(item.price * item.count))}</span><span class="unit"></span></div></div></div></div></div>`);
        });
        _push(`<!--]-->`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.items.length == 0) {
        _push(`<div class="cart-empty"><div class="empty-content-icon"><img${ssrRenderAttr("src", _ctx.$page.props.appUrl + "/img/template/empty-basket.png")} style="${ssrRenderStyle({ "opacity": "0.8" })}"${ssrRenderAttr("alt", _ctx.$t("messages.word.empty"))} loading="lazy"></div><div class="empty-content-message text-center"><div class="fw-bold text-dark mb-2 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.your_cart_is_empty"))}</div><p class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.show_more_products_with_below_list"))}</p><div class="d-flex justify-content-center flex-wrap">`);
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("main.products.index", { discount: true }),
          class: "link lts-05 fw-normal border-bottom-0 m-2"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("messages.sentence.discounted_products"))}`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("messages.sentence.discounted_products")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("main.products.index", { most_sale: true }),
          class: "link lts-05 fw-normal border-bottom-0 m-2"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("messages.sentence.most_sale_products"))}`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("messages.sentence.most_sale_products")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div></div></div></div>`);
      if (_ctx.items.length > 0) {
        _push(`<div class="col-xl-3 col-lg-4 mb-3"><div class="cart-sidebar"><div class="card shadow-1 mb-3"><div class="card-body"><div class="checkout"><div class="checkout-row"><div class="checkout-row-label lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.ware_prices"))} (${ssrInterpolate(_ctx.items.length)})</div><div class="checkout-row-value lts-05"><span class="fs-6">${ssrInterpolate(unref(useNumberFormat)(_ctx.totalPrice))}</span><span class="unit unit-sm lts-05"></span></div></div><div class="checkout-row"><div class="checkout-row-label lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.ware_discounts"))}</div><div class="checkout-row-value lts-05"><span class="fs-6 text-danger">${ssrInterpolate(unref(useNumberFormat)(_ctx.totalDiscount))}</span><span class="unit-red unit-sm lts-05 text-danger"></span></div></div><div class="checkout-row"><div class="checkout-row-label lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.cart_total"))}</div><div class="checkout-row-value lts-05"><span class="fs-6">${ssrInterpolate(unref(useNumberFormat)(_ctx.totalFinalPrice))}</span><span class="unit unit-sm lts-05"></span></div></div><div class="checkout-row checkout-note lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_119963"))}</div><div class="checkout-row checkout-action">`);
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("cart.shiping"),
          class: "btn btn-block btn-primary lts-05"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("messages.sentence.continue_order"))}`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("messages.sentence.continue_order")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</div><div class="checkout-row checkout-footer"><div class="checkout-row-label lts-05"><span class="d-flex"><i class="ri-copper-coin-fill text-warning me-1"></i><span class="fs-7 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.customer_club_points"))}</span></span></div><div class="checkout-row-value--small lts-05"><span class="fw-bold">${ssrInterpolate(unref(useNumberFormat)(_ctx.customerClubScore))}</span> <span class="fs-8 text-gray">${ssrInterpolate(_ctx.$t("messages.word.score"))}</span></div></div></div></div></div>`);
        if (_ctx.$page.props.payment_meta.free_post_min_price > 0) {
          _push(`<div class="card shadow-1 mb-3"><div class="send-free card-body"><div class="title"><div class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.orders_free_send"))}</div><span class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.orders_above_price", { price: _ctx.$page.props.payment_meta.get_formatted_free_post_min_price }))}</span></div><i class="ri-truck-line"></i></div></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Main/Cart/Cart.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
