import { defineComponent, unref, withCtx, createTextVNode, toDisplayString, createVNode, useSSRContext } from "vue";
import { ssrRenderComponent, ssrRenderStyle, ssrInterpolate, ssrRenderList, ssrRenderAttr } from "vue/server-renderer";
import { _ as _sfc_main$1 } from "./AdminLayout-CD07IMsK.js";
import { Head, Link } from "@inertiajs/vue3";
import { _ as _sfc_main$4 } from "./Pagination-C1AQrLe3.js";
import { _ as _sfc_main$3 } from "./SearchList-BZnYMQPN.js";
import { _ as _sfc_main$2 } from "./Files-B6eiTnN6.js";
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
import "lodash/debounce.js";
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "laravel-vue-i18n";
import "./useRandomNum-DNNSqR7b.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "AwaitingStores",
  __ssrInlineRender: true,
  props: {
    stores: {},
    keyword: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.awaiting_stores")
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.sentence.awaiting_stores"),
        item: _ctx.$t("messages.word.stores")
      }, null, _parent));
      _push(`<div class="user-list list mb-4"><div class="card"><div class="card-body">`);
      _push(ssrRenderComponent(_sfc_main$3, {
        keyword: _ctx.keyword,
        placeholder: _ctx.$t("messages.sentence.store_title") + " ..."
      }, null, _parent));
      _push(`<div class="table-responsive mb-4"><table class="table" style="${ssrRenderStyle({ "min-width": "900px" })}"><thead><tr><th class="first-small">${ssrInterpolate(_ctx.$t("messages.word.logo"))}</th><th>${ssrInterpolate(_ctx.$t("messages.sentence.store_title"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.user"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.code"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.status"))}</th><th>${ssrInterpolate(_ctx.$t("messages.sentence.register_date"))}</th><th><i class="ri-settings-4-line"></i></th></tr></thead><tbody><!--[-->`);
      ssrRenderList(_ctx.stores.data, (store) => {
        _push(`<tr><td><img width="35" height="35" class="br-10 border-gray-2 shadow-1"${ssrRenderAttr("src", store.get_logo)}${ssrRenderAttr("alt", store.name)}></td><td>`);
        _push(ssrRenderComponent(unref(Link), {
          class: "link",
          target: "_blank",
          href: _ctx.route("admin.stores.show", store.uuid)
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(store.name)}`);
            } else {
              return [
                createTextVNode(toDisplayString(store.name), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</td><td>`);
        _push(ssrRenderComponent(unref(Link), {
          class: "link",
          href: _ctx.route("admin.users.show", store.user.id)
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(store.user.get_name)}`);
            } else {
              return [
                createTextVNode(toDisplayString(store.user.get_name), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</td><td>${ssrInterpolate(store.uuid)}</td><td>`);
        if (store.status == "active") {
          _push(`<span class="badge bg-success">${ssrInterpolate(_ctx.$t("messages.word.active"))}</span>`);
        } else if (store.status == "banned") {
          _push(`<span class="badge bg-danger">${ssrInterpolate(_ctx.$t("messages.word.banned"))}</span>`);
        } else {
          _push(`<span class="badge bg-info">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_verify"))}</span>`);
        }
        _push(`</td><td>${ssrInterpolate(store.jalali_created_at[0])}</td><td>`);
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("admin.stores.show", store.uuid),
          as: "button",
          class: "btn btn-light fs-8 lts-05"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<i class="ri-survey-line fs-8 me-2"${_scopeId}></i><span${_scopeId}>${ssrInterpolate(_ctx.$t("messages.sentence.check_and_confirm"))}</span>`);
            } else {
              return [
                createVNode("i", { class: "ri-survey-line fs-8 me-2" }),
                createVNode("span", null, toDisplayString(_ctx.$t("messages.sentence.check_and_confirm")), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</td></tr>`);
      });
      _push(`<!--]--></tbody></table></div>`);
      if (_ctx.stores.data.length == 0) {
        _push(`<div class="product-list-empty"><div class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(ssrRenderComponent(_sfc_main$4, {
        links: _ctx.stores.links
      }, null, _parent));
      _push(`</div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Admin/Stores/AwaitingStores.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
