import { defineComponent, resolveDirective, unref, withCtx, createTextVNode, toDisplayString, createVNode, mergeProps, useSSRContext } from "vue";
import { ssrRenderComponent, ssrRenderStyle, ssrInterpolate, ssrRenderList, ssrRenderAttr, ssrRenderAttrs, ssrGetDirectiveProps } from "vue/server-renderer";
import { _ as _sfc_main$1 } from "./AdminLayout-CD07IMsK.js";
import { useForm, Head, Link } from "@inertiajs/vue3";
import { _ as _sfc_main$4 } from "./Pagination-C1AQrLe3.js";
import { _ as _sfc_main$3 } from "./SearchList-BZnYMQPN.js";
import { _ as _sfc_main$2 } from "./Files-B6eiTnN6.js";
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
import "lodash/debounce.js";
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "laravel-vue-i18n";
import "./useRandomNum-DNNSqR7b.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "AwaitingProducts",
  __ssrInlineRender: true,
  props: {
    products: {},
    keyword: {}
  },
  setup(__props) {
    const addToAffiliateForm = useForm({
      bronze_commission: 0,
      silver_commission: 0,
      gold_commission: 0
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _directive_tooltip = resolveDirective("tooltip");
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.awaiting_products")
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.sentence.awaiting_products"),
        item: _ctx.$t("messages.word.stores")
      }, null, _parent));
      _push(`<div class="product-list list mb-4"><div class="card"><div class="card-body">`);
      _push(ssrRenderComponent(_sfc_main$3, {
        keyword: _ctx.keyword,
        placeholder: _ctx.$t("messages.sentence.product_title") + " ..."
      }, null, _parent));
      _push(`<div class="table-responsive mb-4"><table class="table" style="${ssrRenderStyle({ "min-width": "1100px" })}"><thead><tr><th class="first-small">${ssrInterpolate(_ctx.$t("messages.word.image"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.title"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.inventories"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.by"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.status"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.last_update"))}</th><th class="first-small"><i class="ri-settings-4-line"></i></th></tr></thead><tbody><!--[-->`);
      ssrRenderList(_ctx.products.data, (product) => {
        _push(`<tr><td><img class="br-10" width="35" height="35"${ssrRenderAttr("src", product.get_images[0]["link"])}${ssrRenderAttr("alt", product.get_images[0]["alt"])}></td><td${ssrRenderAttrs(ssrGetDirectiveProps(_ctx, _directive_tooltip, product.is_vip ? _ctx.$t("messages.sentence.vip_product") : null, void 0, { top: true }))}>`);
        _push(ssrRenderComponent(unref(Link), {
          class: "product-title product-title-min-300",
          href: _ctx.route("admin.products.edit", product.slug)
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(product.title)}`);
            } else {
              return [
                createTextVNode(toDisplayString(product.title), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        if (product.is_vip) {
          _push(`<i class="ri-star-s-fill vip-product"></i>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</td><td>`);
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("admin.inventories.index", product.slug),
          class: "link active-link lts-05"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("messages.sentence.manage_inventories"))}`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("messages.sentence.manage_inventories")), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</td><td>`);
        if (product.user.type == "owner" || product.user.type == "admin") {
          _push(ssrRenderComponent(unref(Link), {
            class: "link fs-8 fw-normal",
            href: _ctx.route("admin.users.show", product.user_id)
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(product.user.get_name)}`);
              } else {
                return [
                  createTextVNode(toDisplayString(product.user.get_name), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
        } else if (product.user.seller) {
          _push(ssrRenderComponent(unref(Link), {
            class: "link fs-8 fw-normal",
            href: _ctx.route("admin.stores.show", product.user.store.uuid)
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(product.user.store.name)}`);
              } else {
                return [
                  createTextVNode(toDisplayString(product.user.store.name), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
        } else {
          _push(`<!---->`);
        }
        _push(`</td><td class="lts-05">`);
        if (product.status == "publish") {
          _push(`<span class="badge bg-success">${ssrInterpolate(_ctx.$t("messages.word.published"))}</span>`);
        } else if (product.status == "draft") {
          _push(`<span class="badge bg-warning">${ssrInterpolate(_ctx.$t("messages.word.draft"))}</span>`);
        } else if (product.status == "awaiting") {
          _push(`<span class="badge bg-info">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_verify"))}</span>`);
        } else if (product.status == "rejected") {
          _push(`<span class="badge bg-danger">${ssrInterpolate(_ctx.$t("messages.word.rejected"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</td><td>${ssrInterpolate(product.jalali_updated_at[3])}</td><td class="dropdown"><i class="ri-more-2-fill" data-bs-toggle="dropdown"></i><div class="dropdown-menu shadow-smooth-2"><ul>`);
        if (product.status == "publish") {
          _push(`<li><a class="dropdown-item lts-05" target="_blank"${ssrRenderAttr("href", _ctx.route("main.products.show", product.slug))}><i class="ri-eye-line"></i> ${ssrInterpolate(_ctx.$t("messages.word.show"))}</a></li>`);
        } else {
          _push(`<!---->`);
        }
        if (product.status == "awaiting") {
          _push(`<li>`);
          _push(ssrRenderComponent(unref(Link), {
            href: _ctx.route("admin.products.edit", product.slug),
            as: "button",
            class: "dropdown-item lts-05"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<i class="ri-survey-line"${_scopeId}></i> ${ssrInterpolate(_ctx.$t("messages.sentence.check_and_confirm"))}`);
              } else {
                return [
                  createVNode("i", { class: "ri-survey-line" }),
                  createTextVNode(" " + toDisplayString(_ctx.$t("messages.sentence.check_and_confirm")), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(`</li>`);
        } else {
          _push(`<!---->`);
        }
        if (product.status == "publish" && _ctx.$page.props.auth.can["manage-affiliate"]) {
          _push(`<li><a class="dropdown-item lts-05" href="javascript:void(0)" data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#add-to-affiliate-" + product.id)}><i class="ri-user-voice-line"></i> ${ssrInterpolate(product.get_affiliate != null ? _ctx.$t("messages.sentence.edit_affiliate") : _ctx.$t("messages.sentence.add_to_affiliate"))}</a></li>`);
        } else {
          _push(`<!---->`);
        }
        if (product.status != "rejected") {
          _push(`<li>`);
          _push(ssrRenderComponent(unref(Link), {
            href: _ctx.route("admin.products.edit", product.slug),
            as: "button",
            class: "dropdown-item lts-05"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<i class="ri-pencil-line"${_scopeId}></i> ${ssrInterpolate(_ctx.$t("messages.word.edit"))}`);
              } else {
                return [
                  createVNode("i", { class: "ri-pencil-line" }),
                  createTextVNode(" " + toDisplayString(_ctx.$t("messages.word.edit")), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(`</li>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<li>`);
        if (product.status == "publish") {
          _push(ssrRenderComponent(unref(Link), {
            href: _ctx.route("admin.products.destroy", product.slug),
            method: "delete",
            as: "button",
            data: { status: "draft" },
            class: "dropdown-item no-btn"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<i class="ri-spam-3-line"${_scopeId}></i> ${ssrInterpolate(_ctx.$t("messages.sentence.unpublish"))}`);
              } else {
                return [
                  createVNode("i", { class: "ri-spam-3-line" }),
                  createTextVNode(" " + toDisplayString(_ctx.$t("messages.sentence.unpublish")), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
        } else if (product.status == "draft") {
          _push(ssrRenderComponent(unref(Link), {
            href: _ctx.route("admin.products.destroy", product.slug),
            method: "delete",
            as: "button",
            data: { status: "publish" },
            class: "dropdown-item no-btn"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<i class="ri-spam-3-line"${_scopeId}></i> ${ssrInterpolate(_ctx.$t("messages.word.publish"))}`);
              } else {
                return [
                  createVNode("i", { class: "ri-spam-3-line" }),
                  createTextVNode(" " + toDisplayString(_ctx.$t("messages.word.publish")), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
        } else {
          _push(`<!---->`);
        }
        _push(`</li><li><a href="javascript:void(0)" data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#product-statistics-" + product.id)} class="dropdown-item no-btn"><i class="ri-bar-chart-2-line"></i> ${ssrInterpolate(_ctx.$t("messages.word.statistics"))}</a></li><li><a href="javascript:void(0)" data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#remove-product-" + product.id)} class="dropdown-item no-btn"><i class="ri-delete-bin-line"></i> ${ssrInterpolate(_ctx.$t("messages.word.delete"))}</a></li></ul></div><div class="modal fade"${ssrRenderAttr("id", "add-to-affiliate-" + product.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><form style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.add_to_affiliate"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12 mb-4"><p class="alert alert-light fs-7 lh-25 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_897754"))}</p></div><div class="col-12 mb-4"><div class="form-element-row"><label for="eaBronzeCommision" class="form-label fs-8">${ssrInterpolate(_ctx.$t("messages.word.bronze"))}: ${ssrInterpolate(unref(addToAffiliateForm).bronze_commission)}% </label><input${ssrRenderAttr("value", unref(addToAffiliateForm).bronze_commission)} id="eaBronzeCommision" type="range" class="form-range" min="0" max="100" step="0.1"></div></div><div class="col-12 mb-4"><div class="form-element-row"><label for="eaSilverCommision" class="form-label fs-8">${ssrInterpolate(_ctx.$t("messages.word.silver"))}: ${ssrInterpolate(unref(addToAffiliateForm).silver_commission)}% </label><input${ssrRenderAttr("value", unref(addToAffiliateForm).silver_commission)} id="eaSilverCommision" type="range" class="form-range" min="0" max="100" step="0.1"></div></div><div class="col-12 mb-4"><div class="form-element-row"><label for="eaGoldCommision" class="form-label fs-8">${ssrInterpolate(_ctx.$t("messages.word.gold"))}: ${ssrInterpolate(unref(addToAffiliateForm).gold_commission)}% </label><input${ssrRenderAttr("value", unref(addToAffiliateForm).gold_commission)} id="eaGoldCommision" type="range" class="form-range" min="0" max="100" step="0.1"></div></div><div class="col-12 mb-4"><span class="text-gray fs-9 fw-light lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_881125"))}</span></div></div></div><div class="modal-footer">`);
        if (product.get_affiliate != null) {
          _push(ssrRenderComponent(unref(Link), {
            as: "button",
            href: _ctx.route("admin.affiliate.delete", product.slug),
            method: "delete",
            class: "btn btn-sm btn-danger px-3",
            "data-bs-dismiss": "modal",
            "aria-label": "Close"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(_ctx.$t("messages.word.delete"))}`);
              } else {
                return [
                  createTextVNode(toDisplayString(_ctx.$t("messages.word.delete")), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
        } else {
          _push(`<!---->`);
        }
        _push(`<button type="submit" class="btn btn-sm btn-primary px-3" data-bs-dismiss="modal" aria-label="Close">${ssrInterpolate(product.get_affiliate != null ? _ctx.$t("messages.word.edit") : _ctx.$t("messages.word.add"))}</button></div></form></div></div></div><div class="modal fade"${ssrRenderAttr("id", "product-statistics-" + product.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-lgs modal-dialog-centered"><div class="modal-content"><form style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.product_statistics"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12"><div class="table-responsive"><table class="table" style="${ssrRenderStyle({ "width": "100%", "min-width": "100%" })}"><tbody><tr><td class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.product_uuid"))}</td><td${ssrRenderAttrs(mergeProps({ class: "clickable" }, ssrGetDirectiveProps(_ctx, _directive_tooltip, _ctx.$t("messages.sentence.copy_product_uuid"), void 0, { top: true })))}>${ssrInterpolate(product.uuid)}</td></tr><tr><td>${ssrInterpolate(_ctx.$t("messages.word.view"))}</td><td>${ssrInterpolate(product.get_formatted_view_count)}</td></tr><tr><td class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.couments_count"))}</td><td>${ssrInterpolate(product.comments_info.count)}</td></tr><tr><td class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.review_rating"))}</td><td>${ssrInterpolate(product.comments_info.rating)} <span><i class="ri-star-s-fill p-0 text-yellow"></i></span></td></tr><tr><td class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.questions_count"))}</td><td>${ssrInterpolate(product.questions_info.count)}</td></tr><tr><td class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.answers_count"))}</td><td>${ssrInterpolate(product.answers_info.count)}</td></tr></tbody></table></div></div></div></div><div class="modal-footer"><button class="btn btn-primary" data-bs-dismiss="modal" aria-label="Close">${ssrInterpolate(_ctx.$t("messages.word.close"))}</button></div></form></div></div></div><div class="modal fade"${ssrRenderAttr("id", "remove-product-" + product.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><form style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.are_you_sure_delete_product"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-footer">`);
        _push(ssrRenderComponent(unref(Link), {
          as: "button",
          href: _ctx.route("admin.products.destroy", product.slug),
          method: "delete",
          data: { status: "deleted" },
          class: "btn btn-sm btn-danger px-3",
          "data-bs-dismiss": "modal",
          "aria-label": "Close"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("messages.word.delete"))}`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("messages.word.delete")), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</div></form></div></div></div></td></tr>`);
      });
      _push(`<!--]--></tbody></table></div>`);
      if (_ctx.products.data.length == 0) {
        _push(`<div class="product-list-empty"><div class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(ssrRenderComponent(_sfc_main$4, {
        links: _ctx.products.links
      }, null, _parent));
      _push(`</div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Admin/Stores/AwaitingProducts.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
