import { defineComponent, resolveDirective, unref, withCtx, createTextVNode, toDisplayString, mergeProps, useSSRContext } from "vue";
import { ssrRenderComponent, ssrRenderList, ssrRenderAttr, ssrInterpolate, ssrGetDirectiveProps, ssrRenderAttrs, ssrRenderStyle } from "vue/server-renderer";
import { _ as _sfc_main$2 } from "./Files-B6eiTnN6.js";
import { _ as _sfc_main$3 } from "./Pagination-C1AQrLe3.js";
import { _ as _sfc_main$1 } from "./AdminLayout-CD07IMsK.js";
import { Head, Link } from "@inertiajs/vue3";
import "toastify-js";
import "./useToastify-D_n0s7Uc.js";
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "laravel-vue-i18n";
import "./SearchList-BZnYMQPN.js";
import "lodash/debounce.js";
import "./useRandomNum-DNNSqR7b.js";
import "simplebar";
import "resize-observer-polyfill";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "AwaitingInventories",
  __ssrInlineRender: true,
  props: {
    inventories: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      const _directive_tooltip = resolveDirective("tooltip");
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.awaiting_inventories")
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.sentence.awaiting_inventories"),
        item: _ctx.$t("messages.word.stores")
      }, null, _parent));
      _push(`<div class="product-list prices-section list mb-4"><div class="card"><div class="card-body"><div class="col-12 dynamic-container mt-2"><div class="price-items"><div class="d-flex"><span class="alert alert-light lts-05 fs-8 lh-25"> موجودی های اضافه شده توسط فروشندگان تنها در ابتدای ایجاد نیازمند تایید مدیریت هستند و بعد از تایید در ویرایش های بعدی توسط فروشنده, بصورت فعال خواهند بود. در صورت نیاز بعدا از لیست موجودی های محصول مورد نظر میتوانید موجودی مورد نظر خود را غیرفعال یا حذف نمایید. </span></div><!--[-->`);
      ssrRenderList(_ctx.inventories.data, (inventory, index) => {
        _push(`<div class="price-item pt-3 mb-4"><div class="row"><div class="col-12 store-details mb-3"><div class="d-flex align-items-center justify-content-between flex-column flex-sm-row pb-3 border-bottom"><div class="store-right d-flex align-items-center">`);
        if (inventory.store_id == null) {
          _push(`<div class="seller-avatar shadow-1">`);
          if (_ctx.$page.props.appFavicon != null) {
            _push(`<img${ssrRenderAttr("src", _ctx.$page.props.appFavicon)}${ssrRenderAttr("alt", _ctx.$page.props.appName)}>`);
          } else {
            _push(`<i class="ri-store-2-line"></i>`);
          }
          _push(`</div>`);
        } else {
          _push(`<div class="seller-avatar shadow-1"><img${ssrRenderAttr("src", inventory.store.get_logo)}${ssrRenderAttr("alt", inventory.store.name)}></div>`);
        }
        _push(`<div class="ms-3">`);
        if (inventory.store_id == null) {
          _push(`<div class="seller-username">`);
          if (_ctx.$page.props.appName != null) {
            _push(`<span>${ssrInterpolate(_ctx.$page.props.appName)}</span>`);
          } else {
            _push(`<span>${ssrInterpolate(_ctx.$t("messages.sentence.main_shop"))}</span>`);
          }
          _push(`<i class="ri-verified-badge-fill"></i></div>`);
        } else {
          _push(`<div class="seller-username">`);
          _push(ssrRenderComponent(unref(Link), {
            href: _ctx.route("admin.stores.show", inventory.store.uuid),
            class: "link text-dark"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(inventory.store.name)}`);
              } else {
                return [
                  createTextVNode(toDisplayString(inventory.store.name), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(`<i class="ri-verified-badge-fill"></i></div>`);
        }
        if (inventory.store_id != null) {
          _push(`<div class="registrations-date lts-05 mb-2">${ssrInterpolate(_ctx.$t("messages.sentence.price_status"))}: `);
          if (inventory.status == "publish") {
            _push(`<span class="text-success fw-bold">${ssrInterpolate(_ctx.$t("messages.sentence.verified"))}</span>`);
          } else {
            _push(`<!---->`);
          }
          if (inventory.status == "awaiting") {
            _push(`<span class="text-info fw-bold">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_verify"))}</span>`);
          } else if (inventory.status == "deactive") {
            _push(`<span class="text-danger fw-bold">${ssrInterpolate(_ctx.$t("messages.word.deactive"))}</span>`);
          } else if (inventory.status == "rejected") {
            _push(`<span class="text-danger fw-bold">${ssrInterpolate(_ctx.$t("messages.word.rejected"))}</span>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</div>`);
        } else {
          _push(`<div class="registrations-date lts-05 mb-2"><span>${ssrInterpolate(_ctx.$t("messages.sentence.main_shop"))}</span></div>`);
        }
        _push(`</div></div><div class="d-flex mt-sm-0 mt-3">`);
        if (inventory.status == "publish") {
          _push(ssrRenderComponent(unref(Link), mergeProps({
            href: _ctx.route("admin.inventories.status", inventory.id),
            as: "button",
            method: "post",
            data: { status: "deactivate" },
            "preserve-scroll": "",
            class: "btn btn-switch btn-on fs-9 shadow-1 ms-2"
          }, ssrGetDirectiveProps(_ctx, _directive_tooltip, _ctx.$t("messages.word.deactivate"), void 0, { top: true })), {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(_ctx.$t("messages.word.active"))}`);
              } else {
                return [
                  createTextVNode(toDisplayString(_ctx.$t("messages.word.active")), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
        } else if (inventory.status == "awaiting") {
          _push(ssrRenderComponent(unref(Link), mergeProps({
            href: _ctx.route("admin.inventories.status", inventory.id),
            as: "button",
            method: "post",
            data: { status: "confirmation" },
            "preserve-scroll": "",
            class: "btn btn-switch btn-awaiting fs-9 shadow-1 ms-2 lts-05"
          }, ssrGetDirectiveProps(_ctx, _directive_tooltip, _ctx.$t("messages.word.confirm"), void 0, { top: true })), {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(_ctx.$t("messages.word.confirm"))}`);
              } else {
                return [
                  createTextVNode(toDisplayString(_ctx.$t("messages.word.confirm")), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
        } else {
          _push(ssrRenderComponent(unref(Link), mergeProps({
            href: _ctx.route("admin.inventories.status", inventory.id),
            as: "button",
            method: "post",
            data: { status: "activate" },
            "preserve-scroll": "",
            class: "btn btn-switch btn-off fs-9 shadow-1 ms-2"
          }, ssrGetDirectiveProps(_ctx, _directive_tooltip, _ctx.$t("messages.word.activate"), void 0, { top: true })), {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(_ctx.$t("messages.word.deactive"))}`);
              } else {
                return [
                  createTextVNode(toDisplayString(_ctx.$t("messages.word.deactive")), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
        }
        _push(`<button${ssrRenderAttrs(mergeProps({
          class: "btn btn-square btn-xs btn-white shadow-1 ms-2",
          "data-bs-toggle": "modal",
          "data-bs-target": "#remove-price-" + inventory.id
        }, ssrGetDirectiveProps(_ctx, _directive_tooltip, _ctx.$t("messages.word.delete"), void 0, { top: true })))}><i class="ri-delete-bin-line"></i></button></div><div class="modal fade"${ssrRenderAttr("id", "remove-price-" + inventory.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><form style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.are_you_sure_delete_inventory"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-footer">`);
        _push(ssrRenderComponent(unref(Link), {
          as: "button",
          href: _ctx.route("admin.inventories.destroy", inventory.id),
          method: "delete",
          class: "btn btn-sm btn-danger px-3",
          "data-bs-dismiss": "modal",
          "aria-label": "Close"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("messages.word.delete"))}`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("messages.word.delete")), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</div></form></div></div></div></div></div><div class="col-12 mb-2"><span class="fs-8 text-gray me-1">${ssrInterpolate(_ctx.$t("messages.word.product"))}:</span>`);
        if (inventory.product.status == "publish") {
          _push(`<a${ssrRenderAttr("href", _ctx.route("main.products.show", inventory.product.slug))} target="_blank" class="fs-7 fw-bold link">${ssrInterpolate(inventory.product.title)}</a>`);
        } else {
          _push(ssrRenderComponent(unref(Link), {
            href: _ctx.route("admin.products.edit", inventory.product.slug),
            class: "fs-7 fw-bold link"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(inventory.product.title)}`);
              } else {
                return [
                  createTextVNode(toDisplayString(inventory.product.title), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
        }
        _push(`</div><div class="col-12 mb-3"><span class="fs-8 text-gray">${ssrInterpolate(_ctx.$t("messages.word.uuid"))}: <span class="fs-7 text-dark">${ssrInterpolate(inventory.uuid)}</span></span></div><div class="col-md-4 col-sm-6 col-12 mb-3"><label class="form-label fw-bold">${ssrInterpolate(_ctx.$t("messages.word.storage"))} <div class="form-control same-as-input">${ssrInterpolate(inventory.storage.name)}</div></label></div><!--[-->`);
        ssrRenderList(inventory.props, (inp, index2) => {
          _push(`<!--[-->`);
          if (inp.type == "color") {
            _push(`<div class="choose-widget col-md-4 col-sm-6 col-12 mb-3"><label class="form-label fw-bold lts-05">${ssrInterpolate(inp.name)} <div class="form-control same-as-input"><span class="dropdown-color-item shadow-1" style="${ssrRenderStyle({
              "background-color": inp.value["color"],
              border: inp.value["color"].includes("#ffffff") ? "solid 1px #dddddd" : ""
            })}"></span>${ssrInterpolate(inp.value["label"])}</div></label></div>`);
          } else {
            _push(`<div class="col-md-4 col-sm-6 col-12 mb-3"><label class="form-label fw-bold">${ssrInterpolate(inp.name)} <div class="form-control same-as-input">${ssrInterpolate(inp.value)}</div></label></div>`);
          }
          _push(`<!--]-->`);
        });
        _push(`<!--]--><div class="col-md-4 col-sm-6 col-12 mb-3"><label class="form-label fw-bold">${ssrInterpolate(_ctx.$t("messages.sentence.product_price"))} <span class="currency">${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span><div class="form-control same-as-input">${ssrInterpolate(inventory.get_formatted_price)}</div></label></div><div class="col-md-4 col-sm-6 col-12 mb-3"><label class="form-label fw-bold">${ssrInterpolate(_ctx.$t("messages.sentence.discount_price"))} <span class="currency">${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span><div class="form-control same-as-input">${ssrInterpolate(inventory.discount_price != null ? inventory.get_formatted_discount_price : _ctx.$t("messages.word.not_applied"))}</div></label></div><div class="col-md-4 col-sm-6 col-12 mb-3"><label class="form-label fw-bold">${ssrInterpolate(_ctx.$t("messages.sentence.discount_expire"))} <div class="form-control same-as-input">${ssrInterpolate(inventory.jalali_discount_expire != null ? inventory.jalali_discount_expire[1] : _ctx.$t("messages.word.not_applied"))}</div></label></div><div class="col-md-4 col-sm-6 col-12 mb-3"><label class="form-label fw-bold">${ssrInterpolate(_ctx.$t("messages.sentence.inventory_count"))} <div class="form-control same-as-input">${ssrInterpolate(inventory.count)}</div></label></div><div class="col-md-4 col-sm-6 col-12 mb-3"><label class="form-label fw-bold">${ssrInterpolate(_ctx.$t("messages.sentence.min_sale"))} <div class="form-control same-as-input">${ssrInterpolate(inventory.min_sale)}</div></label></div><div class="col-md-4 col-sm-6 col-12 mb-3"><label class="form-label fw-bold">${ssrInterpolate(_ctx.$t("messages.sentence.max_sale"))} <div class="form-control same-as-input">${ssrInterpolate(inventory.max_sale != null ? inventory.max_sale : _ctx.$t("messages.word.not_applied"))}</div></label></div>`);
        if (inventory.get_discount_tree.length > 0) {
          _push(`<div class="col-12 mb-4 count-discount-container mb-3"><div class="count-discount"><div class="tab-title mb-3"><div><div class="d-flex align-items-center mb-1">${ssrInterpolate(_ctx.$t("messages.sentence.tiered_discount_according_to_quantity"))} <span class="ms-1 text-info">(${ssrInterpolate(_ctx.$t("messages.word.optional"))})</span></div><span>${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_399852"))}</span></div></div><div class="sub sub-same-as-input"><!--[-->`);
          ssrRenderList(inventory.get_discount_tree, (dt, dti) => {
            _push(`<div class="row mb-1"><div class="col-sm-6 col-12 p-0 mb-1 mb-md-0"><div class="form-control same-as-input">${ssrInterpolate(dt.count)}</div></div><div class="col-sm-6 col-12 p-0 ps-md-2"><div class="form-control same-as-input">${ssrInterpolate(dt.price)} <span class="ms-1 currency">${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span></div></div></div>`);
          });
          _push(`<!--]--></div></div></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div></div>`);
      });
      _push(`<!--]--></div>`);
      if (_ctx.inventories.data.length == 0) {
        _push(`<div class="product-list-empty mt-5"><div class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.inventories.data.length > 0) {
        _push(ssrRenderComponent(_sfc_main$3, {
          links: _ctx.inventories.links
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Admin/Stores/AwaitingInventories.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
