import { defineComponent, mergeProps, unref, withCtx, createVNode, toDisplayString, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrRenderAttr, ssrInterpolate, ssrRenderComponent } from "vue/server-renderer";
import { Link } from "@inertiajs/vue3";
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "ArticleAuthor",
  __ssrInlineRender: true,
  props: {
    user: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "author card shadow-1 mb-4" }, _attrs))}><div class="card-body flex-grow-1"><div class="author--avatar">`);
      if (_ctx.user.seller) {
        _push(`<img class="shadow-1 mb-2" width="100" height="100"${ssrRenderAttr("src", _ctx.user.store.get_logo)}${ssrRenderAttr("alt", _ctx.user.store.name)} loading="lazy">`);
      } else {
        _push(`<img class="shadow-1 mb-2" width="100" height="100"${ssrRenderAttr("src", _ctx.user.get_avatar)}${ssrRenderAttr("alt", _ctx.user.get_name)} loading="lazy">`);
      }
      if (_ctx.user.type == "owner") {
        _push(`<div class="author--badge">${ssrInterpolate(_ctx.$t("messages.word.owner"))}</div>`);
      } else if (_ctx.user.type == "admin") {
        _push(`<div class="author--badge">${ssrInterpolate(_ctx.user.role)}</div>`);
      } else if (_ctx.user.seller) {
        _push(`<div class="author--badge">${ssrInterpolate(_ctx.$t("messages.word.seller"))}</div>`);
      } else {
        _push(`<div class="author--badge">${ssrInterpolate(_ctx.$t("messages.word.author"))}</div>`);
      }
      _push(`</div><div class="author--meta">`);
      if (_ctx.user.seller) {
        _push(`<!--[--><div class="author--name">`);
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("blog.articles.index", { profile: _ctx.user.store.uuid }),
          style: { "text-decoration": "none" }
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<span${_scopeId}>${ssrInterpolate(_ctx.user.store.name)}</span>`);
            } else {
              return [
                createVNode("span", null, toDisplayString(_ctx.user.store.name), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</div><p class="author--description mb-3">${ssrInterpolate(_ctx.user.store.bio)}</p><!--]-->`);
      } else {
        _push(`<!--[--><div class="author--name">`);
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("blog.articles.index", { profile: _ctx.user.username }),
          style: { "text-decoration": "none" }
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<span${_scopeId}>${ssrInterpolate(_ctx.user.get_name)}</span>`);
            } else {
              return [
                createVNode("span", null, toDisplayString(_ctx.user.get_name), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</div><p class="author--description mb-3">${ssrInterpolate(_ctx.user.bio)}</p><!--]-->`);
      }
      _push(`<div class="autor--meta-details"><ul><li>${ssrInterpolate(_ctx.$t("messages.word.published"))}: <span>${ssrInterpolate(_ctx.user.articles_count)}</span></li><li class="divider"></li><li>${ssrInterpolate(_ctx.$t("messages.sentence.register_date"))}: <span>${ssrInterpolate(_ctx.user.jalali_created_at[0])}</span></li></ul><div class="social"><a${ssrRenderAttr("href", _ctx.user.get_social.instagram)}><i class="ri-instagram-fill instagram"></i></a><a${ssrRenderAttr("href", _ctx.user.get_social.telegram)}><i class="ri-send-plane-2-fill telegram"></i></a></div></div></div></div></div>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Blog/Article/ArticleAuthor.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as _
};
