import { defineComponent, onMounted, onUnmounted, mergeProps, useSSRContext } from "vue";
import { ssrRenderAttrs } from "vue/server-renderer";
import ApexCharts from "apexcharts";
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "ApextBarChart",
  __ssrInlineRender: true,
  props: {
    id: {},
    labels: {},
    color: {},
    datasets: {}
  },
  setup(__props) {
    const props = __props;
    var BarChartOptions = {
      chart: {
        height: 275,
        type: "bar",
        toolbar: { show: false },
        dropShadow: {
          enabled: true,
          top: 0,
          left: 2,
          bottom: 2,
          right: 0,
          blur: 5,
          color: "#00000030",
          opacity: 0.35
        }
      },
      plotOptions: {
        bar: {
          horizontal: false,
          endingShape: "rounded",
          columnWidth: "35%",
          borderRadius: 2
        }
      },
      dataLabels: { enabled: false },
      stroke: { show: true, width: 1, colors: ["transparent"] },
      colors: props.color,
      series: [
        {
          name: props.datasets.one.label,
          data: props.datasets.one.data
        }
      ],
      xaxis: {
        show: true,
        categories: props.labels,
        axisBorder: {
          show: true,
          color: "#f1f1f1"
        },
        axisTicks: {
          show: true
        },
        labels: {
          show: true,
          style: {
            fontSize: "11px",
            fontFamily: "IRANYekanX",
            fontWeight: 500
          }
        }
      },
      legend: {
        position: "top",
        horizontalAlign: "left",
        fontFamily: "IRANYekanX",
        offsetY: 0
      },
      yaxis: {
        show: true,
        labels: {
          show: true,
          style: {
            fontSize: "12px",
            fontFamily: "IRANYekanX",
            fontWeight: 400
          }
        }
      },
      fill: { opacity: 1 },
      grid: {
        row: { colors: ["transparent", "transparent"], opacity: 0.1 },
        borderColor: "#f1f1f1"
      },
      tooltip: {
        style: {
          fontSize: "12px",
          fontFamily: "IRANYekanX"
        },
        y: {
          formatter: function(o) {
            return "" + o;
          }
        }
      }
    };
    if (props.datasets.two != null) {
      BarChartOptions.series.push({
        name: props.datasets.two.label,
        data: props.datasets.two.data
      });
    }
    let chart;
    onMounted(() => {
      chart = new ApexCharts(document.querySelector("#bar-chart-" + props.id), BarChartOptions);
      chart.render();
    });
    onUnmounted(() => {
      chart.destroy();
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({
        id: "bar-chart-" + _ctx.id
      }, _attrs))}></div>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/UI/Chart/ApextBarChart.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as _
};
