import { defineComponent, unref, withCtx, createTextVNode, toDisplayString, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderList, ssrRenderAttr, ssrRenderStyle } from "vue/server-renderer";
import { _ as _sfc_main$1 } from "./AdminLayout-CD07IMsK.js";
import { Head, Link } from "@inertiajs/vue3";
import { _ as _sfc_main$3 } from "./Pagination-C1AQrLe3.js";
import { _ as _sfc_main$2 } from "./Files-B6eiTnN6.js";
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "laravel-vue-i18n";
import "./SearchList-BZnYMQPN.js";
import "lodash/debounce.js";
import "./useRandomNum-DNNSqR7b.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "Answers",
  __ssrInlineRender: true,
  props: {
    form: {},
    answers: {},
    keyword: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.show_form_answers", { form: _ctx.form.title })
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.sentence.show_form_answers"),
        item: _ctx.$t("messages.word.form_creator")
      }, null, _parent));
      _push(`<div class="form-list product-list list mb-4"><div class="card"><div class="card-body"><div class="form-answer-container"><div class="row"><div class="col-12 mb-4"><div class="title"><span class="sub-title">${ssrInterpolate(_ctx.$t("messages.word.form"))}:</span> ${ssrInterpolate(_ctx.form.title)}</div></div><!--[-->`);
      ssrRenderList(_ctx.answers.data, (answer) => {
        _push(`<div class="col-md-6 col-12 mb-4"><div class="answer"><a href="javascript:void(0)" data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#remove-form-answer-" + answer.id)} class="remove-answer btn btn-xs btn-square btn-light"><i class="ri-close-line"></i></a>`);
        if (answer.flag == "unread") {
          _push(`<span class="link badge bg-info fs-8 lts-05 mb-3">${ssrInterpolate(_ctx.$t("messages.word.unread"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        if (answer.user_id != null) {
          _push(`<p class="mb-2"><span class="sub-title lts-05">${ssrInterpolate(_ctx.$t("messages.word.user"))}: </span>`);
          _push(ssrRenderComponent(unref(Link), {
            href: _ctx.route("admin.users.show", answer.user_id),
            class: "link badge text-info bg-info fs-8 lts-05"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(answer.get_user)}`);
              } else {
                return [
                  createTextVNode(toDisplayString(answer.get_user), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(`</p>`);
        } else {
          _push(`<p class="mb-2"><span class="sub-title lts-05">${ssrInterpolate(_ctx.$t("messages.word.user"))}: </span><span class="link badge bg-dark fs-8 lts-05">${ssrInterpolate(_ctx.$t("messages.word.guest"))}</span></p>`);
        }
        _push(`<!--[-->`);
        ssrRenderList(answer.get_answer, (item, index) => {
          _push(`<p class="mb-2"><span class="sub-title lts-05">${ssrInterpolate(item["title"])}: </span>`);
          if (item["type"] == "checkbox") {
            _push(`<!--[-->`);
            if (item["value"] != null && item["value"] != "") {
              _push(`<span class="d-inline-flex text-success">${ssrInterpolate(_ctx.$t("messages.word.checked"))} <i class="ri-check-line"></i></span>`);
            } else {
              _push(`<span class="d-inline-flex text-danger">${ssrInterpolate(_ctx.$t("messages.word.not_checked"))}</span>`);
            }
            _push(`<!--]-->`);
          } else {
            _push(`<!--[-->${ssrInterpolate(item["value"] != null && item["value"] != "" ? item["value"] : _ctx.$t("messages.word.empty"))}<!--]-->`);
          }
          _push(`</p>`);
        });
        _push(`<!--]--><p class="mb-2"><span class="sub-title lts-05">${ssrInterpolate(_ctx.$t("messages.word.date"))}:</span> ${ssrInterpolate(answer.jalali_created_at[2])}</p></div><div class="modal fade"${ssrRenderAttr("id", "remove-form-answer-" + answer.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><form style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.are_you_sure_delete_form_answer"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-footer">`);
        _push(ssrRenderComponent(unref(Link), {
          as: "button",
          href: _ctx.route("admin.forms.answer.destroy", [_ctx.form.slug, answer.id]),
          method: "delete",
          class: "btn btn-sm btn-danger px-3",
          "data-bs-dismiss": "modal",
          "aria-label": "Close"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("messages.word.delete"))}`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("messages.word.delete")), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</div></form></div></div></div></div>`);
      });
      _push(`<!--]--></div></div>`);
      if (_ctx.answers.data.length == 0) {
        _push(`<div class="product-list-empty d-flex align-items-center justify-content-center" style="${ssrRenderStyle({ "min-height": "400px" })}"><div class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(ssrRenderComponent(_sfc_main$3, {
        links: _ctx.answers.links
      }, null, _parent));
      _push(`</div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Admin/Forms/Answers.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
