import { defineComponent, mergeProps, unref, withCtx, createVNode, createTextVNode, toDisplayString, createBlock, createCommentVNode, openBlock, useSSRContext, ref, computed, watch, reactive, provide, onMounted } from "vue";
import { ssrRenderAttrs, ssrInterpolate, ssrRenderAttr, ssrRenderComponent, ssrRenderClass, ssrRenderStyle, ssrRenderSlot } from "vue/server-renderer";
import { Link, usePage, router, Head } from "@inertiajs/vue3";
import { a as _sfc_main$3 } from "./Files-B6eiTnN6.js";
import SimpleBar from "simplebar";
import ResizeObserver from "resize-observer-polyfill";
import { u as useToast } from "./useToastify-D_n0s7Uc.js";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
const _sfc_main$2 = /* @__PURE__ */ defineComponent({
  __name: "Sidebar",
  __ssrInlineRender: true,
  props: {
    sidebar: { type: Boolean }
  },
  emits: ["updateSidebar"],
  setup(__props, { emit: __emit }) {
    const emit = __emit;
    if (typeof window !== "undefined") {
      if (window.innerWidth <= 1200) emit("updateSidebar", false);
      $(window).on("resize", () => {
        if (window.innerWidth <= 1200) emit("updateSidebar", false);
        else emit("updateSidebar", true);
      });
    }
    const closeSidebarInDevice = () => {
      if (typeof window !== "undefined") {
        if (window.innerWidth <= 768) emit("updateSidebar", false);
      }
    };
    const isActive = (values) => {
      for (let value of values) {
        if (typeof window !== "undefined") {
          if (!usePage().props.currentRouteName.includes(value)) {
            continue;
          }
          return usePage().props.currentRouteName.includes(value);
        }
      }
      return false;
    };
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<nav${ssrRenderAttrs(mergeProps({
        class: _ctx.sidebar ? "admin-sidebar open" : "admin-sidebar"
      }, _attrs))}><div class="sidebar--top-section"><div class="title fs-6">${ssrInterpolate(_ctx.$page.props.panelDetails.name)}<span>${ssrInterpolate(_ctx.$page.props.panelDetails.version)}</span></div><span class="sidebar-toggle"><i class="ri-menu-4-fill"></i></span></div><div class="sidebar-inner simplebar-container"><div class="sidebar--account-section dropdown mt-4"><div class="inner" data-bs-toggle="dropdown"><div class="user-avatar"><img class="shadow-1" width="60" height="60"${ssrRenderAttr("src", _ctx.$page.props.auth.user.get_avatar)}${ssrRenderAttr("alt", _ctx.$page.props.auth.user.get_name)}></div><div class="user-details ms-3"><span class="name mb-1">${ssrInterpolate(_ctx.$page.props.auth.user.get_name)}</span><span class="type">${ssrInterpolate(_ctx.$page.props.auth.user.role.label)}</span></div><div class="user-settings"><i class="ri-arrow-down-s-line"></i></div></div><div class="dropdown-menu shadow-1"><ul><li>`);
      _push(ssrRenderComponent(unref(Link), {
        onClick: closeSidebarInDevice,
        class: { "dropdown-item": true, "lts-05": true, active: isActive(["admin.profile.edit"]) },
        href: _ctx.route("admin.profile.edit")
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<i class="ri-user-smile-line"${_scopeId}></i> ${ssrInterpolate(_ctx.$t("messages.sentence.edit_profile"))}`);
          } else {
            return [
              createVNode("i", { class: "ri-user-smile-line" }),
              createTextVNode(" " + toDisplayString(_ctx.$t("messages.sentence.edit_profile")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</li><li>`);
      _push(ssrRenderComponent(unref(Link), {
        onClick: closeSidebarInDevice,
        class: { "dropdown-item": true, "lts-05": true, active: isActive(["admin.profile.sessions"]) },
        href: _ctx.route("admin.profile.sessions")
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<i class="ri-device-line"${_scopeId}></i> ${ssrInterpolate(_ctx.$t("messages.sentence.active_sessions"))}`);
          } else {
            return [
              createVNode("i", { class: "ri-device-line" }),
              createTextVNode(" " + toDisplayString(_ctx.$t("messages.sentence.active_sessions")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</li><li>`);
      _push(ssrRenderComponent(unref(Link), {
        onClick: closeSidebarInDevice,
        href: _ctx.route("admin.notifications.index"),
        class: { "dropdown-item": true, "lts-05": true, active: isActive(["admin.notifications.index"]) }
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<i class="ri-notification-3-line"${_scopeId}></i> ${ssrInterpolate(_ctx.$t("messages.word.notifications"))}`);
          } else {
            return [
              createVNode("i", { class: "ri-notification-3-line" }),
              createTextVNode(" " + toDisplayString(_ctx.$t("messages.word.notifications")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</li><li>`);
      _push(ssrRenderComponent(unref(Link), {
        class: "dropdown-item lts-05",
        method: "post",
        href: _ctx.route("logout"),
        as: "button"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<i class="ri-logout-circle-r-line"${_scopeId}></i> ${ssrInterpolate(_ctx.$t("messages.word.logout"))}`);
          } else {
            return [
              createVNode("i", { class: "ri-logout-circle-r-line" }),
              createTextVNode(" " + toDisplayString(_ctx.$t("messages.word.logout")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</li></ul></div></div><ul class="menu-list" id="sidebarAccordion"><li class="title">${ssrInterpolate(_ctx.$t("messages.word.overview"))}</li><li class="${ssrRenderClass({ "menu-item": true, active: isActive(["admin.dashboard"]) })}">`);
      _push(ssrRenderComponent(unref(Link), {
        onClick: closeSidebarInDevice,
        href: _ctx.route("admin.dashboard")
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<i class="ri-home-3-line"${_scopeId}></i><span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.dashboard"))}</span>`);
          } else {
            return [
              createVNode("i", { class: "ri-home-3-line" }),
              createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.word.dashboard")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</li>`);
      if (_ctx.$page.props.auth.can["show-reports"]) {
        _push(`<li class="${ssrRenderClass({ "menu-item": true, active: isActive(["admin.reports.index"]) })}">`);
        _push(ssrRenderComponent(unref(Link), {
          onClick: closeSidebarInDevice,
          href: _ctx.route("admin.reports.index")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<i class="ri-slideshow-2-line"${_scopeId}></i><span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.recent_actions"))}</span>`);
            } else {
              return [
                createVNode("i", { class: "ri-slideshow-2-line" }),
                createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.word.recent_actions")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</li>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.$page.props.auth.can["show-statistics"]) {
        _push(`<li class="${ssrRenderClass({ "menu-item": true, accordion: true, active: isActive(["admin.statistics"]) })}"><a href="javascript:void(0)" data-bs-toggle="collapse" data-bs-target="#statisticsItem"${ssrRenderAttr("aria-expanded", isActive(["admin.statistics"]))} aria-controls="statisticsItem"><i class="ri-bar-chart-2-line"></i><span class="item-title">${ssrInterpolate(_ctx.$t("messages.word.statistics"))}</span><span class="according-menu"><i class="ri-arrow-right-s-line"></i></span></a><ul id="statisticsItem" data-bs-parent="#sidebarAccordion" class="${ssrRenderClass({ "sub-menu": true, collapse: true, show: isActive(["admin.statistics"]) })}"><li class="${ssrRenderClass({ active: isActive(["admin.statistics.tracking_view"]) })}">`);
        _push(ssrRenderComponent(unref(Link), {
          onClick: closeSidebarInDevice,
          href: _ctx.route("admin.statistics.tracking_view")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.sentence.tracking_view"))}</span>`);
            } else {
              return [
                createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.sentence.tracking_view")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</li><li class="${ssrRenderClass({ active: isActive(["admin.statistics.view_chart"]) })}">`);
        _push(ssrRenderComponent(unref(Link), {
          onClick: closeSidebarInDevice,
          href: _ctx.route("admin.statistics.view_chart")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.sentence.view_charts"))}</span>`);
            } else {
              return [
                createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.sentence.view_charts")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</li><li class="${ssrRenderClass({ active: isActive(["admin.statistics.products"]) })}">`);
        _push(ssrRenderComponent(unref(Link), {
          onClick: closeSidebarInDevice,
          href: _ctx.route("admin.statistics.products")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.sentence.products_statistics"))}</span>`);
            } else {
              return [
                createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.sentence.products_statistics")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</li><li class="${ssrRenderClass({ active: isActive(["admin.statistics.articles"]) })}">`);
        _push(ssrRenderComponent(unref(Link), {
          onClick: closeSidebarInDevice,
          href: _ctx.route("admin.statistics.articles")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.sentence.articles_statistics"))}</span>`);
            } else {
              return [
                createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.sentence.articles_statistics")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</li><li class="${ssrRenderClass({ active: isActive(["admin.statistics.financial"]) })}">`);
        _push(ssrRenderComponent(unref(Link), {
          onClick: closeSidebarInDevice,
          href: _ctx.route("admin.statistics.financial")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.sentence.financial_statistics"))}</span>`);
            } else {
              return [
                createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.sentence.financial_statistics")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</li></ul></li>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.$page.props.auth.can["manage-orders"] || _ctx.$page.props.auth.can["manage-transactions"] || _ctx.$page.props.auth.can["manage-discounts"]) {
        _push(`<li class="title">${ssrInterpolate(_ctx.$t("messages.sentence.financial_and_payments"))}</li>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.$page.props.auth.can["manage-orders"]) {
        _push(`<li class="${ssrRenderClass({ "menu-item": true, accordion: true, active: isActive(["admin.orders"]) })}"><a href="javascript:void(0)" data-bs-toggle="collapse" data-bs-target="#ordersItem"${ssrRenderAttr("aria-expanded", isActive(["admin.orders"]))} aria-controls="ordersItem"><i class="ri-archive-2-line"></i><span class="item-title">${ssrInterpolate(_ctx.$t("messages.word.orders"))}</span><span class="according-menu"><i class="ri-arrow-right-s-line"></i></span>`);
        if (_ctx.$page.props.auth.adminBadges["waiting-orders"] > 0) {
          _push(`<span class="count-badge sub shadow-1">${ssrInterpolate(_ctx.$page.props.auth.adminBadges["waiting-orders"])}</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</a><ul id="ordersItem" data-bs-parent="#sidebarAccordion" class="${ssrRenderClass({ "sub-menu": true, collapse: true, show: isActive(["admin.orders"]) })}"><li class="${ssrRenderClass({ active: isActive(["admin.orders.processing"]), "has-notification": _ctx.$page.props.auth.adminBadges["waiting-orders"] > 0 })}">`);
        _push(ssrRenderComponent(unref(Link), {
          onClick: closeSidebarInDevice,
          href: _ctx.route("admin.orders.processing")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.processing"))}</span>`);
            } else {
              return [
                createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.word.processing")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</li><li class="${ssrRenderClass({ active: isActive(["admin.orders.completed"]) })}">`);
        _push(ssrRenderComponent(unref(Link), {
          onClick: closeSidebarInDevice,
          href: _ctx.route("admin.orders.completed")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.completed"))}</span>`);
            } else {
              return [
                createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.word.completed")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</li></ul></li>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.$page.props.auth.can["manage-transactions"]) {
        _push(`<li class="${ssrRenderClass({ "menu-item": true, accordion: true, active: isActive(["admin.transactions"]) })}"><a href="javascript:void(0)" data-bs-toggle="collapse" data-bs-target="#transactionsItem"${ssrRenderAttr("aria-expanded", isActive(["admin.transactions"]))} aria-controls="transactionsItem"><i class="ri-bank-card-2-line"></i><span class="item-title">${ssrInterpolate(_ctx.$t("messages.word.transactions"))}</span><span class="according-menu"><i class="ri-arrow-right-s-line"></i></span></a><ul id="transactionsItem" data-bs-parent="#sidebarAccordion" class="${ssrRenderClass({ "sub-menu": true, collapse: true, show: isActive(["admin.transactions"]) })}"><li class="${ssrRenderClass({ active: isActive(["admin.transactions.index"]) })}">`);
        _push(ssrRenderComponent(unref(Link), {
          onClick: closeSidebarInDevice,
          href: _ctx.route("admin.transactions.index")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.all"))}</span>`);
            } else {
              return [
                createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.word.all")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</li><li class="${ssrRenderClass({ active: isActive(["admin.transactions.sellers"]) })}">`);
        _push(ssrRenderComponent(unref(Link), {
          onClick: closeSidebarInDevice,
          href: _ctx.route("admin.transactions.sellers")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.sellers"))}</span>`);
            } else {
              return [
                createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.word.sellers")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</li><li class="${ssrRenderClass({ active: isActive(["admin.transactions.affiliates"]) })}">`);
        _push(ssrRenderComponent(unref(Link), {
          onClick: closeSidebarInDevice,
          href: _ctx.route("admin.transactions.affiliates")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.affiliates"))}</span>`);
            } else {
              return [
                createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.word.affiliates")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</li></ul></li>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.$page.props.auth.can["manage-transactions"]) {
        _push(`<li class="${ssrRenderClass({ "menu-item": true, active: isActive(["admin.pending_payments"]) })}">`);
        _push(ssrRenderComponent(unref(Link), {
          onClick: closeSidebarInDevice,
          href: _ctx.route("admin.pending_payments.index")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<i class="ri-secure-payment-line"${_scopeId}></i><span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.sentence.shares_pending_payments"))}</span>`);
              if (_ctx.$page.props.auth.adminBadges["waiting-pending-payments"] > 0) {
                _push2(`<span class="count-badge shadow-1"${_scopeId}>${ssrInterpolate(_ctx.$page.props.auth.adminBadges["waiting-pending-payments"])}</span>`);
              } else {
                _push2(`<!---->`);
              }
            } else {
              return [
                createVNode("i", { class: "ri-secure-payment-line" }),
                createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.sentence.shares_pending_payments")), 1),
                _ctx.$page.props.auth.adminBadges["waiting-pending-payments"] > 0 ? (openBlock(), createBlock("span", {
                  key: 0,
                  class: "count-badge shadow-1"
                }, toDisplayString(_ctx.$page.props.auth.adminBadges["waiting-pending-payments"]), 1)) : createCommentVNode("", true)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</li>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.$page.props.auth.can["manage-transactions"]) {
        _push(`<li class="${ssrRenderClass({ "menu-item": true, active: isActive(["admin.withdrawals"]) })}">`);
        _push(ssrRenderComponent(unref(Link), {
          onClick: closeSidebarInDevice,
          href: _ctx.$page.props.auth.adminBadges["waiting-withdrawals"] > 0 ? _ctx.route("admin.withdrawals.index", { awaiting: true }) : _ctx.route("admin.withdrawals.index")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<i class="ri-arrow-up-fill"${_scopeId}></i><span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.withdrawals"))}</span>`);
              if (_ctx.$page.props.auth.adminBadges["waiting-withdrawals"] > 0) {
                _push2(`<span class="count-badge shadow-1"${_scopeId}>${ssrInterpolate(_ctx.$page.props.auth.adminBadges["waiting-withdrawals"])}</span>`);
              } else {
                _push2(`<!---->`);
              }
            } else {
              return [
                createVNode("i", { class: "ri-arrow-up-fill" }),
                createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.word.withdrawals")), 1),
                _ctx.$page.props.auth.adminBadges["waiting-withdrawals"] > 0 ? (openBlock(), createBlock("span", {
                  key: 0,
                  class: "count-badge shadow-1"
                }, toDisplayString(_ctx.$page.props.auth.adminBadges["waiting-withdrawals"]), 1)) : createCommentVNode("", true)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</li>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.$page.props.auth.can["manage-prefactors"]) {
        _push(`<li class="${ssrRenderClass({ "menu-item": true, active: isActive(["admin.prefactors"]) })}">`);
        _push(ssrRenderComponent(unref(Link), {
          onClick: closeSidebarInDevice,
          href: _ctx.route("admin.prefactors.index")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<i class="ri-file-list-3-line"${_scopeId}></i><span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.prefactor"))}</span>`);
            } else {
              return [
                createVNode("i", { class: "ri-file-list-3-line" }),
                createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.word.prefactor")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</li>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.$page.props.auth.can["manage-discounts"]) {
        _push(`<li class="${ssrRenderClass({ "menu-item": true, active: isActive(["admin.discounts"]) })}">`);
        _push(ssrRenderComponent(unref(Link), {
          onClick: closeSidebarInDevice,
          href: _ctx.route("admin.discounts.index")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<i class="ri-percent-fill"${_scopeId}></i><span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.discounts"))}</span>`);
            } else {
              return [
                createVNode("i", { class: "ri-percent-fill" }),
                createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.word.discounts")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</li>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.$page.props.auth.can["manage-orders"]) {
        _push(`<li class="${ssrRenderClass({ "menu-item": true, active: isActive(["admin.payments.meta.index"]) })}">`);
        _push(ssrRenderComponent(unref(Link), {
          onClick: closeSidebarInDevice,
          href: _ctx.route("admin.payments.meta.index")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<i class="ri-truck-line"${_scopeId}></i><span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.transportation"))}</span>`);
            } else {
              return [
                createVNode("i", { class: "ri-truck-line" }),
                createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.word.transportation")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</li>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.$page.props.auth.can["manage-tickets"] || _ctx.$page.props.auth.can["manage-forms"] || _ctx.$page.props.auth.can["manage-faq"]) {
        _push(`<li class="title">${ssrInterpolate(_ctx.$t("messages.sentence.support_affairs"))}</li>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.$page.props.auth.can["manage-tickets"]) {
        _push(`<li class="${ssrRenderClass({ "menu-item": true, active: isActive(["admin.tickets"]) })}">`);
        _push(ssrRenderComponent(unref(Link), {
          onClick: closeSidebarInDevice,
          href: _ctx.route("admin.tickets.index")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<i class="ri-message-3-line"${_scopeId}></i><span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.tickets"))}</span>`);
              if (_ctx.$page.props.auth.adminBadges["waiting-tickets"] > 0) {
                _push2(`<span class="count-badge shadow-1"${_scopeId}>${ssrInterpolate(_ctx.$page.props.auth.adminBadges["waiting-tickets"])}</span>`);
              } else {
                _push2(`<!---->`);
              }
            } else {
              return [
                createVNode("i", { class: "ri-message-3-line" }),
                createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.word.tickets")), 1),
                _ctx.$page.props.auth.adminBadges["waiting-tickets"] > 0 ? (openBlock(), createBlock("span", {
                  key: 0,
                  class: "count-badge shadow-1"
                }, toDisplayString(_ctx.$page.props.auth.adminBadges["waiting-tickets"]), 1)) : createCommentVNode("", true)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</li>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.$page.props.auth.can["manage-forms"]) {
        _push(`<li class="${ssrRenderClass({ "menu-item": true, active: isActive(["admin.forms"]) })}">`);
        _push(ssrRenderComponent(unref(Link), {
          onClick: closeSidebarInDevice,
          href: _ctx.route("admin.forms.index")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<i class="ri-questionnaire-line"${_scopeId}></i><span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.forms"))}</span>`);
              if (_ctx.$page.props.auth.adminBadges["unread-form-answers"] > 0) {
                _push2(`<span class="count-badge shadow-1"${_scopeId}>${ssrInterpolate(_ctx.$page.props.auth.adminBadges["unread-form-answers"])}</span>`);
              } else {
                _push2(`<!---->`);
              }
            } else {
              return [
                createVNode("i", { class: "ri-questionnaire-line" }),
                createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.word.forms")), 1),
                _ctx.$page.props.auth.adminBadges["unread-form-answers"] > 0 ? (openBlock(), createBlock("span", {
                  key: 0,
                  class: "count-badge shadow-1"
                }, toDisplayString(_ctx.$page.props.auth.adminBadges["unread-form-answers"]), 1)) : createCommentVNode("", true)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</li>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.$page.props.auth.can["manage-faq"]) {
        _push(`<li class="${ssrRenderClass({ "menu-item": true, active: isActive(["admin.faq"]) })}">`);
        _push(ssrRenderComponent(unref(Link), {
          onClick: closeSidebarInDevice,
          href: _ctx.route("admin.faq.index")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<i class="ri-question-line"${_scopeId}></i><span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.faqs"))}</span>`);
            } else {
              return [
                createVNode("i", { class: "ri-question-line" }),
                createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.word.faqs")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</li>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.$page.props.auth.can["manage-stores"]) {
        _push(`<li class="title">${ssrInterpolate(_ctx.$t("messages.sentence.affairs_of_sellers_and_affiliates"))}</li>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.$page.props.auth.can["manage-stores"]) {
        _push(`<li class="${ssrRenderClass({ "menu-item": true, accordion: true, active: isActive(["admin.stores"]) })}"><a href="javascript:void(0)" data-bs-toggle="collapse" data-bs-target="#sellersItem"${ssrRenderAttr("aria-expanded", isActive(["admin.stores"]))} aria-controls="sellersItem"><i class="ri-store-2-line"></i><span class="item-title">${ssrInterpolate(_ctx.$t("messages.word.stores"))}</span>`);
        if (_ctx.$page.props.auth.adminBadges["waiting-stores"] > 0 || _ctx.$page.props.auth.adminBadges["waiting-products"] > 0 || _ctx.$page.props.auth.adminBadges["waiting-inventories"] > 0 || _ctx.$page.props.auth.adminBadges["waiting-articles"] > 0) {
          _push(`<span class="count-badge sub shadow-1">${ssrInterpolate(_ctx.$page.props.auth.adminBadges["waiting-stores"] + _ctx.$page.props.auth.adminBadges["waiting-products"] + _ctx.$page.props.auth.adminBadges["waiting-inventories"] + _ctx.$page.props.auth.adminBadges["waiting-articles"])}</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<span class="according-menu"><i class="ri-arrow-right-s-line"></i></span></a><ul id="sellersItem" data-bs-parent="#sidebarAccordion" class="${ssrRenderClass({ "sub-menu": true, collapse: true, show: isActive(["admin.stores"]) })}"><li class="${ssrRenderClass({ active: isActive(["admin.stores.index"]) })}">`);
        _push(ssrRenderComponent(unref(Link), {
          onClick: closeSidebarInDevice,
          href: _ctx.route("admin.stores.index")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.list"))}</span>`);
            } else {
              return [
                createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.word.list")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</li><li class="${ssrRenderClass({ active: isActive(["admin.stores.awaiting"]), "has-notification": _ctx.$page.props.auth.adminBadges["waiting-stores"] > 0 })}">`);
        _push(ssrRenderComponent(unref(Link), {
          onClick: closeSidebarInDevice,
          href: _ctx.route("admin.stores.awaiting")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_stores"))}</span>`);
            } else {
              return [
                createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.sentence.awaiting_stores")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</li><li class="${ssrRenderClass({ active: isActive(["admin.stores.products.awaiting"]), "has-notification": _ctx.$page.props.auth.adminBadges["waiting-products"] > 0 })}">`);
        _push(ssrRenderComponent(unref(Link), {
          onClick: closeSidebarInDevice,
          href: _ctx.route("admin.stores.products.awaiting")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_products"))}</span>`);
            } else {
              return [
                createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.sentence.awaiting_products")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</li><li class="${ssrRenderClass({ active: isActive(["admin.stores.inventories.awaiting"]), "has-notification": _ctx.$page.props.auth.adminBadges["waiting-inventories"] > 0 })}">`);
        _push(ssrRenderComponent(unref(Link), {
          onClick: closeSidebarInDevice,
          href: _ctx.route("admin.stores.inventories.awaiting")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_inventories"))}</span>`);
            } else {
              return [
                createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.sentence.awaiting_inventories")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</li><li class="${ssrRenderClass({ active: isActive(["admin.stores.articles.awaiting"]), "has-notification": _ctx.$page.props.auth.adminBadges["waiting-articles"] > 0 })}">`);
        _push(ssrRenderComponent(unref(Link), {
          onClick: closeSidebarInDevice,
          href: _ctx.route("admin.stores.articles.awaiting")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_articles"))}</span>`);
            } else {
              return [
                createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.sentence.awaiting_articles")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</li></ul></li>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.$page.props.auth.can["manage-affiliate"]) {
        _push(`<li class="${ssrRenderClass({ "menu-item": true, accordion: true, active: isActive(["admin.affiliate"]) })}"><a href="javascript:void(0)" data-bs-toggle="collapse" data-bs-target="#affiliatesItem"${ssrRenderAttr("aria-expanded", isActive(["admin.affiliate"]))} aria-controls="affiliatesItem"><i class="ri-user-voice-line"></i><span class="item-title">${ssrInterpolate(_ctx.$t("messages.word.affiliate"))}</span><span class="according-menu"><i class="ri-arrow-right-s-line"></i></span></a><ul id="affiliatesItem" data-bs-parent="#sidebarAccordion" class="${ssrRenderClass({ "sub-menu": true, collapse: true, show: isActive(["admin.affiliate"]) })}"><li class="${ssrRenderClass({ active: isActive(["admin.affiliate.products"]) })}">`);
        _push(ssrRenderComponent(unref(Link), {
          onClick: closeSidebarInDevice,
          href: _ctx.route("admin.affiliate.products")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.products"))}</span>`);
            } else {
              return [
                createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.word.products")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</li></ul></li>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.$page.props.auth.can["manage-products"] || _ctx.$page.props.auth.can["manage-storages"] || _ctx.$page.props.auth.can["manage-product-categories"] || _ctx.$page.props.auth.can["manage-product-comments"] || _ctx.$page.props.auth.can["manage-product-questions"] || _ctx.$page.props.auth.can["manage-brands"] || _ctx.$page.props.auth.can["manage-stories"]) {
        _push(`<li class="title">${ssrInterpolate(_ctx.$t("messages.sentence.product_operation"))}</li>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.$page.props.auth.can["manage-products"]) {
        _push(`<li class="${ssrRenderClass({ "menu-item": true, accordion: true, active: isActive(["admin.products", "admin.product.tags", "admin.product.colors", "admin.product.prices"]) })}"><a href="javascript:void(0)" data-bs-toggle="collapse" data-bs-target="#productsItem"${ssrRenderAttr("aria-expanded", isActive(["admin.products", "admin.product.tags", "admin.product.colors", "admin.product.prices"]))} aria-controls="productsItem"><i class="ri-shopping-basket-line"></i><span class="item-title">${ssrInterpolate(_ctx.$t("messages.word.products"))}</span><span class="according-menu"><i class="ri-arrow-right-s-line"></i></span></a><ul id="productsItem" data-bs-parent="#sidebarAccordion" class="${ssrRenderClass({ "sub-menu": true, collapse: true, show: isActive(["admin.products", "admin.product.tags", "admin.product.colors", "admin.product.prices"]) })}"><li class="${ssrRenderClass({ active: isActive(["admin.products.index"]) })}">`);
        _push(ssrRenderComponent(unref(Link), {
          onClick: closeSidebarInDevice,
          href: _ctx.route("admin.products.index")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.list"))}</span>`);
            } else {
              return [
                createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.word.list")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</li><li class="${ssrRenderClass({ active: isActive(["admin.products.create"]) })}">`);
        _push(ssrRenderComponent(unref(Link), {
          onClick: closeSidebarInDevice,
          href: _ctx.route("admin.products.create")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.sentence.create_product"))}</span>`);
            } else {
              return [
                createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.sentence.create_product")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</li><li class="${ssrRenderClass({ active: isActive(["admin.product.tags"]) })}">`);
        _push(ssrRenderComponent(unref(Link), {
          onClick: closeSidebarInDevice,
          href: _ctx.route("admin.product.tags.index")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.tags"))}</span>`);
            } else {
              return [
                createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.word.tags")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</li><li class="${ssrRenderClass({ active: isActive(["admin.product.colors"]) })}">`);
        _push(ssrRenderComponent(unref(Link), {
          onClick: closeSidebarInDevice,
          href: _ctx.route("admin.product.colors.index")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.colors"))}</span>`);
            } else {
              return [
                createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.word.colors")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</li><li class="${ssrRenderClass({ active: isActive(["admin.products.trash"]) })}">`);
        _push(ssrRenderComponent(unref(Link), {
          onClick: closeSidebarInDevice,
          href: _ctx.route("admin.products.trash")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.trash"))}</span>`);
            } else {
              return [
                createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.word.trash")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</li></ul></li>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.$page.props.auth.can["manage-storages"]) {
        _push(`<li class="${ssrRenderClass({ "menu-item": true, active: isActive(["admin.storages", "admin.inventories"]) })}">`);
        _push(ssrRenderComponent(unref(Link), {
          onClick: closeSidebarInDevice,
          href: _ctx.route("admin.storages.index")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<i class="ri-home-4-line"${_scopeId}></i><span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.warehousing"))}</span>`);
            } else {
              return [
                createVNode("i", { class: "ri-home-4-line" }),
                createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.word.warehousing")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</li>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.$page.props.auth.can["manage-product-comments"]) {
        _push(`<li class="${ssrRenderClass({ "menu-item": true, active: isActive(["admin.product.comments"]) })}">`);
        _push(ssrRenderComponent(unref(Link), {
          onClick: closeSidebarInDevice,
          href: _ctx.route("admin.product.comments.index")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<i class="ri-message-3-line"${_scopeId}></i><span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.comments"))}</span>`);
              if (_ctx.$page.props.auth.adminBadges["waiting-product-comments"] > 0 || _ctx.$page.props.auth.adminBadges["waiting-product-comments-reports"] > 0) {
                _push2(`<span class="count-badge shadow-1"${_scopeId}>${ssrInterpolate(_ctx.$page.props.auth.adminBadges["waiting-product-comments"] + _ctx.$page.props.auth.adminBadges["waiting-product-comments-reports"])}</span>`);
              } else {
                _push2(`<!---->`);
              }
            } else {
              return [
                createVNode("i", { class: "ri-message-3-line" }),
                createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.word.comments")), 1),
                _ctx.$page.props.auth.adminBadges["waiting-product-comments"] > 0 || _ctx.$page.props.auth.adminBadges["waiting-product-comments-reports"] > 0 ? (openBlock(), createBlock("span", {
                  key: 0,
                  class: "count-badge shadow-1"
                }, toDisplayString(_ctx.$page.props.auth.adminBadges["waiting-product-comments"] + _ctx.$page.props.auth.adminBadges["waiting-product-comments-reports"]), 1)) : createCommentVNode("", true)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</li>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.$page.props.auth.can["manage-product-questions"]) {
        _push(`<li class="${ssrRenderClass({ "menu-item": true, active: isActive(["admin.questions"]) })}">`);
        _push(ssrRenderComponent(unref(Link), {
          onClick: closeSidebarInDevice,
          href: _ctx.route("admin.questions.index")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<i class="ri-question-line"${_scopeId}></i><span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.sentence.questions_and_answers"))}</span>`);
              if (_ctx.$page.props.auth.adminBadges["waiting-questions"] > 0 || _ctx.$page.props.auth.adminBadges["waiting-question-answers"] > 0) {
                _push2(`<span class="count-badge shadow-1"${_scopeId}>${ssrInterpolate(_ctx.$page.props.auth.adminBadges["waiting-questions"] + _ctx.$page.props.auth.adminBadges["waiting-question-answers"])}</span>`);
              } else {
                _push2(`<!---->`);
              }
            } else {
              return [
                createVNode("i", { class: "ri-question-line" }),
                createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.sentence.questions_and_answers")), 1),
                _ctx.$page.props.auth.adminBadges["waiting-questions"] > 0 || _ctx.$page.props.auth.adminBadges["waiting-question-answers"] > 0 ? (openBlock(), createBlock("span", {
                  key: 0,
                  class: "count-badge shadow-1"
                }, toDisplayString(_ctx.$page.props.auth.adminBadges["waiting-questions"] + _ctx.$page.props.auth.adminBadges["waiting-question-answers"]), 1)) : createCommentVNode("", true)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</li>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.$page.props.auth.can["manage-product-categories"]) {
        _push(`<li class="${ssrRenderClass({ "menu-item": true, active: isActive(["admin.product.categories"]) })}">`);
        _push(ssrRenderComponent(unref(Link), {
          onClick: closeSidebarInDevice,
          href: _ctx.route("admin.product.categories.index")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<i class="ri-list-check"${_scopeId}></i><span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.categories"))}</span>`);
            } else {
              return [
                createVNode("i", { class: "ri-list-check" }),
                createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.word.categories")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</li>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.$page.props.auth.can["manage-brands"]) {
        _push(`<li class="${ssrRenderClass({ "menu-item": true, accordion: true, active: isActive(["admin.brands"]) })}"><a href="javascript:void(0)" data-bs-toggle="collapse" data-bs-target="#brandsItem"${ssrRenderAttr("aria-expanded", isActive(["admin.brands"]))} aria-controls="brandsItem"><i class="ri-instance-line"></i><span class="item-title">${ssrInterpolate(_ctx.$t("messages.word.brands"))}</span><span class="according-menu"><i class="ri-arrow-right-s-line"></i></span></a><ul id="brandsItem" data-bs-parent="#sidebarAccordion" class="${ssrRenderClass({ "sub-menu": true, collapse: true, show: isActive(["admin.brands"]) })}"><li class="${ssrRenderClass({ active: isActive(["admin.brands.index"]) })}">`);
        _push(ssrRenderComponent(unref(Link), {
          onClick: closeSidebarInDevice,
          href: _ctx.route("admin.brands.index")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.list"))}</span>`);
            } else {
              return [
                createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.word.list")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</li><li class="${ssrRenderClass({ active: isActive(["admin.brands.create"]) })}">`);
        _push(ssrRenderComponent(unref(Link), {
          onClick: closeSidebarInDevice,
          href: _ctx.route("admin.brands.create")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.sentence.create_brand"))}</span>`);
            } else {
              return [
                createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.sentence.create_brand")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</li><li class="${ssrRenderClass({ active: isActive(["admin.brands.trash"]) })}">`);
        _push(ssrRenderComponent(unref(Link), {
          onClick: closeSidebarInDevice,
          href: _ctx.route("admin.brands.trash")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.trash"))}</span>`);
            } else {
              return [
                createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.word.trash")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</li></ul></li>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.$page.props.auth.can["manage-stories"]) {
        _push(`<li class="${ssrRenderClass({ "menu-item": true, active: isActive(["admin.stories"]) })}">`);
        _push(ssrRenderComponent(unref(Link), {
          onClick: closeSidebarInDevice,
          href: _ctx.route("admin.stories.index")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<i class="ri-camera-lens-line"${_scopeId}></i><span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.stories"))}</span>`);
            } else {
              return [
                createVNode("i", { class: "ri-camera-lens-line" }),
                createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.word.stories")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</li>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.$page.props.auth.can["manage-articles"] || _ctx.$page.props.auth.can["manage-article-categories"] || _ctx.$page.props.auth.can["manage-article-comments"]) {
        _push(`<li class="title">${ssrInterpolate(_ctx.$t("messages.sentence.blog_operation"))}</li>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.$page.props.auth.can["manage-articles"]) {
        _push(`<li class="${ssrRenderClass({ "menu-item": true, accordion: true, active: isActive(["admin.articles", "admin.article.tags"]) })}"><a href="javascript:void(0)" data-bs-toggle="collapse" data-bs-target="#articlesItem"${ssrRenderAttr("aria-expanded", isActive(["admin.articles", "admin.article.tags"]))} aria-controls="articlesItem"><i class="ri-article-line"></i><span class="item-title">${ssrInterpolate(_ctx.$t("messages.word.articles"))}</span><span class="according-menu"><i class="ri-arrow-right-s-line"></i></span></a><ul id="articlesItem" data-bs-parent="#sidebarAccordion" class="${ssrRenderClass({ "sub-menu": true, collapse: true, show: isActive(["admin.articles", "admin.article.tags"]) })}"><li class="${ssrRenderClass({ active: isActive(["admin.articles.index"]) })}">`);
        _push(ssrRenderComponent(unref(Link), {
          onClick: closeSidebarInDevice,
          href: _ctx.route("admin.articles.index")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.list"))}</span>`);
            } else {
              return [
                createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.word.list")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</li><li class="${ssrRenderClass({ active: isActive(["admin.articles.create"]) })}">`);
        _push(ssrRenderComponent(unref(Link), {
          onClick: closeSidebarInDevice,
          href: _ctx.route("admin.articles.create")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.sentence.create_article"))}</span>`);
            } else {
              return [
                createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.sentence.create_article")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</li><li class="${ssrRenderClass({ active: isActive(["admin.article.tags"]) })}">`);
        _push(ssrRenderComponent(unref(Link), {
          onClick: closeSidebarInDevice,
          href: _ctx.route("admin.article.tags.index")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.tags"))}</span>`);
            } else {
              return [
                createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.word.tags")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</li><li class="${ssrRenderClass({ active: isActive(["admin.articles.trash"]) })}">`);
        _push(ssrRenderComponent(unref(Link), {
          onClick: closeSidebarInDevice,
          href: _ctx.route("admin.articles.trash")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.trash"))}</span>`);
            } else {
              return [
                createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.word.trash")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</li></ul></li>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.$page.props.auth.can["manage-article-comments"]) {
        _push(`<li class="${ssrRenderClass({ "menu-item": true, active: isActive(["admin.article.comments"]) })}">`);
        _push(ssrRenderComponent(unref(Link), {
          onClick: closeSidebarInDevice,
          href: _ctx.route("admin.article.comments.index")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<i class="ri-message-3-line"${_scopeId}></i><span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.comments"))}</span>`);
              if (_ctx.$page.props.auth.adminBadges["waiting-article-comments"] > 0) {
                _push2(`<span class="count-badge shadow-1"${_scopeId}>${ssrInterpolate(_ctx.$page.props.auth.adminBadges["waiting-article-comments"])}</span>`);
              } else {
                _push2(`<!---->`);
              }
            } else {
              return [
                createVNode("i", { class: "ri-message-3-line" }),
                createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.word.comments")), 1),
                _ctx.$page.props.auth.adminBadges["waiting-article-comments"] > 0 ? (openBlock(), createBlock("span", {
                  key: 0,
                  class: "count-badge shadow-1"
                }, toDisplayString(_ctx.$page.props.auth.adminBadges["waiting-article-comments"]), 1)) : createCommentVNode("", true)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</li>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.$page.props.auth.can["manage-article-categories"]) {
        _push(`<li class="${ssrRenderClass({ "menu-item": true, active: isActive(["admin.article.categories"]) })}">`);
        _push(ssrRenderComponent(unref(Link), {
          onClick: closeSidebarInDevice,
          href: _ctx.route("admin.article.categories.index")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<i class="ri-list-check"${_scopeId}></i><span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.categories"))}</span>`);
            } else {
              return [
                createVNode("i", { class: "ri-list-check" }),
                createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.word.categories")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</li>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<li class="title">${ssrInterpolate(_ctx.$t("messages.sentence.management_affairs"))}</li><li class="${ssrRenderClass({ "menu-item": true, active: isActive(["admin.files.index"]) })}">`);
      _push(ssrRenderComponent(unref(Link), {
        onClick: closeSidebarInDevice,
        href: _ctx.route("admin.files.index")
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<i class="ri-upload-cloud-line"${_scopeId}></i><span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.sentence.media_library"))}</span>`);
          } else {
            return [
              createVNode("i", { class: "ri-upload-cloud-line" }),
              createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.sentence.media_library")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</li>`);
      if (_ctx.$page.props.auth.can["manage-users"]) {
        _push(`<li class="${ssrRenderClass({ "menu-item": true, accordion: true, active: isActive(["admin.users", "admin.roles", "admin.admin.list"]) })}"><a href="javascript:void(0)" data-bs-toggle="collapse" data-bs-target="#usersItem"${ssrRenderAttr("aria-expanded", isActive(["admin.users", "admin.roles", "admin.admin.list"]))} aria-controls="usersItem"><i class="ri-user-6-line"></i><span class="item-title">${ssrInterpolate(_ctx.$t("messages.word.users"))}</span><span class="according-menu"><i class="ri-arrow-right-s-line"></i></span></a><ul id="usersItem" data-bs-parent="#sidebarAccordion" class="${ssrRenderClass({ "sub-menu": true, collapse: true, show: isActive(["admin.users", "admin.roles", "admin.admin.list"]) })}"><li class="${ssrRenderClass({ active: isActive(["admin.users.index"]) })}">`);
        _push(ssrRenderComponent(unref(Link), {
          onClick: closeSidebarInDevice,
          href: _ctx.route("admin.users.index")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.list") + " " + _ctx.$t("messages.word.users"))}</span>`);
            } else {
              return [
                createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.word.list") + " " + _ctx.$t("messages.word.users")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</li>`);
        if (_ctx.$page.props.auth.can["owner"]) {
          _push(`<li class="${ssrRenderClass({ active: isActive(["admin.admin.list"]) })}">`);
          _push(ssrRenderComponent(unref(Link), {
            onClick: closeSidebarInDevice,
            href: _ctx.route("admin.admin.list")
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.list") + " " + _ctx.$t("messages.word.admins"))}</span>`);
              } else {
                return [
                  createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.word.list") + " " + _ctx.$t("messages.word.admins")), 1)
                ];
              }
            }),
            _: 1
          }, _parent));
          _push(`</li>`);
        } else {
          _push(`<!---->`);
        }
        if (_ctx.$page.props.auth.can["owner"]) {
          _push(`<li class="${ssrRenderClass({ active: isActive(["admin.roles.index"]) })}">`);
          _push(ssrRenderComponent(unref(Link), {
            onClick: closeSidebarInDevice,
            href: _ctx.route("admin.roles.index")
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.sentence.roles_and_permissions"))}</span>`);
              } else {
                return [
                  createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.sentence.roles_and_permissions")), 1)
                ];
              }
            }),
            _: 1
          }, _parent));
          _push(`</li>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</ul></li>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.$page.props.auth.can["manage-menus"]) {
        _push(`<li class="${ssrRenderClass({ "menu-item": true, active: isActive(["admin.menus"]) })}">`);
        _push(ssrRenderComponent(unref(Link), {
          onClick: closeSidebarInDevice,
          href: _ctx.route("admin.menus.index")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<i class="ri-menu-4-line"${_scopeId}></i><span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.menus"))}</span>`);
            } else {
              return [
                createVNode("i", { class: "ri-menu-4-line" }),
                createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.word.menus")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</li>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.$page.props.auth.can["manage-pages"]) {
        _push(`<li class="${ssrRenderClass({ "menu-item": true, active: isActive(["admin.pages"]) })}">`);
        _push(ssrRenderComponent(unref(Link), {
          onClick: closeSidebarInDevice,
          href: _ctx.route("admin.pages.index")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<i class="ri-file-list-2-line"${_scopeId}></i><span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.pages"))}</span>`);
            } else {
              return [
                createVNode("i", { class: "ri-file-list-2-line" }),
                createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.word.pages")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</li>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.$page.props.auth.can["manage-products"]) {
        _push(`<li class="${ssrRenderClass({ "menu-item": true, active: isActive(["admin.searches"]) })}">`);
        _push(ssrRenderComponent(unref(Link), {
          onClick: closeSidebarInDevice,
          href: _ctx.route("admin.searches.index")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<i class="ri-question-mark"${_scopeId}></i><span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.searches"))}</span>`);
            } else {
              return [
                createVNode("i", { class: "ri-question-mark" }),
                createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.word.searches")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</li>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.$page.props.auth.can["manage-newsletters"]) {
        _push(`<li class="${ssrRenderClass({ "menu-item": true, active: isActive(["admin.newsletters"]) })}">`);
        _push(ssrRenderComponent(unref(Link), {
          onClick: closeSidebarInDevice,
          href: _ctx.route("admin.newsletters.index")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<i class="ri-megaphone-line"${_scopeId}></i><span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.newsletters"))}</span>`);
            } else {
              return [
                createVNode("i", { class: "ri-megaphone-line" }),
                createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.word.newsletters")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</li>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.$page.props.auth.can["manage-template"]) {
        _push(`<li class="${ssrRenderClass({ "menu-item": true, active: isActive(["admin.templates"]) })}">`);
        _push(ssrRenderComponent(unref(Link), {
          onClick: closeSidebarInDevice,
          href: _ctx.route("admin.templates.index")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<i class="ri-brush-line"${_scopeId}></i><span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.sentence.manage_template"))}</span>`);
            } else {
              return [
                createVNode("i", { class: "ri-brush-line" }),
                createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.sentence.manage_template")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</li>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.$page.props.auth.can["change-settings"]) {
        _push(`<li class="${ssrRenderClass({ "menu-item": true, active: isActive(["admin.settings.edit"]) })}">`);
        _push(ssrRenderComponent(unref(Link), {
          onClick: closeSidebarInDevice,
          href: _ctx.route("admin.settings.edit")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<i class="ri-settings-3-line"${_scopeId}></i><span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.sentence.main_settings"))}</span>`);
            } else {
              return [
                createVNode("i", { class: "ri-settings-3-line" }),
                createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.sentence.main_settings")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</li>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.$page.props.auth.can["owner"]) {
        _push(`<li class="${ssrRenderClass({ "menu-item": true, active: isActive(["admin.web_service"]) })}">`);
        _push(ssrRenderComponent(unref(Link), {
          onClick: closeSidebarInDevice,
          href: _ctx.route("admin.web_service.index")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<i class="ri-key-line"${_scopeId}></i><span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.web_service"))}</span>`);
            } else {
              return [
                createVNode("i", { class: "ri-key-line" }),
                createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.word.web_service")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</li>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.$page.props.panelDetails.is_host) {
        _push(`<!--[-->`);
        if (_ctx.$page.props.auth.can["owner"]) {
          _push(`<li class="${ssrRenderClass({ "menu-item": true, active: isActive(["admin.updater.index"]) })}">`);
          _push(ssrRenderComponent(unref(Link), {
            onClick: closeSidebarInDevice,
            href: _ctx.route("admin.updater.index")
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<i class="ri-loop-left-line"${_scopeId}></i><span class="item-title"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.sentence.update_script"))}</span>`);
              } else {
                return [
                  createVNode("i", { class: "ri-loop-left-line" }),
                  createVNode("span", { class: "item-title" }, toDisplayString(_ctx.$t("messages.sentence.update_script")), 1)
                ];
              }
            }),
            _: 1
          }, _parent));
          _push(`</li>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<!--]-->`);
      } else {
        _push(`<!---->`);
      }
      _push(`</ul></div></nav>`);
    };
  }
});
const _sfc_setup$2 = _sfc_main$2.setup;
_sfc_main$2.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Admin/Sidebar.vue");
  return _sfc_setup$2 ? _sfc_setup$2(props, ctx) : void 0;
};
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "Header",
  __ssrInlineRender: true,
  props: {
    sidebar: { type: Boolean }
  },
  emits: ["updateSidebar"],
  setup(__props, { emit: __emit }) {
    const emit = __emit;
    if (typeof window !== "undefined") {
      if (window.innerWidth <= 1200) {
        emit("updateSidebar", false);
      }
      $(window).on("resize", () => {
        if (window.innerWidth <= 1200) emit("updateSidebar", false);
        else emit("updateSidebar", true);
      });
    }
    const dark = ref(usePage().props.dark);
    if (typeof window !== "undefined") {
      if (dark.value) {
        $("body").attr("id", "dark");
      } else {
        $("body").attr("id", "light");
      }
    }
    const isActive = (values) => {
      for (let value of values) {
        if (typeof window !== "undefined") {
          if (!usePage().props.currentRouteName.includes(value)) {
            continue;
          }
          return usePage().props.currentRouteName.includes(value);
        }
      }
      return false;
    };
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<header${ssrRenderAttrs(mergeProps({
        class: _ctx.sidebar ? "page-header" : "page-header full"
      }, _attrs))}><div class="header-inner"><div class="d-flex align-items-center"><span style="${ssrRenderStyle(!_ctx.sidebar ? null : { display: "none" })}" class="sidebar-toggle"><i class="ri-menu-4-fill"></i></span><a class="${ssrRenderClass({ "d-none d-sm-block btn btn-light lts-05 fs-8 px-3 br-10": true, "ms-3": !_ctx.sidebar })}"${ssrRenderAttr("href", _ctx.route("index"))} target="_blank">${ssrInterpolate(_ctx.$t("messages.sentence.show_store"))}</a><a class="${ssrRenderClass({ "d-block d-sm-none link text-dark lts-05 fs-5": true, "ms-3": !_ctx.sidebar })}"${ssrRenderAttr("href", _ctx.route("index"))} target="_blank"><i class="ri-store-2-line"></i></a></div><ul class="header-meta">`);
      if (_ctx.$page.props.auth.can["change-settings"]) {
        _push(`<li>`);
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("admin.settings.edit")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<i class="ri-settings-3-line"${_scopeId}></i>`);
            } else {
              return [
                createVNode("i", { class: "ri-settings-3-line" })
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</li>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<li>`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("admin.notifications.index")
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<i class="ri-notification-3-line"${_scopeId}></i><span class="count-badge"${_scopeId}>${ssrInterpolate(_ctx.$page.props.notificationCount)}</span>`);
          } else {
            return [
              createVNode("i", { class: "ri-notification-3-line" }),
              createVNode("span", { class: "count-badge" }, toDisplayString(_ctx.$page.props.notificationCount), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</li><li id="darkLight"><button><i class="${ssrRenderClass(dark.value ? "ri-sun-line" : "ri-moon-line")}"></i></button></li><li><a href="javascript:void(0)"><i class="ri-fullscreen-line"></i></a></li><li class="user-avatar dropdown"><img class="shadow-1" data-bs-toggle="dropdown"${ssrRenderAttr("src", _ctx.$page.props.auth.user.get_avatar)} width="40" height="40"${ssrRenderAttr("alt", _ctx.$page.props.auth.user.get_name)}><div data-bs-toggle="dropdown" class="d-md-block d-none"><span class="user-name">${ssrInterpolate(_ctx.$page.props.auth.user.get_name)}</span><span class="user-type">${ssrInterpolate(_ctx.$page.props.auth.user.role.label)}</span></div><div class="dropdown-menu shadow-1"><ul><li>`);
      _push(ssrRenderComponent(unref(Link), {
        class: { "dropdown-item": true, "lts-05": true, active: isActive(["admin.profile.edit"]) },
        href: _ctx.route("admin.profile.edit")
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<i class="ri-user-smile-line"${_scopeId}></i> ${ssrInterpolate(_ctx.$t("messages.sentence.edit_profile"))}`);
          } else {
            return [
              createVNode("i", { class: "ri-user-smile-line" }),
              createTextVNode(" " + toDisplayString(_ctx.$t("messages.sentence.edit_profile")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</li><li>`);
      _push(ssrRenderComponent(unref(Link), {
        class: { "dropdown-item": true, "lts-05": true, active: isActive(["admin.profile.sessions"]) },
        href: _ctx.route("admin.profile.sessions")
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<i class="ri-device-line"${_scopeId}></i> ${ssrInterpolate(_ctx.$t("messages.sentence.active_sessions"))}`);
          } else {
            return [
              createVNode("i", { class: "ri-device-line" }),
              createTextVNode(" " + toDisplayString(_ctx.$t("messages.sentence.active_sessions")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</li><li>`);
      _push(ssrRenderComponent(unref(Link), {
        class: { "dropdown-item": true, "lts-05": true, active: isActive(["admin.notifications.index"]) },
        href: _ctx.route("admin.notifications.index")
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<i class="ri-notification-3-line"${_scopeId}></i> ${ssrInterpolate(_ctx.$t("messages.word.notifications"))}`);
          } else {
            return [
              createVNode("i", { class: "ri-notification-3-line" }),
              createTextVNode(" " + toDisplayString(_ctx.$t("messages.word.notifications")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</li><li>`);
      _push(ssrRenderComponent(unref(Link), {
        class: "dropdown-item lts-05",
        method: "post",
        href: _ctx.route("logout"),
        as: "button"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<i class="ri-logout-circle-r-line"${_scopeId}></i> ${ssrInterpolate(_ctx.$t("messages.word.logout"))}`);
          } else {
            return [
              createVNode("i", { class: "ri-logout-circle-r-line" }),
              createTextVNode(" " + toDisplayString(_ctx.$t("messages.word.logout")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</li></ul></div></li></ul></div></header>`);
    };
  }
});
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Admin/Header.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "AdminLayout",
  __ssrInlineRender: true,
  props: {
    mediaLibrary: {},
    keyword: {}
  },
  setup(__props) {
    const dark = ref(usePage().props.dark);
    if (typeof window !== "undefined") {
      $(() => {
        let config = { attributes: true, attributeFilter: ["id"] };
        let callback = function(mutationsList, observer2) {
          for (let mutation of mutationsList) {
            if (mutation.type === "attributes" && mutation.attributeName === "id") {
              if (document.body.id == "dark") dark.value = true;
              else dark.value = false;
            }
          }
        };
        let observer = new MutationObserver(callback);
        observer.observe(document.body, config);
      });
    }
    if (typeof window !== "undefined") {
      $(() => {
        window.jalaliDatepicker.startWatch({});
      });
    }
    if (typeof window !== "undefined") {
      $(() => {
        window.ResizeObserver = ResizeObserver;
        document.querySelectorAll(".simplebar-container").forEach((el) => {
          new SimpleBar(el, {
            autoHide: false
          });
        });
      });
    }
    const errorMessages = computed(() => usePage().props.errors);
    watch(errorMessages, (errors) => {
      for (let i in errors) {
        useToast(errors[i], "fail", 4e3);
      }
      if (errorMessages.value != null && Object.keys(errorMessages.value).length > 0) {
        router.reload({ only: ["errors"] });
      }
    });
    const flashMessage = computed(() => {
      if (typeof usePage().props.flash !== "undefined") return usePage().props.flash.message;
      return [];
    });
    watch(flashMessage, (messages) => {
      for (let i in messages) {
        useToast(messages[i], "success", 4e3);
      }
      if (flashMessage.value != null && Object.keys(flashMessage.value).length > 0) {
        router.reload({ only: ["flash"] });
      }
    });
    const sidebar = ref(true);
    const updateSidebar = (value) => {
      sidebar.value = value;
    };
    if (typeof window !== "undefined") {
      if (window.innerWidth <= 1200) sidebar.value = false;
      $(window).on("resize", () => {
        if (window.innerWidth <= 1200) sidebar.value = false;
        else sidebar.value = true;
      });
    }
    const mediaReactive = reactive({
      id: 0,
      type: "",
      file: null
    });
    const mediaData = (value) => {
      mediaReactive.id = value.id;
      mediaReactive.type = value.type;
      mediaReactive.file = value.file;
    };
    provide("mediaData", mediaReactive);
    onMounted(() => {
      document.documentElement.style.setProperty("--primary", "rgb(0, 96, 255)");
      document.documentElement.style.setProperty("--primary-rgb", "0, 96, 255");
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), null, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<link rel="icon" type="image/x-icon"${ssrRenderAttr("href", _ctx.$page.props.appFavicon)}${_scopeId}><meta name="theme-color"${ssrRenderAttr("content", dark.value ? "#262631" : unref(usePage)().props.template != null ? unref(usePage)().props.template.get_options.style.site_main_color : "#1c1c25")}${_scopeId}><meta name="robots" content="noindex,nofollow"${_scopeId}><meta name="googlebot" content="noindex"${_scopeId}>`);
          } else {
            return [
              createVNode("link", {
                rel: "icon",
                type: "image/x-icon",
                href: _ctx.$page.props.appFavicon
              }, null, 8, ["href"]),
              createVNode("meta", {
                name: "theme-color",
                content: dark.value ? "#262631" : unref(usePage)().props.template != null ? unref(usePage)().props.template.get_options.style.site_main_color : "#1c1c25"
              }, null, 8, ["content"]),
              createVNode("meta", {
                name: "robots",
                content: "noindex,nofollow"
              }),
              createVNode("meta", {
                name: "googlebot",
                content: "noindex"
              })
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`<div class="page-wrapper">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        sidebar: sidebar.value,
        onUpdateSidebar: updateSidebar
      }, null, _parent));
      _push(ssrRenderComponent(_sfc_main$1, {
        sidebar: sidebar.value,
        onUpdateSidebar: updateSidebar
      }, null, _parent));
      _push(`<div class="${ssrRenderClass(sidebar.value ? "page-content" : "page-content full")}">`);
      ssrRenderSlot(_ctx.$slots, "default", {}, null, _push, _parent);
      _push(`</div><footer class="page-footer"></footer></div>`);
      _push(ssrRenderComponent(_sfc_main$3, {
        mediaLibrary: _ctx.mediaLibrary,
        keyword: _ctx.keyword,
        onMediaData: mediaData
      }, null, _parent));
      if (sidebar.value) {
        _push(`<div class="sidebar-black-mask"></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Layouts/AdminLayout.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as _
};
