import { defineComponent, mergeProps, unref, withCtx, createBlock, openBlock, toDisplayString, createTextVNode, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrRenderComponent, ssrRenderAttr, ssrInterpolate, ssrIncludeBooleanAttr } from "vue/server-renderer";
import { _ as _sfc_main$1 } from "./AuthLayout-DZ-VIaI_.js";
import { useForm, Link } from "@inertiajs/vue3";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
import "./useHexToRgb-G7J9N7Ap.js";
/* empty css             */
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "AccountInformation",
  __ssrInlineRender: true,
  props: {
    name: {},
    email: {},
    username: {},
    prev: {}
  },
  setup(__props) {
    const props = __props;
    const accountInformationForm = useForm({
      name: props.name,
      email: props.email,
      username: null,
      prev: props.prev
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "auth-container" }, _attrs))}><div class="logo-container">`);
      _push(ssrRenderComponent(unref(Link), {
        class: "logo",
        href: _ctx.route("index")
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            if (_ctx.$page.props.appLogo != null) {
              _push2(`<img${ssrRenderAttr("src", _ctx.$page.props.appLogo)}${ssrRenderAttr("alt", _ctx.$page.props.appFullName)}${_scopeId}>`);
            } else {
              _push2(`<span${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.logo"))}</span>`);
            }
          } else {
            return [
              _ctx.$page.props.appLogo != null ? (openBlock(), createBlock("img", {
                key: 0,
                src: _ctx.$page.props.appLogo,
                alt: _ctx.$page.props.appFullName
              }, null, 8, ["src", "alt"])) : (openBlock(), createBlock("span", { key: 1 }, toDisplayString(_ctx.$t("messages.word.logo")), 1))
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div><div class="card shadow-1"><div class="card-body"><div class="auth-title lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.complete_account_infromation"))}</div><form class="auth-form"><div class="form-element-row mb-3"><input${ssrRenderAttr("value", unref(accountInformationForm).name)} type="text" required autocomplete="name" name="name" autofocus class="form-control"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.full_name"))}>`);
      if ("name" in unref(accountInformationForm).errors) {
        _push(`<span class="form-error-msg d-flex lts-05 mt-2">${ssrInterpolate(unref(accountInformationForm).errors.name)}</span>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div><div class="form-element-row mb-3"><input${ssrRenderAttr("value", unref(accountInformationForm).email)} type="text" autocomplete="email" name="email" class="form-control"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.email") + " (" + _ctx.$t("messages.word.optional") + ")")} dir="auto">`);
      if ("email" in unref(accountInformationForm).errors) {
        _push(`<span class="form-error-msg d-flex lts-05 mt-2">${ssrInterpolate(unref(accountInformationForm).errors.email)}</span>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div><div class="form-element-row mb-4"><input${ssrRenderAttr("value", unref(accountInformationForm).username)} type="text" minlength="4" maxlength="20" class="form-control"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.username") + " (" + _ctx.$t("messages.word.optional") + ")")} dir="auto">`);
      if ("username" in unref(accountInformationForm).errors) {
        _push(`<span class="form-error-msg d-flex lts-05 mt-2">${ssrInterpolate(unref(accountInformationForm).errors.username)}</span>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<span class="form-control-description">${ssrInterpolate(_ctx.$t("messages.sentence.username_hint"))}</span></div><div class="form-element-row mb-3"><button class="btn btn-primary" type="submit"${ssrIncludeBooleanAttr(unref(accountInformationForm).processing) ? " disabled" : ""}>${ssrInterpolate(_ctx.$t("messages.word.finish"))}</button></div><div class="form-element-row"><div class="privacy-notice lts-05">${_ctx.$t("messages.sentence.login_mean_is_accept_terms", {
        terms: `<a href='${_ctx.route("main.pages.show", "terms")}' target='_blank' class='link'> ${_ctx.$t("messages.word.terms")} </a>`
      }) ?? ""}</div></div></form></div></div><div class="auth-footer">`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("index"),
        class: "lts-05"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("messages.sentence.home_page"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("messages.sentence.home_page")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`<span></span>`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("main.products.index"),
        class: "lts-05"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("messages.sentence.product_archive"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("messages.sentence.product_archive")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div></div>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Auth/AccountInformation.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
