<?php

namespace App\Services\Plugins\Sms;

use GuzzleHttp\Client;

class KavenegarService
{
    private static $url = "https://api.kavenegar.com/v1/";
    private static $apiKey;
    private static $otpUrl;

    // service construct
    private static function init($smsPanel)
    {
        static::$apiKey = $smsPanel['fields']['information']['api_key'];
        static::$otpUrl = static::$url . static::$apiKey . '/verify/lookup.json?';
    }

    /** send sms */
    public static function send($smsPanel, $receptor, $template, $params)
    {
        // init
        static::init($smsPanel);

        // validate template pattern
        $template = $smsPanel['fields']['pattern'][$template]['value'];

        // validate params
        $newParams = [];
        foreach ($params as $key => $param) {
            if ($key == 'token') {
                $newParams['token'] = $param;
            } else if ($key == 'token2') {
                $newParams['token2'] = $param;
            } else if ($key == 'token3') {
                $newParams['token3'] = $param;
            }
        }

        // guzzle client
        $client = new Client();

        // handle data
        $data = [
            'receptor' => $receptor,
            'template' => $template,
            ...$newParams
        ];

        // send request
        $result = $client->request('GET', static::$otpUrl . http_build_query($data));

        return $result->getStatusCode() == 200 ? true : false;
    }
}
