<?php

namespace App\Services\Plugins\Sms;

use GuzzleHttp\Client;

class GhasedakService
{
    private static $url = "https://gateway.ghasedak.me/rest/api/v1/WebService/SendOtpSMS";
    private static $apiKey = null;

    // service construct
    private static function init($smsPanel)
    {
        static::$apiKey = $smsPanel['fields']['information']['api_key'];
    }

    /** send sms */
    public static function send($smsPanel, $receptor, $template, $params)
    {
        // init
        static::init($smsPanel);

        // validate template pattern
        $template = $smsPanel['fields']['pattern'][$template]['value'];

        // validate params
        $newParams = [];
        foreach ($params as $key => $param) {
            if ($key == 'token') {
                $newParams['token_one'] = $param;
            } else if ($key == 'token2') {
                $newParams['token_two'] = $param;
            } else if ($key == 'token3') {
                $newParams['token_three'] = $param;
            }
        }
        $newParamsArr = [];
        foreach ($newParams as $key => $value) {
            $newParamsArr[] = [
                "param" => $key,
                "value" => $value
            ];
        }

        // guzzle client
        $client = new Client();

        // data
        $data = [
            'templateName' => $template,
            'receptors' => [
                [
                    'mobile' => $receptor,
                ]
            ],
            "inputs" => $newParamsArr,
        ];

        // headers
        $headers = [
            'Content-Type' => 'application/json',
            'ApiKey' => static::$apiKey,
        ];

        // send request
        $result = $client->request('POST', static::$url, [
            'json' => $data,
            'headers' => $headers,
            'verify' => false,
        ]);

        return $result->getStatusCode() == 200 ? true : false;
    }
}
