<?php

namespace App\Services\Main\Products;

use App\Models\Compare;
use App\Models\Product;
use App\Models\ProductCategory;
use Illuminate\Http\Request;

class CompareService
{
    /** get searchable products */
    public function getSearchProducts(Request $request, $compares)
    {
        $compareProductsIDs = array_map(function ($x) {
            return $x['id'];
        }, $compares->toArray());

        // get all product
        $products = Product::where('status', 'publish')
            ->when($request->input('search'), function ($query, $search) {
                $query->where('title', 'like', "%{$search}%");
            })->paginate(8)->through(fn($product) => [
                'id' => $product->id,
                'title' => $product->title,
                'slug' => $product->slug,
                'get_images' => $product->get_images,
                'comments_info' => $product->comments_info,
                'in_stock_status' => $product->in_stock_status,
                'inventory' => $product->inventory,
                'best_normal_price' => $product->best_normal_price,
                'unique_color' => $product->unique_color,
            ]);

        // get current category products
        if (isset($compares[0])) {
            $products = Product::where('status', 'publish')
                ->whereNotIn('id', $compareProductsIDs)
                ->where('category_id', $compares[0]['category']['id'])
                ->when($request->input('search'), function ($query, $search) {
                    $query->where('title', 'like', "%{$search}%");
                })->paginate(8)->through(fn($product) => [
                    'id' => $product->id,
                    'title' => $product->title,
                    'slug' => $product->slug,
                    'get_images' => $product->get_images,
                    'comments_info' => $product->comments_info,
                    'in_stock_status' => $product->in_stock_status,
                    'inventory' => $product->inventory,
                    'best_normal_price' => $product->best_normal_price,
                    'unique_color' => $product->unique_color,
                ]);
        }

        $products->withQueryString();

        return $products;
    }

    /** get compares products */
    public function getComparesProducts($user)
    {
        $products = $user->compares()->get()->map(fn($compare) => [
            'compare_id' => $compare->id,
            'id' => $compare->product->id,
            'title' => $compare->product->title,
            'slug' => $compare->product->slug,
            'get_images' => $compare->product->get_images,
            'in_stock_status' => $compare->product->in_stock_status,
            'inventory' => $compare->product->inventory,
            'best_normal_price' => $compare->product->best_normal_price,
            'get_specifications' => $compare->product->get_specifications,
            'category' => [
                'id' => $compare->product->productCategory->id
            ],
        ]);

        return $products;
    }

    /** get compares products */
    public function validateComparesCategory($compares)
    {
        if (isset($compares[0])) {
            $category = $compares[0]['category']['id'];

            foreach ($compares as $compare) {
                if ($compare['category']['id'] != $category) {
                    Compare::where('id', $compare['compare_id'])->delete();
                }
            }
        }
    }

    /** get compares products */
    public function isComparesCategorySame($compares, $product)
    {
        if (isset($compares[0])) {
            $category = $compares[0]['category']['id'];

            if ($category != $product->category['id']) {
                return false;
            }
        }

        return true;
    }
}
