<?php

namespace App\Services\Main\Mobile;

use App\Models\ArticleCategory;
use App\Models\Brand;
use App\Models\ProductCategory;
use App\Models\Setting;

class CategoriesService
{
    /** seo meta data */
    public array $seo = [
        'schema' => null,
        'site_name' => null,
        'title' => null,
        'store_name' => null,
        'description' => null,
        'keywords' => null,
        'canonical' => null,
        'author' => null,
        'image' => null,
        'type' => null,
    ];

    /**
     * shop category list
     */
    public function productCategoryList()
    {
        return ProductCategory::where('status', 'publish')->where('parent_id', 0)->get()->map(fn($catLevel1) => [
            'id' => $catLevel1->id,
            'title' => $catLevel1->title,
            'slug' => $catLevel1->slug,
            'get_image' => $catLevel1->get_image,
            'childs' => $catLevel1->childs->map(fn($catLevel2) => [
                'id' => $catLevel2['id'],
                'title' => $catLevel2['title'],
                'slug' => $catLevel2['slug'],
                'get_image' => $catLevel2['get_image'],
                'childs' => $catLevel2['childs']->map(fn($catLevel3) => [
                    'id' => $catLevel3['id'],
                    'title' => $catLevel3['title'],
                    'slug' => $catLevel3['slug'],
                    'get_image' => $catLevel3['get_image'],
                    'childs' => null
                ])
            ])
        ]);
    }

    /**
     * shop category list
     */
    public function articleCategoryList()
    {
        return ArticleCategory::where('status', 'publish')->get()->map(fn($category) => [
            'id' => $category->id,
            'title' => $category->title,
            'slug' => $category->slug,
            'get_last_article_image' => $category->get_last_article_image,
        ]);
    }

    /**
     * shop category list
     */
    public function brandList()
    {
        return Brand::where('status', 'publish')->get()->map(fn($category) => [
            'id' => $category->id,
            'title' => $category->title,
            'slug' => $category->slug,
            'get_logo' => $category->get_logo,
        ]);
    }

    /** seo information */
    public function seo()
    {
        $shopFullTitle = Setting::where('key', 'shop_full_title')->first() != null ? Setting::where('key', 'shop_full_title')->first()->value : null;
        $shopDescription = Setting::where('key', 'shop_description')->first() != null ? Setting::where('key', 'shop_description')->first()->value : null;

        // schema
        $this->seo['schema'] = $this->indexSchema();

        // main
        $this->seo['site_name'] = $shopFullTitle;
        $this->seo['title'] = __('messages.word.categories');
        $this->seo['description'] = $shopDescription;

        // return information
        return $this->seo;
    }

    /** Product Schema */
    public function indexSchema()
    {
        $mainCategories = [];
        $categories = ProductCategory::where('status', 'publish')->orderBy('created_at', 'desc')->take(10)->get();
        foreach ($categories as $key => $category) {
            $mainCategories[] = [
                "@type" => "ListItem",
                "position" => $key + 1,
                "name" => $category->title,
                "url" => route('main.products.index', ['cat' => $category->slug])
            ];
        }

        $schema = [
            [
                "@context" => "https://schema.org",
                "@type" => "ItemList",
                "url" => route('index'),
                "itemListElement" => $mainCategories
            ]
        ];

        return json_encode($schema, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
    }
}
