<?php

namespace App\Services\Admin\Tickets;

use App\Models\Ticket;
use Illuminate\Http\Request;

class TicketsService
{
    /** get Ticket list */
    public function getTickets(Request $request)
    {
        /** @var LengthAwarePaginator */
        $tickets = Ticket::query()->with('user')->when($request->input('search'), function ($query, $search) {
            $query->where('title', 'like', "%{$search}%");
        })->when($request->input('waiting_admin'), function ($query, $waiting_admin) {
            if ($waiting_admin) {
                $query->where('status', 'waiting_admin');
            }
        })->when($request->input('waiting_user'), function ($query, $waiting_user) {
            if ($waiting_user) {
                $query->where('status', 'waiting_user');
            }
        })->when($request->input('closed'), function ($query, $closed) {
            if ($closed) {
                $query->where('status', 'closed');
            }
        })->when($request->input('users'), function ($query, $users) {
            if ($users) {
                $query->whereHas('user', function ($query) {
                    $query->where('seller', false);
                });
            }
        })->when($request->input('sellers'), function ($query, $sellers) {
            if ($sellers) {
                $query->whereHas('user', function ($query) {
                    $query->where('seller', true);
                });
            }
        })->orderByRaw("FIELD(status , 'waiting_admin', 'waiting_user', 'closed') ASC")
            ->orderByRaw("FIELD(priority , 'high', 'normal', 'low') ASC")
            ->orderBy('updated_at', 'asc')->paginate(20)->through(fn($ticket) => [
                'id' => $ticket->id,
                'user_id' => $ticket->user_id,
                'title' => $ticket->title,
                'priority' => $ticket->priority,
                'jalali_updated_at' => $ticket->jalali_updated_at,
                'status' => $ticket->status,
                'user' => [
                    'id' => $ticket->user->id,
                    'get_name' => $ticket->user->get_name,
                    'type' => $ticket->user->type,
                    'seller' => $ticket->user->seller,
                ],
            ]);

        $tickets->withQueryString();

        return $tickets;
    }
}
