<?php

namespace App\Services\Admin\Products;

use App\Models\ProductComment;
use Illuminate\Http\Request;

class ProductCommentsService
{
    /** get comment list */
    public function getComments(Request $request)
    {
        /** @var LengthAwarePaginator */
        $comments = ProductComment::query()->when($request->input('awaiting'), function ($query, $awaiting) {
            if ($awaiting) {
                $query->where('status', 'awaiting')->orderBy('created_at', 'asc');
            }
        })->when($request->input('publish'), function ($query, $publish) {
            if ($publish) {
                $query->where('status', 'publish')->orderBy('created_at', 'desc');
            }
        })->when($request->input('reported'), function ($query, $reported) {
            if ($reported) {
                $query->where('status', '!=', 'awaiting')->where('reported', true);
            }
        })->orderByRaw("FIELD(status , 'awaiting', 'publish') ASC")->orderBy('created_at', 'desc')->with('user')->with('product')->paginate(10)->through(fn($comment) => [
            'id' => $comment->id,
            'user_id' => $comment->user_id,
            'content' => $comment->content,
            'get_strengths' => $comment->get_strengths,
            'get_weakness' => $comment->get_weakness,
            'get_answer' => $comment->get_answer,
            'reported' => $comment->reported,
            'vote_up' => $comment->vote_up,
            'vote_down' => $comment->vote_down,
            'rating' => $comment->rating,
            'jalali_created_at' => $comment->jalali_created_at,
            'buy_suggest' => $comment->buy_suggest,
            'get_images' => $comment->get_images,
            'is_buyer' => $comment->is_buyer,
            'status' => $comment->status,

            'product' => [
                'id' => $comment->product->id,
                'title' => $comment->product->title,
                'slug' => $comment->product->slug,
            ],
            'user' => [
                'id' => $comment->user->id,
                'get_name' => $comment->user->get_name,
                'type' => $comment->user->type
            ],
        ]);

        $comments->withQueryString();

        return $comments;
    }
}
