<?php

namespace App\Services\Admin\Pages;

use App\Models\Page;
use Illuminate\Http\Request;

class PagesService
{
    /** init system forms */
    public function createSystemPages()
    {
        if (Page::where('slug', 'about-us')->first() == null) {
            Page::create([
                'uuid' => 'page-' . rand(1000000, 9999999),
                'title' => __('messages.system_page_about_us'),
                'slug' => 'about-us',
                'content' => '',
                'seo_title' => __('messages.system_page_about_us'),
                'seo_description' => null,
                'seo_keywords' => null,
                'seo_canonical' => null,
                'flag' => 'system',
                'status' => 'publish',
            ]);
        }
        if (Page::where('slug', 'terms')->first() == null) {
            Page::create([
                'uuid' => 'page-' . rand(1000000, 9999999),
                'title' => __('messages.system_page_terms'),
                'slug' => 'terms',
                'content' => '',
                'seo_title' => __('messages.system_page_terms'),
                'seo_description' => null,
                'seo_keywords' => null,
                'seo_canonical' => null,
                'flag' => 'system',
                'status' => 'publish',
            ]);
        }
        if (Page::where('slug', 'seller-guide')->first() == null) {
            Page::create([
                'uuid' => 'page-' . rand(1000000, 9999999),
                'title' => __('messages.system_page_seller_guide'),
                'slug' => 'seller-guide',
                'content' => '',
                'seo_title' => __('messages.system_page_seller_guide'),
                'seo_description' => null,
                'seo_keywords' => null,
                'seo_canonical' => null,
                'flag' => 'system',
                'status' => 'publish',
            ]);
        }
    }

    /** get page list */
    public function getPages(Request $request)
    {
        /** @var LengthAwarePaginator */
        $pages = Page::query()->when($request->input('search'), function ($query, $search) {
            $query->where('title', 'like', "%{$search}%");
        })->when($request->input('publish'), function ($query, $publish) {
            if ($publish) {
                $query->where('status', 'publish');
            }
        })->when($request->input('draft'), function ($query, $draft) {
            if ($draft) {
                $query->where('status', 'draft');
            }
        })->orderBy('created_at', 'desc')->paginate(20)->through(fn($page) => [
            'id' => $page->id,
            'title' => $page->title,
            'slug' => $page->slug,
            'get_formatted_view_count' => $page->get_formatted_view_count,
            'flag' => $page->flag,
            'jalali_updated_at' => $page->jalali_updated_at,
            'status' => $page->status,
        ]);

        $pages->withQueryString();

        return $pages;
    }
}