<?php

namespace App\Services\Admin\Orders;

use App\Models\Order;
use App\Models\OrderGroup;
use Illuminate\Http\Request;

class OrdersService
{
    /** get Processing order list */
    public function getProcessingOrders(Request $request)
    {
        /** @var LengthAwarePaginator */
        $orderGroups = OrderGroup::query()->whereHas('orders', function ($query) {
            $query->where('status', 'registered');
        })->when($request->input('search'), function ($query, $search) {
            $query->where('uuid', 'like', "%{$search}%");
        })->orderBy('created_at', 'desc')->paginate(20);

        $orderGroups = $orderGroups->through(fn($og) => [
            'id' => $og->id,
            'transaction_id' => $og->transaction_id,
            'uuid' => $og->uuid,
            'status' => $og->status,
            'jalali_created_at' => $og->jalali_created_at,
            'jalali_updated_at' => $og->jalali_updated_at,
            'user' => [
                'id' => $og->user->id,
                'get_name' => $og->user->get_name,
            ],
            'orders' => $og->orders->map(fn($order) => [
                'id' => $order->id,
                'transaction_id' => $order->transaction_id,
                'uuid' => $order->uuid,
                'send_by' => $order->send_by,
                'get_send_by' => $order->get_send_by,
                'is_awaiting_request_from_seller' => $order->is_awaiting_request_from_seller,
                'is_awaiting_seller' => $order->is_awaiting_seller,
                'is_awaiting_receipt_from_seller' => $order->is_awaiting_receipt_from_seller,
                'is_ready_to_send' => $order->is_ready_to_send,
                'is_all_item_cancelled' => $order->is_all_item_cancelled,
                'status' => $order->status,
                'jalali_created_at' => $order->jalali_created_at,
                'jalali_updated_at' => $order->jalali_updated_at,
            ]),
        ]);

        $orderGroups->withQueryString();

        return $orderGroups;
    }

    /** get Completed order list */
    public function getCompletedOrders(Request $request)
    {
        /** @var LengthAwarePaginator */
        $orderGroups = OrderGroup::query()->whereDoesntHave('orders', function ($query) {
            $query->where('status', 'registered');
        })->when($request->input('search'), function ($query, $search) {
            $query->where('uuid', 'like', "%{$search}%");
        })->orderBy('created_at', 'desc')->paginate(20);

        $orderGroups = $orderGroups->through(fn($og) => [
            'id' => $og->id,
            'transaction_id' => $og->transaction_id,
            'uuid' => $og->uuid,
            'status' => $og->status,
            'jalali_created_at' => $og->jalali_created_at,
            'jalali_updated_at' => $og->jalali_updated_at,
            'user' => [
                'id' => $og->user->id,
                'get_name' => $og->user->get_name,
            ],
            'orders' => $og->orders->map(fn($order) => [
                'id' => $order->id,
                'transaction_id' => $order->transaction_id,
                'uuid' => $order->uuid,
                'send_by' => $order->send_by,
                'get_send_by' => $order->get_send_by,
                'is_awaiting_request_from_seller' => $order->is_awaiting_request_from_seller,
                'is_awaiting_seller' => $order->is_awaiting_seller,
                'is_awaiting_receipt_from_seller' => $order->is_awaiting_receipt_from_seller,
                'is_ready_to_send' => $order->is_ready_to_send,
                'is_all_item_cancelled' => $order->is_all_item_cancelled,
                'status' => $order->status,
                'jalali_created_at' => $order->jalali_created_at,
                'jalali_updated_at' => $order->jalali_updated_at,
            ]),
        ]);

        $orderGroups->withQueryString();

        return $orderGroups;
    }
}
