<?php

namespace App\Services\Admin\Files;

use App\Models\ArticleTag;
use App\Models\User;
use Illuminate\Http\Request;

class FilesService
{
    /** get article files list */
    public function getFiles(Request $request, User $user)
    {
        /**  @var LengthAwarePaginator */
        $files = $user->files()->where('visibility', 'public')->when($request->input('search'), function ($query, $search) {
            $query->where('id', 'like', "%{$search}%");
        })->when($request->input('images'), function ($query, $images) {
            if ($images) {
                $query->where('type', 'image');
            }
        })->when($request->input('videos'), function ($query, $videos) {
            if ($videos) {
                $query->where('type', 'video');
            }
        })->when($request->input('audius'), function ($query, $audius) {
            if ($audius) {
                $query->where('type', 'audio');
            }
        })->when($request->input('pdf'), function ($query, $pdf) {
            if ($pdf) {
                $query->where('type', 'pdf');
            }
        })->when($request->input('zip'), function ($query, $zip) {
            if ($zip) {
                $query->where('type', 'zip');
            }
        })->orderBy('created_at', 'desc')->paginate(18, ['*'], 'mpage')->through(fn($file) => [
            'id' => $file->id,
            'name' => $file->name,
            'description' => $file->description,
            'type' => $file->type,
            'extension' => $file->extension,
            'size' => $file->size,
            'url' => $file->url,
            'jalali_created_at' => $file->jalali_created_at,
            'status' => $file->status,
        ]);

        $files->withQueryString();

        return $files;
    }
}
