<?php

namespace App\Services\Admin;

use App\Models\Order;
use App\Models\Product;
use App\Models\Statistic;
use Carbon\Carbon;
use Carbon\CarbonPeriod;
use Morilog\Jalali\Jalalian;

class DashboardService
{
    /** get latest orders */
    public function getLatestOrders($count)
    {
        $orders =  Order::where('status', '!=', 'awaiting')
            ->where('status', '!=', 'prefactor')
            ->orderByRaw("FIELD(status , 'registered') desc")
            ->orderBy('created_at', 'desc')
            ->take($count)
            ->get()
            ->map(fn($consignment) => [
                'id' => $consignment->id,
                'uuid' => $consignment->uuid,
                'is_all_item_cancelled' => $consignment->is_all_item_cancelled,
                'is_ready_to_send' => $consignment->is_ready_to_send,
                'is_awaiting_request_from_seller' => $consignment->is_awaiting_request_from_seller,
                'is_awaiting_seller' => $consignment->is_awaiting_seller,
                'is_awaiting_receipt_from_seller' => $consignment->is_awaiting_receipt_from_seller,
                'status' => $consignment->status,
                'jalali_created_at' => $consignment->jalali_created_at,
            ]);

        return $orders;
    }

    /** get most viewed products of Month */
    public function getMostViewedProductsOfMonth($count)
    {
        $products = Product::query()
            ->where('status', 'publish')
            ->orderByRaw("FIELD(status , 'awaiting') DESC")
            ->orderBy('view_count', 'desc')
            ->with('user')
            ->with('user.store')
            ->limit($count)
            ->get()->map(fn($product) => [
                'id' => $product->id,
                'user_id' => $product->user_id,
                'uuid' => $product->uuid,
                'title' => $product->title,
                'slug' => $product->slug,
                'get_images' => $product->get_images,
                'is_vip' => $product->is_vip,
                'get_formatted_view_count' => $product->get_formatted_view_count,
                'status' => $product->status,
                'jalali_updated_at' => $product->jalali_updated_at,

                'user' => [
                    'id' => $product->user->id,
                    'get_name' => $product->user->get_name,
                    'type' => $product->user->type,
                    'seller' => $product->user->seller,
                    'store' => $product->user->store != null ? [
                        'id' => $product->user->store->id,
                        'uuid' => $product->user->store->uuid,
                        'name' => $product->user->store->name,
                    ] : null,
                ],
            ]);

        return $products;
    }
}
