<?php

namespace App\Services\Admin\Blog;

use App\Models\ArticleTag;
use Illuminate\Http\Request;

class ArticleTagsService
{
    /** get article tags list */
    public function getTags(Request $request)
    {
        /** @var LengthAwarePaginator */
        $tags = ArticleTag::query()->where('status', '!=', 'deleted')->when($request->input('search'), function ($query, $search) {
            $query->where('title', 'like', "%{$search}%");
        })->orderBy('created_at', 'desc')->paginate(20);

        $tags->withQueryString();

        return $tags;
    }
}
