<?php

namespace App\Services\Admin\Blog;

use App\Models\ArticleComment;
use Illuminate\Http\Request;

class ArticleCommentsService
{
    /** get article comments list */
    public function getComments(Request $request)
    {
        /** @var LengthAwarePaginator */
        $comments = ArticleComment::query()->when($request->input('awaiting'), function ($query, $awaiting) {
            if ($awaiting) {
                $query->where('status', 'awaiting')->orderBy('created_at', 'asc');
            }
        })->when($request->input('publish'), function ($query, $publish) {
            if ($publish) {
                $query->where('status', 'publish')->orderBy('created_at', 'desc');
            }
        })->orderByRaw("FIELD(status , 'awaiting', 'publish') ASC")->orderBy('created_at', 'desc')->with('user')->with('article')->paginate(10)->through(fn($comment) => [
            'id' => $comment->id,
            'user_id' => $comment->user_id,
            'content' => $comment->content,
            'reply_to' => $comment->reply_to,
            'get_reply_to' => $comment->get_reply_to,
            'vote_up' => $comment->vote_up,
            'vote_down' => $comment->vote_down,
            'jalali_created_at' => $comment->jalali_created_at,
            'status' => $comment->status,
            'article' => [
                'id' => $comment->article->id,
                'title' => $comment->article->title,
                'slug' => $comment->article->slug,
            ],
            'user' => [
                'id' => $comment->user->id,
                'get_name' => $comment->user->get_name,
                'type' => $comment->user->type,
                'seller' => $comment->user->seller,
                'store' => $comment->user->store != null ? [
                    'id' => $comment->user->store->id,
                    'uuid' => $comment->user->store->uuid,
                    'name' => $comment->user->store->name,
                ] : null,
            ],
        ]);

        $comments->withQueryString();

        return $comments;
    }
}
