<?php

namespace App\Notifications;

use App\Channels\SMSChannel;
use App\Models\Withdrawal;
use App\Services\Plugins\Sms\SmsService;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use Morilog\Jalali\Jalalian;

class WithdrawalDeposited extends Notification
{
    use Queueable;

    private Withdrawal $withdrawal;

    /**
     * Create a new notification instance.
     */
    public function __construct(Withdrawal $withdrawal)
    {
        $this->withdrawal = $withdrawal;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['database', SMSChannel::class];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): void
    {
        //
    }

    /**
     * Get the sms representation of the notification.
     */
    public function toSMS(object $notifiable): void
    {
        try {
            SmsService::send($notifiable->phone, 'withdrawalDeposited', ['token' => $this->withdrawal->transaction_id, 'token2' => $this->withdrawal->tracking_code]);
        } catch (\Exception $e) {
        }
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            'message' => __('messages.notification_withdrawal_deposited', ['transaction_id' => $this->withdrawal->transaction_id, 'tracking_code' => $this->withdrawal->tracking_code]),
            'date' => Jalalian::now()->format('H:i - Y/m/d'),
        ];
    }
}
