<?php

namespace App\Notifications;

use App\Channels\SMSChannel;
use App\Models\Withdrawal;
use App\Services\Plugins\Sms\SmsService;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use Morilog\Jalali\Jalalian;

class WithdrawalDeleted extends Notification
{
    use Queueable;

    private Withdrawal $withdrawal;

    /**
     * Create a new notification instance.
     */
    public function __construct(Withdrawal $withdrawal)
    {
        $this->withdrawal = $withdrawal;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['database', SMSChannel::class];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): void
    {
        //
    }

    /**
     * Get the sms representation of the notification.
     */
    public function toSMS(object $notifiable): void
    {
        //
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            'message' => __('messages.notification_withdrawal_deleted', ['transaction_id' => $this->withdrawal->transaction_id, 'reason' => $this->withdrawal->reason]),
            'date' => Jalalian::now()->format('H:i - Y/m/d'),
        ];
    }
}
