<?php

namespace App\Notifications;

use App\Channels\SMSChannel;
use App\Models\Transaction;
use App\Services\Plugins\Sms\SmsService;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use Morilog\Jalali\Jalalian;

class WalletCharge extends Notification
{
    use Queueable;

    private Transaction $transaction;
    private $type;

    /**
     * Create a new notification instance.
     */
    public function __construct(Transaction $transaction, $type = null)
    {
        $this->transaction = $transaction;
        $this->type = $type;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['database', SMSChannel::class];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): void
    {
        //
    }

    /**
     * Get the sms representation of the notification.
     */
    public function toSMS(object $notifiable): void
    {
        if ($this->type == 'cashback') return;

        try {
            SmsService::send($notifiable->phone, 'walletCharge', ['token' => $this->transaction->amount, 'token2' => $this->transaction->transaction_id]);
        } catch (\Exception $e) {
        }
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        if ($this->type == 'cashback') {
            return [
                'message' => __('messages.notification_cashback_charged', ['amount' => number_format($this->transaction->amount), 'transaction_id' => $this->transaction->transaction_id]),
                'date' => Jalalian::now()->format('H:i - Y/m/d'),
            ];
        }

        return [
            'message' => __('messages.notification_wallet_charged', ['amount' => number_format($this->transaction->amount), 'transaction_id' => $this->transaction->transaction_id]),
            'date' => Jalalian::now()->format('H:i - Y/m/d'),
        ];
    }
}
