<?php

namespace App\Notifications;

use App\Channels\SMSChannel;
use App\Models\Ticket;
use App\Services\Plugins\Sms\SmsService;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use Morilog\Jalali\Jalalian;

class Tickets extends Notification
{
    use Queueable;

    private Ticket $ticket;
    private $type;

    /**
     * Create a new notification instance.
     */
    public function __construct(Ticket $ticket, $type)
    {
        $this->ticket = $ticket;
        $this->type = $type;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['database', SMSChannel::class];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): void
    {
        //
    }

    /**
     * Get the sms representation of the notification.
     */
    public function toSMS(object $notifiable): void
    {
        // send normal sms send without pattern
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        $ticketType = null;
        switch ($this->type) {
            case "answer":
                $ticketType = 'messages.notification_ticket_answer';
                break;
            case "closed":
                $ticketType = 'messages.notification_ticket_closed';
                break;
            case "opened":
                $ticketType = 'messages.notification_ticket_opened';
                break;
            case "from_admin":
                $ticketType = 'messages.notification_ticket_from_admin';
                break;
        }

        $ticketParameter = ['ticket' => '<span class="link-to-target link lts-05" target="ticket" parameter="' . $this->ticket->id . '">' . $this->ticket->title . '</span>'];

        if ($ticketType != null) {
            return [
                'message' => __($ticketType, $ticketParameter),
                'date' => Jalalian::now()->format('H:i - Y/m/d'),
            ];
        }
    }
}