<?php

namespace App\Notifications;

use App\Channels\SMSChannel;
use App\Services\Plugins\Sms\SmsService;
use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Morilog\Jalali\Jalalian;

class StoreStatus extends Notification
{
    use Queueable;

    private $type;

    /**
     * Create a new notification instance.
     */
    public function __construct($type)
    {
        $this->type = $type;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['database', SMSChannel::class];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): void
    {
        //
    }

    /**
     * Get the sms representation of the notification.
     */
    public function toSMS(object $notifiable): void
    {
        $status = null;
        switch ($this->type) {
            case "accepted":
                $status = __('messages.word.confirmation');
                break;
            case "rejected":
                $status = __('messages.word.rejection');
                break;
            case "unbanned":
                $status = __('messages.word.unbanned');
                break;
            case "banned":
                $status = __('messages.word.banned');
                break;
        }

        try {
            SmsService::send($notifiable->phone, 'storeStatus', ['token' => $status]);
        } catch (\Exception $e) {
        }
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        $message = null;
        switch ($this->type) {
            case "accepted":
                $message = __("messages.notification_store_accepted");
                break;
            case "rejected":
                $message = __("messages.notification_store_rejected");
                break;
            case "banned":
                $message = __("messages.notification_store_banned");
                break;
            case "unbanned":
                $message = __("messages.notification_store_unbanned");
                break;
        }

        return [
            'message' => $message,
            'date' => Jalalian::now()->format('H:i - Y/m/d'),
        ];
    }
}
