<?php

namespace App\Notifications;

use App\Channels\SMSChannel;
use App\Models\Store;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use Morilog\Jalali\Jalalian;

class StoreDirectPost extends Notification
{
    use Queueable;

    private Store $store;
    private $type;

    /**
     * Create a new notification instance.
     */
    public function __construct(Store $store, $type)
    {
        $this->store = $store;
        $this->type = $type;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['database', SMSChannel::class];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): void
    {
        //
    }

    /**
     * Get the sms representation of the notification.
     */
    public function toSMS(object $notifiable): void
    {
        //
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable)
    {
        if ($this->type == 'activated') {
            return [
                'message' => __('messages.notification_store_direct_post_activated', ['name' => $this->store->name]),
                'date' => Jalalian::now()->format('H:i - Y/m/d'),
            ];
        } else if ($this->type == 'deactivated') {
            return [
                'message' => __('messages.notification_store_direct_post_deactivated', ['name' => $this->store->name]),
                'date' => Jalalian::now()->format('H:i - Y/m/d'),
            ];
        }
    }
}
