<?php

namespace App\Notifications;

use App\Channels\SMSChannel;
use App\Services\Plugins\Sms\SmsService;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use Morilog\Jalali\Jalalian;

class SellerMainStorageSendOrderStatus extends Notification
{
    use Queueable;

    private $order_uuid;
    private $consignment_uuid;
    private $status;

    /**
     * Create a new notification instance.
     */
    public function __construct($order_uuid, $consignment_uuid, $status)
    {
        $this->order_uuid = $order_uuid;
        $this->consignment_uuid = $consignment_uuid;
        $this->status = $status;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['database', SMSChannel::class];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): void
    {
        //
    }

    /**
     * Get the sms representation of the notification.
     */
    public function toSMS(object $notifiable): void
    {
        try {
            SmsService::send($notifiable->phone, 'sellerMainStorageSendOrderStatus', ['token' => $this->consignment_uuid, 'token2' => $this->order_uuid, 'token3' => $this->status]);
        } catch (\Exception $e) {
        }
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            'message' => __('messages.notification_seller_main_storage_send_order_status', ['consignment_id' => $this->consignment_uuid, 'order_id' => $this->order_uuid, 'status' => $this->status]),
            'date' => Jalalian::now()->format('H:i - Y/m/d'),
        ];
    }
}
