<?php

namespace App\Notifications;

use App\Channels\SMSChannel;
use App\Services\Plugins\Sms\SmsService;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class AuthenticationToken extends Notification
{
    use Queueable;

    private string $code;

    /**
     * Create a new notification instance.
     */
    public function __construct(string $code)
    {
        $this->code = $code;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return [SMSChannel::class];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): void
    {
        //
    }

    /**
     * Get the sms representation of the notification.
     */
    public function toSMS(object $notifiable): void
    {
        try {
            SmsService::send($notifiable->phone, 'auth', ['token' => $this->code]);
        } catch (\Exception $e) {
        }
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            //
        ];
    }
}
