<?php

namespace App\Notifications;

use App\Models\Article;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use Morilog\Jalali\Jalalian;

class ArticleStatus extends Notification
{
    use Queueable;

    private Article $article;
    private $type;

    /**
     * Create a new notification instance.
     */
    public function __construct(Article $article, $type)
    {
        $this->article = $article;
        $this->type = $type;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['database'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): void
    {
        //
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable)
    {
        $articleType = null;
        switch ($this->type) {
            case "accept":
                $articleType = 'messages.notification_article_accepted';
                break;
            case "reject":
                $articleType = 'messages.notification_article_rejected';
                break;
        }

        $articleParameter = ['article' => '<span class="link-to-target link lts-05" target="article" parameter="' . $this->article->slug . '">' . $this->article->title . '</span>'];

        if ($articleType != null) {
            return [
                'message' => __($articleType, $articleParameter),
                'date' => Jalalian::now()->format('H:i - Y/m/d'),
            ];
        }
    }
}
