<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Morilog\Jalali\Jalalian;

class Statistic extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'user_id',
        'id',
        'platform',
        'service',
        'ip',
        'url',
        'agent',
        'os',
        'browser',
    ];

    protected $casts = [
        'user_id' => 'integer',
    ];

    /**
     * additional data
     */
    protected $appends = [
        'get_user',
        'get_platform',
        'get_service',
        'jalali_created_at',
        'jalali_updated_at',
    ];

    public function getGetUserAttribute()
    {
        return $this->user != null ? [
            'type' => 'user',
            'id' => $this->user->id,
            'name' => $this->user->get_name,
        ] : [
            'type' => 'guest',
            'id' => null,
            'name' => __('messages.word.guest'),
        ];
    }

    public function getGetPlatformAttribute()
    {
        return $this->platform == "shop" ? __("messages.word.shop") : ($this->platform == "blog" ? __("messages.word.blog") : "-");
    }

    public function getGetServiceAttribute()
    {
        $service = '-';
        if ($this->service == 'index') {
            $service = __('messages.sentence.shop_index');
        } else if ($this->service == 'blog_index') {
            $service = __('messages.sentence.blog_index');
        } else if ($this->service == 'product') {
            $service = __('messages.word.product');
        } else if ($this->service == 'products') {
            $service = __('messages.sentence.product_archive');
        } else if ($this->service == 'article') {
            $service = __('messages.word.article');
        } else if ($this->service == 'articles') {
            $service = __('messages.sentence.article_archive');
        } else if ($this->service == 'page') {
            $service = __('messages.word.page');
        } else if ($this->service == 'form') {
            $service = __('messages.word.form');
        } else if ($this->service == 'brand') {
            $service = __('messages.word.brand');
        } else if ($this->service == 'store') {
            $service = __('messages.sentence.seller_page');
        } else if ($this->service == 'compare') {
            $service = __('messages.sentence.compare_products');
        } else if ($this->service == 'cart') {
            $service = __('messages.word.cart');
        } else if ($this->service == 'user') {
            $service = __('messages.sentence.user_panel');
        } else if ($this->service == 'seller') {
            $service = __('messages.sentence.seller_panel');
        } else if ($this->service == 'admin') {
            $service = __('messages.sentence.admin_panel');
        }

        return $service;
    }

    public function getJalaliCreatedAtAttribute()
    {
        $date = [
            Jalalian::forge($this->created_at)->format('%d %B %Y'),
            Jalalian::forge($this->created_at)->format('Y/m/d'),
            Jalalian::forge($this->created_at)->format('H:i - Y/m/d'),
            Jalalian::forge($this->created_at)->ago(),
            Jalalian::forge($this->created_at)->getTimestamp(),
        ];
        return $date;
    }

    public function getJalaliUpdatedAtAttribute()
    {
        $date = [
            Jalalian::forge($this->updated_at)->format('%d %B %Y'),
            Jalalian::forge($this->updated_at)->format('Y/m/d'),
            Jalalian::forge($this->updated_at)->format('H:i - Y/m/d'),
            Jalalian::forge($this->updated_at)->ago(),
            Jalalian::forge($this->updated_at)->getTimestamp(),
        ];
        return $date;
    }
    /** end append */

    /* relationships **************/
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
}
