<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Support\Facades\Cache;

class ProductProp extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'product_id',
        'child',
        'name',
        'type',
    ];

    protected $casts = [
        'product_id' => 'integer',
    ];

    /**
     * remove cache data in update
     */
    protected static function boot()
    {
        parent::boot();

        static::saved(function ($productProp) {
            Cache::forget('product_props_' . $productProp->product_id);
        });

        static::deleted(function ($productProp) {
            Cache::forget('product_props_' . $productProp->product_id);
        });
    }

    /* relationships **************/
    public function product(): BelongsTo
    {
        return $this->belongsTo(Product::class);
    }
}
