<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Support\Facades\Cache;

class ProductNotification extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'user_id',
        'product_id',
        'type',
    ];

    protected $casts = [
        'user_id' => 'integer',
        'product_id' => 'integer',
    ];

    protected $primaryKey = ['product_id', 'user_id'];
    public $incrementing = false;
    protected $keyType = 'string';

    protected function setKeysForSaveQuery($query)
    {
        $keys = $this->getKeyName();
        if (!is_array($keys)) {
            $keys = [$keys];
        }
        foreach ($keys as $key) {
            $query->where($key, '=', $this->getAttribute($key));
        }
        return $query;
    }

    public function getKeyName()
    {
        return $this->primaryKey;
    }

    /**
     * remove cache data in update
     */
    protected static function boot()
    {
        parent::boot();

        static::saved(function ($notification) {
            Cache::forget('product_has_inventory_notification_' . $notification->product_id . '_' . $notification->user_id);
            Cache::forget('product_has_discount_notification_' . $notification->product_id . '_' . $notification->user_id);
        });

        static::deleted(function ($notification) {
            Cache::forget('product_has_inventory_notification_' . $notification->product_id . '_' . $notification->user_id);
            Cache::forget('product_has_discount_notification_' . $notification->product_id . '_' . $notification->user_id);
        });
    }

    /* relationships **************/
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function product(): BelongsTo
    {
        return $this->belongsTo(Product::class);
    }
}
