<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Morilog\Jalali\Jalalian;

class Prefactor extends Model
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'user_id',
        'order_id',
        'order_group_id',
        'by',
        'uuid',
        'title',
        'status',
        'expired_at',
    ];

    protected $casts = [
        'user_id' => 'integer',
        'order_id' => 'integer',
        'order_group_id' => 'integer',
        'by' => 'integer',
    ];

    /**
     * additional data
     */
    protected $appends = [
        'get_by',
        'is_expired',
        'jalali_expired_at',
        'jalali_created_at',
        'jalali_updated_at',
    ];

    public function getGetByAttribute()
    {
        $by = User::find($this->by);
        return $by != null ? [
            'id' => $by->id,
            'get_name' => $by->get_name,
        ] : null;
    }

    public function getIsExpiredAttribute()
    {
        return $this->expired_at >= Carbon::now()->toDateString() ? false : true;
    }

    public function getJalaliExpiredAtAttribute()
    {
        $date = [
            Jalalian::forge($this->expired_at)->format('%d %B %Y'),
            Jalalian::forge($this->expired_at)->format('Y/m/d'),
            Jalalian::forge($this->expired_at)->format('H:i - Y/m/d'),
            Jalalian::forge($this->expired_at)->ago(),
            Jalalian::forge($this->expired_at)->getTimestamp(),
        ];
        return $date;
    }

    public function getJalaliCreatedAtAttribute()
    {
        $date = [
            Jalalian::forge($this->created_at)->format('%d %B %Y'),
            Jalalian::forge($this->created_at)->format('Y/m/d'),
            Jalalian::forge($this->created_at)->format('H:i - Y/m/d'),
            Jalalian::forge($this->created_at)->ago(),
            Jalalian::forge($this->created_at)->getTimestamp(),
        ];
        return $date;
    }

    public function getJalaliUpdatedAtAttribute()
    {
        $date = [
            Jalalian::forge($this->updated_at)->format('%d %B %Y'),
            Jalalian::forge($this->updated_at)->format('Y/m/d'),
            Jalalian::forge($this->updated_at)->format('H:i - Y/m/d'),
            Jalalian::forge($this->updated_at)->ago(),
            Jalalian::forge($this->updated_at)->getTimestamp(),
        ];
        return $date;
    }

    /* relationships **************/
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function order(): BelongsTo
    {
        return $this->belongsTo(Order::class);
    }

    public function orderGroup(): BelongsTo
    {
        return $this->belongsTo(OrderGroup::class);
    }
}
