<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class InventoryProp extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'inventory_id',
        'child',
        'name',
        'type',
        'value',
    ];

    protected $casts = [
        'inventory_id' => 'integer',
        'child' => 'integer',
    ];

    /* relationships **************/
    public function inventory(): BelongsTo
    {
        return $this->belongsTo(Inventory::class);
    }
}
